/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.screenplay.questions;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.serenitybdd.core.pages.WebElementFacade;
import net.serenitybdd.core.pages.WebElementState;
import net.serenitybdd.screenplay.Question;
import net.serenitybdd.screenplay.abilities.BrowseTheWeb;
import net.serenitybdd.screenplay.targets.Target;
import org.openqa.selenium.By;

public class Visibility {
    public static Question<Boolean> of(Target target) {
        return Question.about((String)("visibility of " + target.getName())).answeredBy(actor -> Visibility.matches((List<WebElementFacade>)target.resolveAllFor(actor)));
    }

    public static Question<Boolean> of(By byLocator) {
        return Question.about((String)("visibility of element located by " + byLocator)).answeredBy(actor -> Visibility.matches((List<WebElementFacade>)BrowseTheWeb.as(actor).findAll(byLocator)));
    }

    public static Question<Boolean> of(String locator) {
        return Question.about((String)("visibility of " + locator)).answeredBy(actor -> Visibility.matches((List<WebElementFacade>)BrowseTheWeb.as(actor).findAll(locator, new Object[0])));
    }

    public static Question<List<Boolean>> ofEach(Target target) {
        return Question.about((String)("visibility of each " + target.getName())).answeredBy(actor -> target.resolveAllFor(actor).stream().map(element -> Visibility.matches(Collections.singletonList(element))).collect(Collectors.toList()));
    }

    public static Question<List<Boolean>> ofEach(By byLocator) {
        return Question.about((String)("visibility of element located by " + byLocator)).answeredBy(actor -> BrowseTheWeb.as(actor).findAll(byLocator).stream().map(element -> Visibility.matches(Collections.singletonList(element))).collect(Collectors.toList()));
    }

    public static Question<List<Boolean>> ofEach(String locator) {
        return Question.about((String)("visibility of each" + locator)).answeredBy(actor -> BrowseTheWeb.as(actor).findAll(locator, new Object[0]).stream().map(element -> Visibility.matches(Collections.singletonList(element))).collect(Collectors.toList()));
    }

    private static boolean matches(List<WebElementFacade> elements) {
        return elements.stream().findFirst().map(WebElementState::isVisible).orElse(false);
    }
}

