/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.screenplay.ui;

import net.serenitybdd.core.i8n.LocalisedLabels;
import net.serenitybdd.screenplay.targets.SearchableTarget;
import net.serenitybdd.screenplay.targets.Target;
import net.serenitybdd.screenplay.ui.LocatorStrategies;
import net.serenitybdd.screenplay.ui.TargetFactory;
import org.openqa.selenium.By;

public class Button {
    private static final String ARIA_LABEL = "input[type='button'][aria-label='{0}' i],input[type='submit'][aria-label='{0}' i],button[aria-label='{0}' i]";
    private static final String BUTTON_WITH_TEXT = ".//button[contains(normalize-space(.),'{0}')]";
    private static final String[] LOCATORS = new String[]{"xpath:.//button[translate(normalize-space(.),'ABCDEFGHIJKLMNOPQRSTUVWXYZ','abcdefghijklmnopqrstuvwxyz')=translate('{0}','ABCDEFGHIJKLMNOPQRSTUVWXYZ','abcdefghijklmnopqrstuvwxyz')]", "css:input[type='submit'][value='{0}' i],input[type='submit'][id='{0}' i],input[type='submit'][data-test='{0}' i],input[type='submit'][name='{0}' i],input[type='button'][value='{0}' i],input[type='button'][id='{0}' i],input[type='button'][data-test='{0}' i],input[type='button'][name='{0}' i],input[type='button'][aria-label='{0}' i],input[type='submit'][aria-label='{0}' i],button[aria-label='{0}' i],input[class*='{0}' i]"};
    private static final String WITH_NAME_OR_ID = "css:input[type='submit'][type='button'][id='{0}' i],input[type='submit'],[type='button'][name='{0}' i],input[type='submit'][type='button'][data-test='{0}' i],input[type='submit'][type='button'][aria-label='{0}' i],button[id='{0}' i],button[name='{0}' i],button[data-test='{0}' i],button[aria-label='{0}' i]";
    private static final String[] WITH_TEXT = new String[]{"xpath:.//button[translate(normalize-space(.),'ABCDEFGHIJKLMNOPQRSTUVWXYZ','abcdefghijklmnopqrstuvwxyz')=translate('{0}','ABCDEFGHIJKLMNOPQRSTUVWXYZ','abcdefghijklmnopqrstuvwxyz')]", "xpath:.//*[contains(@class,'button')][translate(normalize-space(.),'ABCDEFGHIJKLMNOPQRSTUVWXYZ','abcdefghijklmnopqrstuvwxyz')=translate('{0}','ABCDEFGHIJKLMNOPQRSTUVWXYZ','abcdefghijklmnopqrstuvwxyz')]", "css:input[type='submit'][value='{0}' i],input[type='button'][value='{0}' i]"};
    private static final String BY_ICON = ".//button[./i[contains(@class,'{0}')]]";

    public static SearchableTarget withText(String name) {
        return Target.the("'" + name + "' button").locatedByFirstMatching(WITH_TEXT).of(name);
    }

    public static SearchableTarget withNameOrId(String nameOrId) {
        return Target.the("'" + nameOrId + "' button").locatedByFirstMatching(WITH_NAME_OR_ID).of(nameOrId);
    }

    public static SearchableTarget withLocalisedLabelFor(String name) {
        String localisedName = LocalisedLabels.forCurrentLocale().getLabelFor(name);
        return Target.the("'" + localisedName + "' button").locatedByFirstMatching(LOCATORS).of(localisedName);
    }

    public static SearchableTarget withLabel(String labelText) {
        return Target.the(labelText + " field").locatedBy(LocatorStrategies.fieldWithLabel(labelText));
    }

    public static SearchableTarget withAriaLabel(String name) {
        return Target.the("'" + name + "' button").locatedByFirstMatching("css:input[type='button'][aria-label='{0}' i],input[type='submit'][aria-label='{0}' i],button[aria-label='{0}' i]").of(name);
    }

    public static SearchableTarget withIcon(String icon) {
        return Target.the("Button with icon '" + icon + "'").locatedByFirstMatching(BY_ICON).of(icon);
    }

    public static SearchableTarget withCSSClass(String className) {
        return TargetFactory.forElementOfType("element").withCSSClass(className);
    }

    public static SearchableTarget containingText(String text) {
        return Target.the("button containing '" + text + "'").locatedByFirstMatching(BUTTON_WITH_TEXT).of(text);
    }

    public static SearchableTarget locatedBy(String selector) {
        return TargetFactory.forElementOfType("button").locatedByXPathOrCss(selector);
    }

    public static SearchableTarget located(By selector) {
        return TargetFactory.forElementOfType("button").locatedBy(selector);
    }
}

