/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.screenplay.actions;

import java.util.List;
import net.serenitybdd.core.pages.WebElementFacade;
import net.serenitybdd.model.collect.NewList;
import net.serenitybdd.screenplay.Actor;
import net.serenitybdd.screenplay.Performable;
import net.serenitybdd.screenplay.abilities.BrowseTheWeb;
import net.serenitybdd.screenplay.actions.ChainablePerformable;
import net.serenitybdd.screenplay.actions.WebElementLocator;
import net.serenitybdd.screenplay.targets.Target;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.interactions.Actions;

public class ClickAndHold {
    public static Performable on(String cssOrXpathForElement) {
        return new ClickAndHoldCSSOrXPath(cssOrXpathForElement);
    }

    public static Performable on(By locator) {
        return new ClickAndHoldBy(locator);
    }

    public static Performable on(Target target) {
        return new ClickAndHoldTarget(target);
    }

    public static Performable on(WebElementFacade element) {
        return new ClickAndHoldElement((WebElement)element);
    }

    public static class ClickAndHoldCSSOrXPath
    extends ChainablePerformable {
        private final String cssOrXPath;

        public ClickAndHoldCSSOrXPath(String cssOrXPath) {
            this.cssOrXPath = cssOrXPath;
        }

        public <T extends Actor> void performAs(T actor) {
            WebElementFacade element = BrowseTheWeb.as(actor).find(this.cssOrXPath);
            this.addActionAtStart(arg_0 -> ClickAndHoldCSSOrXPath.lambda$performAs$0((WebElement)element, arg_0));
            this.performSubsequentActionsAs(actor);
        }

        private static /* synthetic */ void lambda$performAs$0(WebElement element, Actions actions) {
            actions.clickAndHold(element);
        }
    }

    public static class ClickAndHoldBy
    extends ChainablePerformable {
        private final List<By> locators;

        public ClickAndHoldBy(By ... locators) {
            this.locators = NewList.copyOf((Object[])locators);
        }

        public <T extends Actor> void performAs(T actor) {
            WebElement element = WebElementLocator.forLocators(this.locators).andActor(actor);
            this.addActionAtStart(actions -> actions.clickAndHold(element));
            this.performSubsequentActionsAs(actor);
        }
    }

    public static class ClickAndHoldTarget
    extends ChainablePerformable {
        private final Target target;

        public ClickAndHoldTarget(Target target) {
            this.target = target;
        }

        public <T extends Actor> void performAs(T actor) {
            WebElementFacade element = this.target.resolveFor(actor);
            this.addActionAtStart(arg_0 -> ClickAndHoldTarget.lambda$performAs$0((WebElement)element, arg_0));
            this.performSubsequentActionsAs(actor);
        }

        private static /* synthetic */ void lambda$performAs$0(WebElement element, Actions actions) {
            actions.clickAndHold(element);
        }
    }

    public static class ClickAndHoldElement
    extends ChainablePerformable {
        private final WebElement element;

        public ClickAndHoldElement(WebElement element) {
            this.element = element;
        }

        public <T extends Actor> void performAs(T actor) {
            this.addActionAtStart(actions -> actions.clickAndHold(this.element));
            this.performSubsequentActionsAs(actor);
        }
    }
}

