/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.screenplay.questions;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.serenitybdd.core.pages.WebElementFacade;
import net.serenitybdd.screenplay.Question;
import net.serenitybdd.screenplay.abilities.BrowseTheWeb;
import net.serenitybdd.screenplay.targets.Target;
import org.openqa.selenium.By;
import org.openqa.selenium.Point;
import org.openqa.selenium.WebElement;

public class TheLocation {
    public static Question<Point> of(Target target) {
        return Question.about((String)("location of " + target.getName())).answeredBy(actor -> TheLocation.matches((List<WebElementFacade>)target.resolveAllFor(actor)));
    }

    public static Question<Point> of(By byLocator) {
        return Question.about((String)("location of element located by " + String.valueOf(byLocator))).answeredBy(actor -> TheLocation.matches((List<WebElementFacade>)BrowseTheWeb.as(actor).findAll(byLocator)));
    }

    public static Question<Point> of(String locator) {
        return Question.about((String)("location of " + locator)).answeredBy(actor -> TheLocation.matches((List<WebElementFacade>)BrowseTheWeb.as(actor).findAll(locator, new Object[0])));
    }

    public static Question<List<Point>> ofEach(Target target) {
        return Question.about((String)("location of each of " + target.getName())).answeredBy(actor -> target.resolveAllFor(actor).stream().map(element -> TheLocation.matches(Collections.singletonList(element))).collect(Collectors.toList()));
    }

    public static Question<List<Point>> ofEach(By byLocator) {
        return Question.about((String)("location of each of element located by " + String.valueOf(byLocator))).answeredBy(actor -> BrowseTheWeb.as(actor).findAll(byLocator).stream().map(element -> TheLocation.matches(Collections.singletonList(element))).collect(Collectors.toList()));
    }

    public static Question<List<Point>> ofEach(String locator) {
        return Question.about((String)("location of each of " + locator)).answeredBy(actor -> BrowseTheWeb.as(actor).findAll(locator, new Object[0]).stream().map(element -> TheLocation.matches(Collections.singletonList(element))).collect(Collectors.toList()));
    }

    private static Point matches(List<WebElementFacade> elements) {
        return elements.stream().findFirst().map(WebElement::getLocation).orElse(null);
    }
}

