/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.screenplay.targets;

import java.time.Duration;
import java.util.List;
import java.util.Optional;
import net.serenitybdd.screenplay.targets.HasByLocator;
import net.serenitybdd.screenplay.targets.IFrame;
import net.serenitybdd.screenplay.targets.Target;
import net.serenitybdd.screenplay.ui.LocatorStrategies;
import org.openqa.selenium.By;

public abstract class SearchableTarget
extends Target {
    public SearchableTarget(String targetElementName, Optional<IFrame> iFrame) {
        super(targetElementName, iFrame);
    }

    public SearchableTarget(String targetElementName, Optional<IFrame> iFrame, Optional<Duration> timeout) {
        super(targetElementName, iFrame, timeout);
    }

    public abstract List<String> getCssOrXPathSelectors();

    public SearchableTarget containingText(String text) {
        if (this instanceof HasByLocator) {
            By byLocator = ((HasByLocator)((Object)this)).getLocator();
            return Target.the(this.getName() + " located by '" + String.valueOf(byLocator) + "' and containing text '" + text + "'").locatedBy(LocatorStrategies.containingTextAndBy(byLocator, text));
        }
        return Target.the(this.getName() + " containing text '" + text + "'").locatedBy(LocatorStrategies.containingTextAndMatchingCSS(this.getCssOrXPathSelectors(), text));
    }

    public SearchableTarget containingTextIgnoringCase(String text) {
        if (this instanceof HasByLocator) {
            By byLocator = ((HasByLocator)((Object)this)).getLocator();
            return Target.the(this.getName() + " located by '" + String.valueOf(byLocator) + "' and containing text '" + text + "'").locatedBy(LocatorStrategies.containingTextAndByIgnoringCase(byLocator, text));
        }
        return Target.the(this.getName() + " containing text '" + text + "'").locatedBy(LocatorStrategies.containingTextAndMatchingCSSIgnoringCase(this.getCssOrXPathSelectors(), text));
    }
}

