/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.screenplay;

import java.util.ArrayList;
import java.util.function.Predicate;
import net.serenitybdd.screenplay.Actor;
import net.serenitybdd.screenplay.BooleanQuestionConsequence;
import net.serenitybdd.screenplay.Consequence;
import net.serenitybdd.screenplay.Performable;
import net.serenitybdd.screenplay.PerformsTasks;
import net.serenitybdd.screenplay.PredicateConsequence;
import net.serenitybdd.screenplay.Question;
import net.serenitybdd.screenplay.QuestionConsequence;
import net.serenitybdd.screenplay.Task;
import net.serenitybdd.screenplay.questions.ConsequenceGroup;
import net.serenitybdd.screenplay.questions.NamedPredicate;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;

public class GivenWhenThen {
    public static <T extends PerformsTasks> T givenThat(T actor) {
        return actor;
    }

    public static Actor andThat(Actor actor) {
        return actor;
    }

    public static Actor when(Actor actor) {
        return actor;
    }

    public static Actor then(Actor actor) {
        return actor;
    }

    public static Actor and(Actor actor) {
        return actor;
    }

    public static Actor but(Actor actor) {
        return actor;
    }

    public static <T> void then(T actual, Matcher<? super T> matcher) {
        MatcherAssert.assertThat(actual, matcher);
    }

    public static <T> Consequence<T> seeThat(Question<? extends T> actual, Matcher<T> expected) {
        return new QuestionConsequence<T>(actual, expected);
    }

    public static <T> Consequence<T> seeThat(Question<? extends T> actual, Predicate<T> expected) {
        return new PredicateConsequence<T>(actual, expected);
    }

    public static <T> Consequence<T> seeThat(String subject, Question<? extends T> actual, Predicate<T> expected) {
        return new PredicateConsequence<T>(subject, actual, expected);
    }

    public static <T> Consequence<T> seeThat(String subject, Question<? extends T> actual, Matcher<T> expected) {
        return new QuestionConsequence<T>(subject, actual, expected);
    }

    public static <T> Consequence<T> seeThat(Question<Boolean> actual) {
        return new BooleanQuestionConsequence(actual);
    }

    public static <T> Consequence<T> seeThat(String subject, Question<Boolean> actual) {
        return new BooleanQuestionConsequence(subject, actual);
    }

    public static <T> Consequence<T>[] seeThat(Question<? extends T> actual, Matcher<T> ... expectedMatchers) {
        if (GivenWhenThen.thereAreNo(expectedMatchers)) {
            return GivenWhenThen.consequenceGroupFor(actual);
        }
        return GivenWhenThen.consequencesForEachMatcher(actual, expectedMatchers);
    }

    private static <T> Consequence<T>[] consequenceGroupFor(Question<? extends T> actual) {
        return new Consequence[]{new ConsequenceGroup(actual)};
    }

    private static <T> Consequence<T>[] consequencesForEachMatcher(Question<? extends T> actual, Matcher<T>[] expectedMatchers) {
        ArrayList<QuestionConsequence<? extends T>> consequences = new ArrayList<QuestionConsequence<? extends T>>();
        for (Matcher<T> matcher : expectedMatchers) {
            consequences.add(new QuestionConsequence<T>(actual, matcher));
        }
        return consequences.toArray(new Consequence[0]);
    }

    private static <T> boolean thereAreNo(Matcher<T>[] expectedMatchers) {
        return expectedMatchers.length == 0;
    }

    public static <T> Consequence<T>[] seeThat(String subject, Question<? extends T> actual, Matcher<T> ... expectedMatchers) {
        ArrayList<QuestionConsequence<? extends T>> consequences = new ArrayList<QuestionConsequence<? extends T>>();
        for (Matcher<T> matcher : expectedMatchers) {
            consequences.add(new QuestionConsequence<T>(subject, actual, matcher));
        }
        return consequences.toArray(new Consequence[0]);
    }

    public static <T> Task seeIf(Question<T> question, Matcher<T> matcher) {
        Consequence<T> consequence = GivenWhenThen.seeThat(question, matcher);
        Performable[] performableArray = new Performable[1];
        performableArray[0] = consequence::evaluateFor;
        return Task.where((String)("See if " + question.toString() + " " + matcher.toString()), (Performable[])performableArray);
    }

    public static <T> NamedPredicate<T> returnsAValueThat(String name, Predicate<T> predicate) {
        return new NamedPredicate<T>(name, predicate);
    }
}

