/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.screenplay.actors;

import com.google.common.base.Splitter;
import java.util.List;
import net.serenitybdd.screenplay.Actor;
import net.serenitybdd.screenplay.Performable;
import net.serenitybdd.screenplay.actors.Cast;
import net.serenitybdd.screenplay.actors.NoStageException;
import net.serenitybdd.screenplay.actors.Stage;
import net.thucydides.model.ThucydidesSystemProperty;
import net.thucydides.model.environment.SystemEnvironmentVariables;
import net.thucydides.model.util.EnvironmentVariables;

public class OnStage {
    private static final String DEFAULT_PRONOUNS = "he,she,they,it,his,her,their,its";
    private static final String A_NEW_ACTOR = "An actor";
    private static final ThreadLocal<Stage> STAGE = new ThreadLocal();

    public static Stage setTheStage(Cast cast) {
        STAGE.set(new Stage(cast));
        return OnStage.stage();
    }

    public static boolean theStageIsSet() {
        return STAGE.get() != null;
    }

    public static Stage setTheStage(Stage stage) {
        STAGE.set(stage);
        return OnStage.stage();
    }

    public static Actor theActorCalled(String requiredActor) {
        boolean theActorIsReferredToByAPronoun = OnStage.pronouns().stream().anyMatch(pronoun -> pronoun.equalsIgnoreCase(requiredActor));
        if (theActorIsReferredToByAPronoun) {
            return OnStage.stage().theActorInTheSpotlight().usingPronoun(requiredActor);
        }
        if (OnStage.anActorIsOnStage() && OnStage.theActorInTheSpotlight().getName().equals(A_NEW_ACTOR)) {
            OnStage.theActorInTheSpotlight().assignName(requiredActor);
            return OnStage.theActorInTheSpotlight();
        }
        return OnStage.stage().shineSpotlightOn(requiredActor);
    }

    private static boolean anActorIsOnStage() {
        return OnStage.stage().anActorIsOnStage();
    }

    public static Actor aNewActor() {
        return OnStage.stage().shineSpotlightOn(A_NEW_ACTOR);
    }

    public static Actor theActor(String actorName) {
        return OnStage.theActorCalled(actorName);
    }

    public static Actor theActorInTheSpotlight() {
        return OnStage.stage().theActorInTheSpotlight();
    }

    public static void withCurrentActor(Performable ... performTasks) {
        OnStage.theActorInTheSpotlight().attemptsTo(performTasks);
    }

    public static Stage stage() {
        if (STAGE.get() == null) {
            throw new NoStageException("No stage available - it looks like you haven't called the setTheStage() method before calling this one.");
        }
        return STAGE.get();
    }

    public static void drawTheCurtain() {
        if (STAGE.get() != null) {
            OnStage.stage().drawTheCurtain();
        }
    }

    private static List<String> pronouns() {
        EnvironmentVariables environmentVariables = SystemEnvironmentVariables.currentEnvironmentVariables();
        return Splitter.on((String)",").trimResults().omitEmptyStrings().splitToList((CharSequence)ThucydidesSystemProperty.SCREENPLAY_PRONOUNS.from(environmentVariables, DEFAULT_PRONOUNS));
    }
}

