/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.screenplay;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.serenitybdd.screenplay.Actor;
import net.serenitybdd.screenplay.Performable;

public class CompositePerformable
implements Performable {
    private final List<Performable> todoList;

    private CompositePerformable(List<Performable> todoList) {
        this.todoList = todoList;
    }

    public static Performable from(Performable firstPerformable, Performable nextPerformable) {
        ArrayList<Performable> todoList = new ArrayList<Performable>();
        todoList.addAll(CompositePerformable.flattened(firstPerformable));
        todoList.addAll(CompositePerformable.flattened(nextPerformable));
        return new CompositePerformable(todoList);
    }

    @Override
    public <T extends Actor> void performAs(T actor) {
        this.todoList.forEach(xva$0 -> actor.attemptsTo((Performable)xva$0));
    }

    private static List<Performable> flattened(Performable performable) {
        if (performable instanceof CompositePerformable) {
            return ((CompositePerformable)performable).todoList;
        }
        return Collections.singletonList(performable);
    }
}

