/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.reports.model;

import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.serenitybdd.core.environment.EnvironmentSpecificConfiguration;
import net.serenitybdd.reports.model.DurationBucket;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.model.TestOutcome;
import net.thucydides.core.model.TestTag;
import net.thucydides.core.reports.TestOutcomes;
import net.thucydides.core.util.EnvironmentVariables;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010!\n\u0002\b\b\u0018\u0000 32\u00020\u0001:\u00013B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0014\u0010\u0013\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00010\bJ\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u000e\u0010\u0016\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\u001bJ\u000e\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0002J\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00140\bJ\u0016\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\r0\b2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u000e\u0010\u001f\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\rJ\u0016\u0010 \u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\r2\u0006\u0010!\u001a\u00020\u0014J\u0006\u0010\"\u001a\u00020\u0017J\u0006\u0010#\u001a\u00020\u0014J\f\u0010$\u001a\b\u0012\u0004\u0012\u00020%0\bJ\u0006\u0010&\u001a\u00020\u0014J\u000e\u0010'\u001a\u00020\u00142\u0006\u0010(\u001a\u00020\u0019J\u000e\u0010)\u001a\u00020\u00142\u0006\u0010(\u001a\u00020\u0019J\u0016\u0010*\u001a\u00020\u00172\f\u0010+\u001a\b\u0012\u0004\u0012\u00020\u001b0,H\u0002J\u000e\u0010-\u001a\u00020\u00142\u0006\u0010(\u001a\u00020\u0019J\u000e\u0010.\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\rJ\u000e\u0010/\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\rJ\u000e\u00100\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\rJ\u000e\u00101\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\rJ\u0016\u00102\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\r2\u0006\u0010!\u001a\u00020\u0014R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u00064"}, d2={"Lnet/serenitybdd/reports/model/DurationDistribution;", "", "environmentVariables", "Lnet/thucydides/core/util/EnvironmentVariables;", "testOutcomes", "Lnet/thucydides/core/reports/TestOutcomes;", "(Lnet/thucydides/core/util/EnvironmentVariables;Lnet/thucydides/core/reports/TestOutcomes;)V", "durationBuckets", "", "Lnet/serenitybdd/reports/model/DurationBucket;", "getDurationBuckets", "()Ljava/util/List;", "durationLimits", "Ljava/time/Duration;", "getDurationLimits", "getEnvironmentVariables", "()Lnet/thucydides/core/util/EnvironmentVariables;", "getTestOutcomes", "()Lnet/thucydides/core/reports/TestOutcomes;", "asFormattedList", "", "labels", "bucketFor", "", "duration", "", "testOutcome", "Lnet/thucydides/core/model/TestOutcome;", "calculateDurationBuckets", "distributionLabels", "durationLimitsDefinedIn", "formatted", "formattedWithUnit", "unit", "getBucketCount", "getBucketLabels", "getDurationTags", "Lnet/thucydides/core/model/TestTag;", "getNumberOfTestsPerDuration", "hours", "value", "minutes", "numberOfScenariosIn", "outcomes", "", "seconds", "toHoursPart", "toMinutesPart", "toSecondsPart", "unitOf", "valueOf", "Companion", "serenity-stats"})
public final class DurationDistribution {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final EnvironmentVariables environmentVariables;
    @NotNull
    private final TestOutcomes testOutcomes;
    @NotNull
    private final List<Duration> durationLimits;
    @NotNull
    private final List<DurationBucket> durationBuckets;
    @NotNull
    public static final String DEFAULT_DURATION_RANGES_IN_SECONDS = "1, 10, 30, 60, 120, 300, 600";

    public DurationDistribution(@NotNull EnvironmentVariables environmentVariables, @NotNull TestOutcomes testOutcomes) {
        Intrinsics.checkNotNullParameter((Object)environmentVariables, (String)"environmentVariables");
        Intrinsics.checkNotNullParameter((Object)testOutcomes, (String)"testOutcomes");
        this.environmentVariables = environmentVariables;
        this.testOutcomes = testOutcomes;
        this.durationLimits = this.durationLimitsDefinedIn(this.environmentVariables);
        this.durationBuckets = this.calculateDurationBuckets();
    }

    @NotNull
    public final EnvironmentVariables getEnvironmentVariables() {
        return this.environmentVariables;
    }

    @NotNull
    public final TestOutcomes getTestOutcomes() {
        return this.testOutcomes;
    }

    @NotNull
    public final List<Duration> getDurationLimits() {
        return this.durationLimits;
    }

    @NotNull
    public final List<DurationBucket> getDurationBuckets() {
        return this.durationBuckets;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String getNumberOfTestsPerDuration() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.durationBuckets;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void bucket;
            DurationBucket durationBucket = (DurationBucket)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.numberOfScenariosIn(bucket.getOutcomes()));
        }
        List durationCounts = (List)destination$iv$iv;
        return this.asFormattedList(durationCounts);
    }

    /*
     * WARNING - void declaration
     */
    private final int numberOfScenariosIn(List<TestOutcome> outcomes) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = outcomes;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void outcome;
            TestOutcome testOutcome = (TestOutcome)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(outcome.getTestCount());
        }
        return CollectionsKt.sumOfInt((Iterable)((List)destination$iv$iv));
    }

    private final List<DurationBucket> calculateDurationBuckets() {
        List durationBuckets = new ArrayList();
        List<String> bucketLabels = this.distributionLabels();
        Iterator iterator = CollectionsKt.plus((Collection)this.durationLimits, (Object)Duration.ofSeconds(Long.MAX_VALUE)).iterator();
        int n = 0;
        while (iterator.hasNext()) {
            int index = n++;
            Duration durationLimit = (Duration)iterator.next();
            durationBuckets.add(new DurationBucket(bucketLabels.get(index), durationLimit.get(ChronoUnit.SECONDS), new ArrayList()));
        }
        for (TestOutcome testOutcome : this.testOutcomes.getTests()) {
            int bucket = this.bucketFor((long)testOutcome.getDurationInSeconds());
            DurationBucket durationBucket = (DurationBucket)durationBuckets.get(bucket);
            Intrinsics.checkNotNullExpressionValue((Object)testOutcome, (String)"testOutcome");
            durationBucket.addOutcome(testOutcome);
        }
        return durationBuckets;
    }

    private final int bucketFor(long duration) {
        int bucketNumber = 0;
        for (Duration durationLimit : this.durationLimits) {
            if (duration < durationLimit.getSeconds()) {
                return bucketNumber;
            }
            int n = bucketNumber;
            bucketNumber = n + 1;
        }
        return bucketNumber;
    }

    @NotNull
    public final List<String> distributionLabels() {
        List labels = new ArrayList();
        labels.add(Intrinsics.stringPlus((String)"Under ", (Object)this.formatted((Duration)CollectionsKt.first(this.durationLimits))));
        int n = 0;
        int n2 = this.durationLimits.size() - 2;
        if (n <= n2) {
            int i;
            do {
                i = n++;
                Duration lowerLimit = this.durationLimits.get(i);
                Duration upperLimit = this.durationLimits.get(i + 1);
                if (Intrinsics.areEqual((Object)this.unitOf(lowerLimit), (Object)this.unitOf(upperLimit))) {
                    labels.add(this.valueOf(lowerLimit, this.unitOf(lowerLimit)) + " to " + this.formatted(upperLimit));
                    continue;
                }
                if (!Intrinsics.areEqual((Object)this.unitOf(lowerLimit), (Object)this.unitOf(upperLimit)) && Intrinsics.areEqual((Object)this.valueOf(upperLimit, this.unitOf(upperLimit)), (Object)"1")) {
                    labels.add(this.valueOf(lowerLimit, this.unitOf(lowerLimit)) + " to " + this.formattedWithUnit(upperLimit, this.unitOf(lowerLimit)));
                    continue;
                }
                labels.add(this.formatted(lowerLimit) + " to " + this.formatted(upperLimit));
            } while (i != n2);
        }
        labels.add(Intrinsics.stringPlus((String)this.formatted((Duration)CollectionsKt.last(this.durationLimits)), (Object)" or over"));
        return labels;
    }

    @NotNull
    public final String getBucketLabels() {
        return this.asFormattedList(this.distributionLabels());
    }

    public final int getBucketCount() {
        return this.distributionLabels().size();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String asFormattedList(@NotNull List<? extends Object> labels) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(labels, (String)"labels");
        Iterable iterable = labels;
        StringBuilder stringBuilder = new StringBuilder().append('[');
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void duration;
            Object item$iv$iv;
            Object t = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add("" + '\'' + duration + '\'');
        }
        return stringBuilder.append(CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)",", null, null, (int)0, null, null, (int)62, null)).append(']').toString();
    }

    @NotNull
    public final String unitOf(@NotNull Duration duration) {
        Intrinsics.checkNotNullParameter((Object)duration, (String)"duration");
        if (this.toHoursPart(duration) > 0) {
            return "HOURS";
        }
        if (this.toMinutesPart(duration) > 0) {
            return "MINUTES";
        }
        if (duration.getSeconds() > 0L) {
            return "SECONDS";
        }
        return "MILLISECONDS";
    }

    @NotNull
    public final String formattedWithUnit(@NotNull Duration duration, @NotNull String unit) {
        String string;
        Intrinsics.checkNotNullParameter((Object)duration, (String)"duration");
        Intrinsics.checkNotNullParameter((Object)unit, (String)"unit");
        switch (unit) {
            case "SECONDS": {
                string = ((Object)StringsKt.trim((CharSequence)this.seconds(duration.get(ChronoUnit.SECONDS)))).toString();
                break;
            }
            case "MINUTES": {
                string = ((Object)StringsKt.trim((CharSequence)this.minutes(duration.get(ChronoUnit.MINUTES)))).toString();
                break;
            }
            case "HOURS": {
                string = ((Object)StringsKt.trim((CharSequence)this.hours(duration.get(ChronoUnit.HOURS)))).toString();
                break;
            }
            default: {
                string = duration.toMillis() + " ms";
            }
        }
        return string;
    }

    @NotNull
    public final String valueOf(@NotNull Duration duration, @NotNull String unit) {
        String string;
        Intrinsics.checkNotNullParameter((Object)duration, (String)"duration");
        Intrinsics.checkNotNullParameter((Object)unit, (String)"unit");
        switch (unit) {
            case "SECONDS": {
                string = String.valueOf(duration.getSeconds());
                break;
            }
            case "MINUTES": {
                string = String.valueOf(duration.getSeconds() / (long)60);
                break;
            }
            case "HOURS": {
                string = String.valueOf(duration.getSeconds() / (long)3600);
                break;
            }
            default: {
                string = String.valueOf(duration.toMillis());
            }
        }
        return string;
    }

    @NotNull
    public final String formatted(@NotNull Duration duration) {
        Intrinsics.checkNotNullParameter((Object)duration, (String)"duration");
        long hours = duration.toHours();
        int minutes = this.toMinutesPart(duration);
        int seconds = this.toSecondsPart(duration);
        return ((Object)StringsKt.trim((CharSequence)(this.hours(hours) + ' ' + this.minutes(minutes) + ' ' + this.seconds(seconds)))).toString();
    }

    @NotNull
    public final String seconds(long value) {
        if (value == 0L) {
            return "";
        }
        return value == 1L ? value + " second" : value + " seconds";
    }

    @NotNull
    public final String minutes(long value) {
        if (value == 0L) {
            return "";
        }
        return value == 1L ? value + " minute" : value + " minutes";
    }

    @NotNull
    public final String hours(long value) {
        if (value == 0L) {
            return "";
        }
        return value == 1L ? value + " hour" : value + " hours";
    }

    public final int toHoursPart(@NotNull Duration duration) {
        Intrinsics.checkNotNullParameter((Object)duration, (String)"duration");
        return (int)(duration.toHours() % (long)24);
    }

    public final int toMinutesPart(@NotNull Duration duration) {
        Intrinsics.checkNotNullParameter((Object)duration, (String)"duration");
        return (int)(duration.toMinutes() % (long)60);
    }

    public final int toSecondsPart(@NotNull Duration duration) {
        Intrinsics.checkNotNullParameter((Object)duration, (String)"duration");
        return (int)(duration.getSeconds() % (long)60);
    }

    /*
     * WARNING - void declaration
     */
    private final List<Duration> durationLimitsDefinedIn(EnvironmentVariables environmentVariables) {
        void $this$mapTo$iv$iv;
        String[] durationLimits;
        String[] stringArray = durationLimits = EnvironmentSpecificConfiguration.from((EnvironmentVariables)environmentVariables).getOptionalProperty(ThucydidesSystemProperty.SERENITY_REPORT_DURATIONS).orElse(DEFAULT_DURATION_RANGES_IN_SECONDS);
        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"durationLimits");
        CharSequence charSequence = (CharSequence)stringArray;
        stringArray = new String[]{","};
        Iterable $this$map$iv = StringsKt.split$default((CharSequence)charSequence, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void value;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(Duration.ofSeconds(Integer.parseInt(((Object)StringsKt.trim((CharSequence)((CharSequence)value))).toString())));
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final DurationBucket bucketFor(@NotNull TestOutcome testOutcome) {
        Intrinsics.checkNotNullParameter((Object)testOutcome, (String)"testOutcome");
        for (DurationBucket bucket : this.durationBuckets) {
            if (!(testOutcome.getDurationInSeconds() < (double)bucket.getDurationInSeconds())) continue;
            return bucket;
        }
        return (DurationBucket)CollectionsKt.last(this.durationBuckets);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<TestTag> getDurationTags() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.durationBuckets;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void bucket;
            DurationBucket durationBucket = (DurationBucket)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(bucket.getTag());
        }
        return (List)destination$iv$iv;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lnet/serenitybdd/reports/model/DurationDistribution$Companion;", "", "()V", "DEFAULT_DURATION_RANGES_IN_SECONDS", "", "serenity-stats"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

