/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.reports.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.serenitybdd.reports.model.CoverageSegment;
import net.thucydides.model.domain.TestResult;
import net.thucydides.model.reports.html.ResultIconFormatter;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0017\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001Be\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\u0003\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\u0003\u0012\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00060\r\u0012\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u000f0\r\u00a2\u0006\u0002\u0010\u0010J\u000e\u0010%\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\nJ\f\u0010&\u001a\b\u0012\u0004\u0012\u00020(0'J\u000e\u0010)\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\nR\u001d\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00060\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u001d\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u000f0\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0012R\u0011\u0010\u000b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0014R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0019\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0014R\u0019\u0010\u001b\u001a\n \u001c*\u0004\u0018\u00010\u00030\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0014R\u0011\u0010\u001e\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u0014R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0011\u0010\b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\u0014R\u0011\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010!\u00a8\u0006*"}, d2={"Lnet/serenitybdd/reports/model/CoverageByTag;", "", "tagName", "", "parentName", "scenarioCount", "", "testCount", "successRate", "result", "Lnet/thucydides/model/domain/TestResult;", "report", "countByResult", "", "percentageByResult", "", "(Ljava/lang/String;Ljava/lang/String;JJLjava/lang/String;Lnet/thucydides/model/domain/TestResult;Ljava/lang/String;Ljava/util/Map;Ljava/util/Map;)V", "getCountByResult", "()Ljava/util/Map;", "getParentName", "()Ljava/lang/String;", "getPercentageByResult", "getReport", "getResult", "()Lnet/thucydides/model/domain/TestResult;", "resultClass", "getResultClass", "resultIcon", "kotlin.jvm.PlatformType", "getResultIcon", "resultName", "getResultName", "getScenarioCount", "()J", "getSuccessRate", "getTagName", "getTestCount", "countForResult", "getCoverageSegments", "", "Lnet/serenitybdd/reports/model/CoverageSegment;", "percentageForResult", "serenity-stats"})
@SourceDebugExtension(value={"SMAP\nTagCoverage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TagCoverage.kt\nnet/serenitybdd/reports/model/CoverageByTag\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,211:1\n766#2:212\n857#2,2:213\n1549#2:215\n1620#2,3:216\n*S KotlinDebug\n*F\n+ 1 TagCoverage.kt\nnet/serenitybdd/reports/model/CoverageByTag\n*L\n201#1:212\n201#1:213,2\n202#1:215\n202#1:216,3\n*E\n"})
public final class CoverageByTag {
    @NotNull
    private final String tagName;
    @NotNull
    private final String parentName;
    private final long scenarioCount;
    private final long testCount;
    @NotNull
    private final String successRate;
    @NotNull
    private final TestResult result;
    @NotNull
    private final String report;
    @NotNull
    private final Map<String, Long> countByResult;
    @NotNull
    private final Map<String, Double> percentageByResult;
    @NotNull
    private final String resultClass;
    private final String resultIcon;
    @NotNull
    private final String resultName;

    public CoverageByTag(@NotNull String tagName, @NotNull String parentName, long scenarioCount, long testCount, @NotNull String successRate, @NotNull TestResult result, @NotNull String report, @NotNull Map<String, Long> countByResult, @NotNull Map<String, Double> percentageByResult) {
        Intrinsics.checkNotNullParameter((Object)tagName, (String)"tagName");
        Intrinsics.checkNotNullParameter((Object)parentName, (String)"parentName");
        Intrinsics.checkNotNullParameter((Object)successRate, (String)"successRate");
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        Intrinsics.checkNotNullParameter((Object)report, (String)"report");
        Intrinsics.checkNotNullParameter(countByResult, (String)"countByResult");
        Intrinsics.checkNotNullParameter(percentageByResult, (String)"percentageByResult");
        this.tagName = tagName;
        this.parentName = parentName;
        this.scenarioCount = scenarioCount;
        this.testCount = testCount;
        this.successRate = successRate;
        this.result = result;
        this.report = report;
        this.countByResult = countByResult;
        this.percentageByResult = percentageByResult;
        String string = this.result.name().toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
        this.resultClass = string;
        this.resultIcon = new ResultIconFormatter().forResult(this.result);
        this.resultName = this.result.name();
    }

    @NotNull
    public final String getTagName() {
        return this.tagName;
    }

    @NotNull
    public final String getParentName() {
        return this.parentName;
    }

    public final long getScenarioCount() {
        return this.scenarioCount;
    }

    public final long getTestCount() {
        return this.testCount;
    }

    @NotNull
    public final String getSuccessRate() {
        return this.successRate;
    }

    @NotNull
    public final TestResult getResult() {
        return this.result;
    }

    @NotNull
    public final String getReport() {
        return this.report;
    }

    @NotNull
    public final Map<String, Long> getCountByResult() {
        return this.countByResult;
    }

    @NotNull
    public final Map<String, Double> getPercentageByResult() {
        return this.percentageByResult;
    }

    @NotNull
    public final String getResultClass() {
        return this.resultClass;
    }

    public final String getResultIcon() {
        return this.resultIcon;
    }

    @NotNull
    public final String getResultName() {
        return this.resultName;
    }

    public final double percentageForResult(@NotNull TestResult result) {
        double d;
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        if (this.percentageByResult.get(result.toString()) == null) {
            d = 0.0;
        } else {
            Double d2 = this.percentageByResult.get(result.toString());
            Intrinsics.checkNotNull((Object)d2);
            d = ((Number)d2).doubleValue();
        }
        return d;
    }

    public final long countForResult(@NotNull TestResult result) {
        long l;
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        if (this.countByResult.get(result.toString()) == null) {
            l = 0L;
        } else {
            Long l2 = this.countByResult.get(result.toString());
            Intrinsics.checkNotNull((Object)l2);
            l = ((Number)l2).longValue();
        }
        return l;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<CoverageSegment> getCoverageSegments() {
        void $this$mapTo$iv$iv;
        TestResult it;
        Iterable $this$filterTo$iv$iv;
        Object[] objectArray = new TestResult[]{TestResult.SUCCESS, TestResult.PENDING, TestResult.IGNORED, TestResult.SKIPPED, TestResult.ABORTED, TestResult.FAILURE, TestResult.ERROR, TestResult.COMPROMISED};
        Iterable $this$filter$iv = CollectionsKt.listOf((Object[])objectArray);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (TestResult)element$iv$iv;
            boolean bl = false;
            if (!(this.percentageForResult(it) > 0.0)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void result;
            it = (TestResult)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new CoverageSegment(this.percentageForResult((TestResult)result), this.countForResult((TestResult)result), (TestResult)result));
        }
        return (List)destination$iv$iv;
    }
}

