/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.reports.model;

import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.thucydides.model.domain.TestResult;
import net.thucydides.model.reports.html.ReportNameProvider;
import net.thucydides.model.reports.html.ResultIconFormatter;
import net.thucydides.model.util.NameConverter;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0011\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0019\u0010\u000b\u001a\n \f*\u0004\u0018\u00010\u00030\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0019\u0010\u000f\u001a\n \f*\u0004\u0018\u00010\u00030\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000eR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u000eR\u0019\u0010\u0015\u001a\n \f*\u0004\u0018\u00010\u00030\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u000e\u00a8\u0006\u0018"}, d2={"Lnet/serenitybdd/reports/model/FrequentFailure;", "", "type", "", "count", "", "result", "Lnet/thucydides/model/domain/TestResult;", "(Ljava/lang/String;ILnet/thucydides/model/domain/TestResult;)V", "getCount", "()I", "name", "kotlin.jvm.PlatformType", "getName", "()Ljava/lang/String;", "report", "getReport", "getResult", "()Lnet/thucydides/model/domain/TestResult;", "resultClass", "getResultClass", "resultIcon", "getResultIcon", "getType", "serenity-stats"})
public final class FrequentFailure {
    @NotNull
    private final String type;
    private final int count;
    @NotNull
    private final TestResult result;
    private final String name;
    @NotNull
    private final String resultClass;
    private final String resultIcon;
    private final String report;

    public FrequentFailure(@NotNull String type, int count, @NotNull TestResult result) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        this.type = type;
        this.count = count;
        this.result = result;
        this.name = NameConverter.humanize((String)StringsKt.substringAfterLast$default((String)this.type, (String)".", null, (int)2, null));
        String string = this.result.name().toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        this.resultClass = string;
        this.resultIcon = new ResultIconFormatter().forResult(this.result);
        this.report = new ReportNameProvider().forErrorType(this.type);
    }

    @NotNull
    public final String getType() {
        return this.type;
    }

    public final int getCount() {
        return this.count;
    }

    @NotNull
    public final TestResult getResult() {
        return this.result;
    }

    public final String getName() {
        return this.name;
    }

    @NotNull
    public final String getResultClass() {
        return this.resultClass;
    }

    public final String getResultIcon() {
        return this.resultIcon;
    }

    public final String getReport() {
        return this.report;
    }
}

