/*
 * Decompiled with CFR 0.152.
 */
package org.exist.atom.modules;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.exist.EXistException;
import org.exist.atom.Atom;
import org.exist.atom.IncomingMessage;
import org.exist.atom.OutgoingMessage;
import org.exist.atom.modules.AtomModuleBase;
import org.exist.atom.modules.AtomProtocol;
import org.exist.collections.Collection;
import org.exist.dom.BinaryDocument;
import org.exist.dom.DocumentImpl;
import org.exist.http.BadRequestException;
import org.exist.http.NotFoundException;
import org.exist.security.PermissionDeniedException;
import org.exist.security.xacml.AccessContext;
import org.exist.source.URLSource;
import org.exist.storage.DBBroker;
import org.exist.storage.serializers.Serializer;
import org.exist.util.serializer.SAXSerializer;
import org.exist.util.serializer.SerializerPool;
import org.exist.xmldb.XmldbURI;
import org.exist.xquery.CompiledXQuery;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQuery;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.Sequence;
import org.xml.sax.SAXException;

public class AtomFeeds
extends AtomModuleBase
implements Atom {
    protected static final Logger LOG = Logger.getLogger((Class)AtomProtocol.class);
    static final String FEED_DOCUMENT_NAME = ".feed.atom";
    static final XmldbURI FEED_DOCUMENT_URI = XmldbURI.create(".feed.atom");
    URLSource entryByIdSource = new URLSource(this.getClass().getResource("entry-by-id.xq"));

    public void doGet(DBBroker broker, IncomingMessage request, OutgoingMessage response) throws BadRequestException, PermissionDeniedException, NotFoundException, EXistException {
        this.handleGet(true, broker, request, response);
    }

    public void doHead(DBBroker broker, IncomingMessage request, OutgoingMessage response) throws BadRequestException, PermissionDeniedException, NotFoundException, EXistException {
        this.handleGet(false, broker, request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleGet(boolean returnContent, DBBroker broker, IncomingMessage request, OutgoingMessage response) throws BadRequestException, PermissionDeniedException, NotFoundException, EXistException {
        block22: {
            DocumentImpl resource = null;
            XmldbURI pathUri = XmldbURI.create(request.getPath());
            try {
                resource = broker.getXMLResource(pathUri, 0);
                if (resource == null) {
                    Collection collection;
                    String id = request.getParameter("id");
                    if (id != null && (id = id.trim()).length() == 0) {
                        id = null;
                    }
                    if ((collection = broker.getCollection(pathUri)) != null) {
                        if (!collection.getPermissions().validate(broker.getUser(), 4)) {
                            throw new PermissionDeniedException("Not allowed to read collection");
                        }
                        DocumentImpl feedDoc = collection.getDocument(broker, FEED_DOCUMENT_URI);
                        if (feedDoc == null) {
                            throw new BadRequestException("Collection " + request.getPath() + " is not an Atom feed.");
                        }
                        String charset = this.getContext().getDefaultCharset();
                        if (returnContent) {
                            if (id == null) {
                                response.setStatusCode(200);
                                response.setContentType("application/atom+xml; charset=" + charset);
                                Serializer serializer = broker.getSerializer();
                                serializer.reset();
                                try {
                                    OutputStreamWriter w = new OutputStreamWriter(response.getOutputStream(), charset);
                                    serializer.serialize(feedDoc, w);
                                    ((Writer)w).flush();
                                    ((Writer)w).close();
                                    break block22;
                                }
                                catch (IOException ex) {
                                    LOG.fatal((Object)("Cannot read resource " + request.getPath()), (Throwable)ex);
                                    throw new EXistException("I/O error on read of resource " + request.getPath(), ex);
                                }
                                catch (SAXException saxe) {
                                    LOG.warn((Object)saxe);
                                    throw new BadRequestException("Error while serializing XML: " + saxe.getMessage());
                                }
                            }
                            response.setStatusCode(200);
                            this.getEntryById(broker, request.getPath(), id, response);
                            break block22;
                        }
                        response.setStatusCode(204);
                        break block22;
                    }
                    throw new NotFoundException("Resource " + request.getPath() + " not found");
                }
                if (!resource.getPermissions().validate(broker.getUser(), 4)) {
                    throw new PermissionDeniedException("Not allowed to read resource");
                }
                if (returnContent) {
                    response.setStatusCode(200);
                    if (resource.getResourceType() == 1) {
                        response.setContentType(resource.getMetadata().getMimeType());
                        try {
                            OutputStream os = response.getOutputStream();
                            broker.readBinaryResource((BinaryDocument)resource, os);
                            os.flush();
                            break block22;
                        }
                        catch (IOException ex) {
                            LOG.fatal((Object)("Cannot read resource " + request.getPath()), (Throwable)ex);
                            throw new EXistException("I/O error on read of resource " + request.getPath(), ex);
                        }
                    }
                    Serializer serializer = broker.getSerializer();
                    serializer.reset();
                    String charset = this.getContext().getDefaultCharset();
                    try {
                        response.setContentType(resource.getMetadata().getMimeType() + "; charset=" + charset);
                        OutputStreamWriter w = new OutputStreamWriter(response.getOutputStream(), charset);
                        serializer.serialize(resource, w);
                        ((Writer)w).flush();
                        ((Writer)w).close();
                        break block22;
                    }
                    catch (IOException ex) {
                        LOG.fatal((Object)("Cannot read resource " + request.getPath()), (Throwable)ex);
                        throw new EXistException("I/O error on read of resource " + request.getPath(), ex);
                    }
                    catch (SAXException saxe) {
                        LOG.warn((Object)saxe);
                        throw new BadRequestException("Error while serializing XML: " + saxe.getMessage());
                    }
                }
                response.setStatusCode(204);
            }
            finally {
                if (resource != null) {
                    resource.getUpdateLock().release(0);
                }
            }
        }
    }

    public void getEntryById(DBBroker broker, String path, String id, OutgoingMessage response) throws EXistException, BadRequestException {
        XQueryContext context;
        XQuery xquery = broker.getXQueryService();
        CompiledXQuery feedQuery = xquery.getXQueryPool().borrowCompiledXQuery(broker, this.entryByIdSource);
        if (feedQuery == null) {
            context = xquery.newContext(AccessContext.REST);
            try {
                feedQuery = xquery.compile(context, this.entryByIdSource);
            }
            catch (XPathException ex) {
                throw new EXistException("Cannot compile xquery " + this.entryByIdSource.getURL(), ex);
            }
            catch (IOException ex) {
                throw new EXistException("I/O exception while compiling xquery " + this.entryByIdSource.getURL(), ex);
            }
        } else {
            context = feedQuery.getContext();
        }
        context.setStaticallyKnownDocuments(new XmldbURI[]{XmldbURI.create(path).append(FEED_DOCUMENT_NAME)});
        try {
            context.declareVariable("id", id);
            Sequence resultSequence = xquery.execute(feedQuery, null);
            if (resultSequence.isEmpty()) {
                throw new BadRequestException("No topic was found.");
            }
            String charset = this.getContext().getDefaultCharset();
            response.setContentType("application/atom+xml; charset=" + charset);
            Serializer serializer = broker.getSerializer();
            serializer.reset();
            try {
                OutputStreamWriter w = new OutputStreamWriter(response.getOutputStream(), charset);
                SAXSerializer sax = (SAXSerializer)SerializerPool.getInstance().borrowObject(SAXSerializer.class);
                Properties outputProperties = new Properties();
                sax.setOutput(w, outputProperties);
                serializer.setProperties(outputProperties);
                serializer.setSAXHandlers(sax, sax);
                serializer.toSAX(resultSequence, 1, 1, false);
                SerializerPool.getInstance().returnObject(sax);
                ((Writer)w).flush();
                ((Writer)w).close();
            }
            catch (IOException ex) {
                LOG.fatal((Object)("Cannot read resource " + path), (Throwable)ex);
                throw new EXistException("I/O error on read of resource " + path, ex);
            }
            catch (SAXException saxe) {
                LOG.warn((Object)saxe);
                throw new BadRequestException("Error while serializing XML: " + saxe.getMessage());
            }
            resultSequence.itemAt(0);
        }
        catch (XPathException ex) {
            throw new EXistException("Cannot execute xquery " + this.entryByIdSource.getURL(), ex);
        }
        finally {
            xquery.getXQueryPool().returnCompiledXQuery(this.entryByIdSource, feedQuery);
        }
    }
}

