/*
 * Decompiled with CFR 0.152.
 */
package org.exist.backup;

import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.exist.client.Messages;
import org.exist.client.MimeTypeFileFilter;
import org.xmldb.api.DatabaseManager;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.XMLDBException;

public class CreateBackupDialog
extends JPanel {
    JComboBox collections;
    JTextField backupTarget;
    File backupDir;
    String uri;
    String user;
    String passwd;

    public CreateBackupDialog(String uri, String user, String passwd, File backupDir) throws HeadlessException {
        super(false);
        this.uri = uri;
        this.user = user;
        this.passwd = passwd;
        this.backupDir = backupDir;
        this.setupComponents();
        this.setSize(new Dimension(350, 200));
    }

    private void setupComponents() {
        GridBagLayout grid = new GridBagLayout();
        this.setLayout(grid);
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(5, 5, 5, 5);
        JLabel label = new JLabel(Messages.getString("CreateBackupDialog.1"));
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 17;
        c.fill = 0;
        grid.setConstraints(label, c);
        this.add(label);
        Vector v = this.getAllCollections();
        this.collections = new JComboBox(v);
        c.gridx = 1;
        c.gridy = 0;
        c.gridwidth = 2;
        c.anchor = 13;
        c.fill = 2;
        grid.setConstraints(this.collections, c);
        this.add(this.collections);
        label = new JLabel(Messages.getString("CreateBackupDialog.2"));
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 1;
        c.anchor = 17;
        c.fill = 0;
        grid.setConstraints(label, c);
        this.add(label);
        this.backupTarget = new JTextField(new File(this.backupDir, "eXist-backup.zip").getAbsolutePath(), 40);
        c.gridx = 1;
        c.gridy = 1;
        c.anchor = 13;
        c.fill = 2;
        grid.setConstraints(this.backupTarget, c);
        this.add(this.backupTarget);
        JButton select = new JButton(Messages.getString("CreateBackupDialog.3"));
        select.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CreateBackupDialog.this.actionSelect();
            }
        });
        c.gridx = 2;
        c.gridy = 1;
        c.anchor = 13;
        c.fill = 0;
        grid.setConstraints(select, c);
        select.setToolTipText(Messages.getString("CreateBackupDialog.4"));
        this.add(select);
    }

    private void actionSelect() {
        JFileChooser chooser = new JFileChooser();
        chooser.setMultiSelectionEnabled(false);
        chooser.setFileSelectionMode(2);
        chooser.addChoosableFileFilter(new MimeTypeFileFilter("application/zip"));
        chooser.setSelectedFile(new File("eXist-backup.zip"));
        chooser.setCurrentDirectory(this.backupDir);
        if (chooser.showDialog(this, Messages.getString("CreateBackupDialog.5")) == 0) {
            this.backupTarget.setText(chooser.getSelectedFile().getAbsolutePath());
            this.backupDir = chooser.getCurrentDirectory();
        }
    }

    private Vector getAllCollections() {
        Vector list = new Vector();
        try {
            Collection root = DatabaseManager.getCollection((String)(this.uri + "/db"), (String)this.user, (String)this.passwd);
            this.getAllCollections(root, list);
        }
        catch (XMLDBException e) {
            e.printStackTrace();
        }
        return list;
    }

    private void getAllCollections(Collection collection, Vector collections) throws XMLDBException {
        collections.add(collection.getName());
        String[] childCollections = collection.listChildCollections();
        for (int i = 0; i < childCollections.length; ++i) {
            Collection child = collection.getChildCollection(childCollections[i]);
            this.getAllCollections(child, collections);
        }
    }

    public String getCollection() {
        return (String)this.collections.getSelectedItem();
    }

    public String getBackupTarget() {
        return this.backupTarget.getText();
    }

    public File getBackupDir() {
        return this.backupDir;
    }
}

