/*
 * Decompiled with CFR 0.152.
 */
package org.exist.backup;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import javax.xml.stream.XMLStreamException;
import org.apache.log4j.Logger;
import org.exist.backup.Backup;
import org.exist.backup.BackupDescriptor;
import org.exist.backup.BackupDirectory;
import org.exist.backup.BackupWriter;
import org.exist.backup.ErrorReport;
import org.exist.backup.FileSystemWriter;
import org.exist.backup.ZipWriter;
import org.exist.collections.Collection;
import org.exist.dom.BinaryDocument;
import org.exist.dom.DocumentImpl;
import org.exist.dom.DocumentMetadata;
import org.exist.dom.DocumentSet;
import org.exist.dom.QName;
import org.exist.dom.StoredNode;
import org.exist.stax.EmbeddedXMLStreamReader;
import org.exist.storage.DBBroker;
import org.exist.storage.NativeBroker;
import org.exist.storage.btree.BTreeCallback;
import org.exist.storage.btree.Value;
import org.exist.storage.index.CollectionStore;
import org.exist.storage.io.VariableByteInput;
import org.exist.util.UTF8;
import org.exist.util.serializer.AttrList;
import org.exist.util.serializer.Receiver;
import org.exist.util.serializer.SAXSerializer;
import org.exist.util.serializer.SerializerPool;
import org.exist.xmldb.XmldbURI;
import org.exist.xquery.TerminatedException;
import org.exist.xquery.XPathException;
import org.exist.xquery.util.URIUtils;
import org.exist.xquery.value.DateTimeValue;
import org.w3c.dom.NodeList;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.NamespaceSupport;

public class SystemExport {
    private static final Logger LOG = Logger.getLogger((Class)SystemExport.class);
    private static final DateFormat dateFormat = new SimpleDateFormat("yyyyMMdd-HHmm");
    public Properties defaultOutputProperties = new Properties();
    public Properties contentsOutputProps;
    private static final XmldbURI TEMP_COLLECTION = XmldbURI.createInternal("/db/system/temp");
    private static final XmldbURI CONTENTS_URI = XmldbURI.createInternal("__contents__.xml");
    private static final XmldbURI LOST_URI = XmldbURI.createInternal("__lost_and_found__");
    private static final int currVersion = 1;
    private DBBroker broker;
    private StatusCallback callback;
    private boolean directAccess;

    public SystemExport(DBBroker broker, StatusCallback callback, boolean direct) {
        this.defaultOutputProperties.setProperty("indent", "no");
        this.defaultOutputProperties.setProperty("encoding", "UTF-8");
        this.defaultOutputProperties.setProperty("omit-xml-declaration", "no");
        this.defaultOutputProperties.setProperty("expand-xincludes", "no");
        this.defaultOutputProperties.setProperty("process-xsl-pi", "no");
        this.contentsOutputProps = new Properties();
        this.contentsOutputProps.setProperty("indent", "yes");
        this.callback = null;
        this.directAccess = false;
        this.broker = broker;
        this.callback = callback;
        this.directAccess = direct;
    }

    public File export(String targetDir, boolean incremental, boolean zip, List errorList) {
        return this.export(targetDir, incremental, -1, zip, errorList);
    }

    public File export(String targetDir, boolean incremental, int maxInc, boolean zip, List errorList) {
        try {
            BackupDirectory directory = new BackupDirectory(targetDir);
            BackupDescriptor prevBackup = null;
            if (incremental) {
                prevBackup = directory.lastBackupFile();
                LOG.info((Object)("Creating incremental backup. Prev backup: " + (prevBackup == null ? "none" : prevBackup.getSymbolicPath())));
            }
            Properties properties = new Properties();
            int seqNr = 1;
            if (incremental) {
                Properties prevProp;
                properties.setProperty("previous", prevBackup == null ? "" : prevBackup.getName());
                if (prevBackup != null && (prevProp = prevBackup.getProperties()) != null) {
                    String seqNrStr = prevProp.getProperty("nr-in-sequence", "1");
                    try {
                        seqNr = Integer.parseInt(seqNrStr);
                        if (seqNr == maxInc) {
                            seqNr = 1;
                            incremental = false;
                            prevBackup = null;
                        } else {
                            ++seqNr;
                        }
                    }
                    catch (NumberFormatException e) {
                        LOG.warn((Object)("Bad sequence number in backup descriptor: " + prevBackup.getName()));
                    }
                }
            }
            properties.setProperty("nr-in-sequence", Integer.toString(seqNr));
            properties.setProperty("incremental", incremental ? "yes" : "no");
            try {
                properties.setProperty("date", new DateTimeValue(new Date()).getStringValue());
            }
            catch (XPathException e) {
                // empty catch block
            }
            File backupFile = directory.createBackup(incremental && prevBackup != null, zip);
            BackupWriter output = zip ? new ZipWriter(backupFile, "/db") : new FileSystemWriter(new File(backupFile, "db"));
            output.setProperties(properties);
            Date date = prevBackup == null ? null : prevBackup.getDate();
            CollectionCallback cb = new CollectionCallback(output, date, prevBackup, errorList);
            this.broker.getCollectionsFailsafe(cb);
            this.exportOrphans(output, cb.getDocs(), errorList);
            output.close();
            return backupFile;
        }
        catch (IOException e) {
            this.reportError("A write error occurred while exporting data: '" + e.getMessage() + "'. Aborting export.", e);
            return null;
        }
    }

    private void reportError(String message, Throwable e) {
        if (this.callback != null) {
            this.callback.error("EXPORT: " + message, e);
        }
    }

    private static boolean isDamaged(DocumentImpl doc, List errorList) {
        if (errorList == null) {
            return false;
        }
        for (int i = 0; i < errorList.size(); ++i) {
            ErrorReport report = (ErrorReport)errorList.get(i);
            if (report.getErrcode() != 5 || ((ErrorReport.ResourceError)report).getDocumentId() != doc.getDocId()) continue;
            return true;
        }
        return false;
    }

    private static boolean isDamaged(Collection collection, List errorList) {
        if (errorList == null) {
            return false;
        }
        for (int i = 0; i < errorList.size(); ++i) {
            ErrorReport report = (ErrorReport)errorList.get(i);
            if (report.getErrcode() != 4 || ((ErrorReport.CollectionError)report).getCollectionId() != collection.getId()) continue;
            return true;
        }
        return false;
    }

    private static boolean isDamagedChild(XmldbURI uri, List errorList) {
        if (errorList == null) {
            return false;
        }
        for (int i = 0; i < errorList.size(); ++i) {
            ErrorReport report = (ErrorReport)errorList.get(i);
            if (report.getErrcode() != 4 || !((ErrorReport.CollectionError)report).getCollectionURI().equalsInternal(uri)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exportOrphans(BackupWriter output, DocumentSet docs, List errorList) {
        output.newCollection("/db/__lost_and_found__");
        try {
            Writer contents = output.newContents();
            SAXSerializer serializer = (SAXSerializer)SerializerPool.getInstance().borrowObject(SAXSerializer.class);
            serializer.setOutput(contents, this.contentsOutputProps);
            serializer.startDocument();
            serializer.startPrefixMapping("", "http://exist.sourceforge.net/NS/exist");
            AttributesImpl attr = new AttributesImpl();
            attr.addAttribute("http://exist.sourceforge.net/NS/exist", "name", "name", "CDATA", "/db/__lost_and_found__");
            attr.addAttribute("http://exist.sourceforge.net/NS/exist", "version", "version", "CDATA", String.valueOf(1));
            attr.addAttribute("http://exist.sourceforge.net/NS/exist", "owner", "owner", "CDATA", "admin");
            attr.addAttribute("http://exist.sourceforge.net/NS/exist", "group", "group", "CDATA", "dba");
            attr.addAttribute("http://exist.sourceforge.net/NS/exist", "mode", "mode", "CDATA", "0771");
            serializer.startElement("http://exist.sourceforge.net/NS/exist", "collection", "collection", attr);
            DocumentCallback docCb = new DocumentCallback(output, serializer, null, null, docs, true);
            this.broker.getResourcesFailsafe(docCb, this.directAccess);
            serializer.endElement("http://exist.sourceforge.net/NS/exist", "collection", "collection");
            serializer.endPrefixMapping("");
            serializer.endDocument();
            output.closeContents();
        }
        catch (Exception e) {
            e.printStackTrace();
            if (this.callback != null) {
                this.callback.error(e.getMessage(), e);
            }
        }
        finally {
            output.closeCollection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void export(Collection current, BackupWriter output, Date date, BackupDescriptor prevBackup, List errorList, DocumentSet docs) throws IOException, SAXException {
        if (this.callback != null) {
            this.callback.startCollection(current.getURI().toString());
        }
        if (!current.getURI().equalsInternal(XmldbURI.ROOT_COLLECTION_URI)) {
            output.newCollection(Backup.encode(URIUtils.urlDecodeUtf8(current.getURI())));
        }
        try {
            Writer contents = output.newContents();
            SAXSerializer serializer = (SAXSerializer)SerializerPool.getInstance().borrowObject(SAXSerializer.class);
            serializer.setOutput(contents, this.contentsOutputProps);
            serializer.startDocument();
            serializer.startPrefixMapping("", "http://exist.sourceforge.net/NS/exist");
            XmldbURI uri = current.getURI();
            AttributesImpl attr = new AttributesImpl();
            attr.addAttribute("http://exist.sourceforge.net/NS/exist", "name", "name", "CDATA", uri.toString());
            attr.addAttribute("http://exist.sourceforge.net/NS/exist", "version", "version", "CDATA", String.valueOf(1));
            attr.addAttribute("http://exist.sourceforge.net/NS/exist", "owner", "owner", "CDATA", current.getPermissions().getOwner());
            attr.addAttribute("http://exist.sourceforge.net/NS/exist", "group", "group", "CDATA", current.getPermissions().getOwnerGroup());
            attr.addAttribute("http://exist.sourceforge.net/NS/exist", "mode", "mode", "CDATA", Integer.toOctalString(current.getPermissions().getPermissions()));
            try {
                attr.addAttribute("http://exist.sourceforge.net/NS/exist", "created", "created", "CDATA", new DateTimeValue(new Date(current.getCreationTime())).getStringValue());
            }
            catch (XPathException e) {
                e.printStackTrace();
            }
            serializer.startElement("http://exist.sourceforge.net/NS/exist", "collection", "collection", attr);
            int docsCount = current.getDocumentCount();
            int count = 0;
            Iterator i = current.iterator(this.broker);
            while (i.hasNext()) {
                DocumentImpl doc = (DocumentImpl)i.next();
                if (SystemExport.isDamaged(doc, errorList)) {
                    this.reportError("Skipping damaged document " + doc.getFileURI(), null);
                } else if (!doc.getFileURI().equalsInternal(CONTENTS_URI) && !doc.getFileURI().equalsInternal(LOST_URI)) {
                    this.exportDocument(output, date, prevBackup, serializer, docsCount, count, doc);
                    docs.add(doc, false);
                }
                ++count;
            }
            i = current.collectionIterator();
            while (i.hasNext()) {
                XmldbURI childUri = (XmldbURI)i.next();
                if (childUri.equalsInternal(TEMP_COLLECTION)) continue;
                if (SystemExport.isDamagedChild(childUri, errorList)) {
                    this.reportError("Skipping damaged child collection " + childUri, null);
                    continue;
                }
                attr.clear();
                attr.addAttribute("http://exist.sourceforge.net/NS/exist", "name", "name", "CDATA", childUri.toString());
                attr.addAttribute("http://exist.sourceforge.net/NS/exist", "filename", "filename", "CDATA", Backup.encode(URIUtils.urlDecodeUtf8(childUri.toString())));
                serializer.startElement("http://exist.sourceforge.net/NS/exist", "subcollection", "subcollection", attr);
                serializer.endElement("http://exist.sourceforge.net/NS/exist", "subcollection", "subcollection");
            }
            if (prevBackup != null) {
                CheckDeletedHandler check = new CheckDeletedHandler(current, serializer);
                try {
                    prevBackup.parse(check);
                }
                catch (Exception e) {
                    LOG.error((Object)("Caught exception while trying to parse previous backup descriptor: " + prevBackup.getSymbolicPath()), (Throwable)e);
                }
            }
            serializer.endElement("http://exist.sourceforge.net/NS/exist", "collection", "collection");
            serializer.endPrefixMapping("");
            serializer.endDocument();
            output.closeContents();
        }
        finally {
            if (!current.getURI().equalsInternal(XmldbURI.ROOT_COLLECTION_URI)) {
                output.closeCollection();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exportDocument(BackupWriter output, Date date, BackupDescriptor prevBackup, SAXSerializer serializer, int docsCount, int count, DocumentImpl doc) throws IOException, SAXException {
        boolean needsBackup;
        if (this.callback != null) {
            this.callback.startDocument(doc.getFileURI().toString(), count, docsCount);
        }
        boolean bl = needsBackup = prevBackup == null || date.getTime() < doc.getMetadata().getLastModified();
        if (needsBackup) {
            OutputStream os = output.newEntry(Backup.encode(URIUtils.urlDecodeUtf8(doc.getFileURI())));
            try {
                if (doc.getResourceType() == 1) {
                    this.broker.readBinaryResource((BinaryDocument)doc, os);
                } else {
                    BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(os, "UTF-8"));
                    SAXSerializer contentSerializer = (SAXSerializer)SerializerPool.getInstance().borrowObject(SAXSerializer.class);
                    contentSerializer.setOutput(writer, this.defaultOutputProperties);
                    this.writeXML(doc, contentSerializer);
                    SerializerPool.getInstance().returnObject(contentSerializer);
                    writer.flush();
                }
            }
            catch (Exception e) {
                this.reportError("A write error occurred while exporting document: '" + doc.getFileURI() + "'. Continuing with next document.", e);
                return;
            }
            finally {
                output.closeEntry();
            }
        }
        AttributesImpl attr = new AttributesImpl();
        attr.addAttribute("http://exist.sourceforge.net/NS/exist", "type", "type", "CDATA", doc.getResourceType() == 1 ? "BinaryResource" : "XMLResource");
        attr.addAttribute("http://exist.sourceforge.net/NS/exist", "name", "name", "CDATA", doc.getFileURI().toString());
        attr.addAttribute("http://exist.sourceforge.net/NS/exist", "skip", "skip", "CDATA", needsBackup ? "no" : "yes");
        attr.addAttribute("http://exist.sourceforge.net/NS/exist", "owner", "owner", "CDATA", doc.getPermissions().getOwner());
        attr.addAttribute("http://exist.sourceforge.net/NS/exist", "group", "group", "CDATA", doc.getPermissions().getOwnerGroup());
        attr.addAttribute("http://exist.sourceforge.net/NS/exist", "mode", "mode", "CDATA", Integer.toOctalString(doc.getPermissions().getPermissions()));
        DocumentMetadata metadata = null;
        try {
            metadata = doc.getMetadata();
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            String modified;
            String created;
            if (metadata != null) {
                created = new DateTimeValue(new Date(metadata.getCreated())).getStringValue();
                modified = new DateTimeValue(new Date(metadata.getLastModified())).getStringValue();
            } else {
                modified = created = new DateTimeValue().getStringValue();
            }
            attr.addAttribute("http://exist.sourceforge.net/NS/exist", "created", "created", "CDATA", created);
            attr.addAttribute("http://exist.sourceforge.net/NS/exist", "modified", "modified", "CDATA", modified);
        }
        catch (XPathException e) {
            LOG.warn((Object)e.getMessage(), (Throwable)e);
        }
        attr.addAttribute("http://exist.sourceforge.net/NS/exist", "filename", "filename", "CDATA", Backup.encode(URIUtils.urlDecodeUtf8(doc.getFileURI())));
        String mimeType = "text/xml";
        if (metadata != null && metadata.getMimeType() != null) {
            mimeType = Backup.encode(metadata.getMimeType());
        }
        attr.addAttribute("http://exist.sourceforge.net/NS/exist", "mimetype", "mimetype", "CDATA", mimeType);
        if (doc.getResourceType() == 0 && metadata != null && doc.getDoctype() != null) {
            if (doc.getDoctype().getName() != null) {
                attr.addAttribute("http://exist.sourceforge.net/NS/exist", "namedoctype", "namedoctype", "CDATA", doc.getDoctype().getName());
            }
            if (doc.getDoctype().getPublicId() != null) {
                attr.addAttribute("http://exist.sourceforge.net/NS/exist", "publicid", "publicid", "CDATA", doc.getDoctype().getPublicId());
            }
            if (doc.getDoctype().getSystemId() != null) {
                attr.addAttribute("http://exist.sourceforge.net/NS/exist", "systemid", "systemid", "CDATA", doc.getDoctype().getSystemId());
            }
        }
        serializer.startElement("http://exist.sourceforge.net/NS/exist", "resource", "resource", attr);
        serializer.endElement("http://exist.sourceforge.net/NS/exist", "resource", "resource");
    }

    private void writeXML(DocumentImpl doc, Receiver receiver) {
        try {
            NamespaceSupport nsSupport = new NamespaceSupport();
            NodeList children = doc.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                StoredNode child = (StoredNode)children.item(i);
                EmbeddedXMLStreamReader reader = this.broker.getXMLStreamReader(child, false);
                while (reader.hasNext()) {
                    int status = reader.next();
                    switch (status) {
                        case 7: 
                        case 8: {
                            break;
                        }
                        case 1: {
                            int nsdecls = reader.getNamespaceCount();
                            for (int ni = 0; ni < nsdecls; ++ni) {
                                receiver.startPrefixMapping(reader.getNamespacePrefix(ni), reader.getNamespaceURI(ni));
                            }
                            AttrList attribs = new AttrList();
                            for (int j = 0; j < reader.getAttributeCount(); ++j) {
                                QName qn = new QName(reader.getAttributeLocalName(j), reader.getAttributeNamespace(j), reader.getAttributePrefix(j));
                                attribs.addAttribute(qn, reader.getAttributeValue(j));
                            }
                            receiver.startElement(new QName(reader.getLocalName(), reader.getNamespaceURI(), reader.getPrefix()), attribs);
                            break;
                        }
                        case 2: {
                            receiver.endElement(new QName(reader.getLocalName(), reader.getNamespaceURI(), reader.getPrefix()));
                            int nsdecls = reader.getNamespaceCount();
                            for (int ni = 0; ni < nsdecls; ++ni) {
                                receiver.endPrefixMapping(reader.getNamespacePrefix(ni));
                            }
                            break;
                        }
                        case 4: {
                            receiver.characters(reader.getText());
                            break;
                        }
                        case 12: {
                            char[] ch = reader.getTextCharacters();
                            receiver.cdataSection(ch, 0, ch.length);
                            break;
                        }
                        case 5: {
                            char[] ch = reader.getTextCharacters();
                            receiver.comment(ch, 0, ch.length);
                            break;
                        }
                        case 3: {
                            receiver.processingInstruction(reader.getPITarget(), reader.getPIData());
                        }
                    }
                    if (child.getNodeType() != 8 && child.getNodeType() != 7) continue;
                    break;
                }
                nsSupport.reset();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (XMLStreamException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
    }

    public static File getUniqueFile(String base, String extension, String dir) {
        String filename = base + '-' + dateFormat.format(new Date());
        File file = new File(dir, filename + extension);
        int version = 0;
        while (file.exists()) {
            file = new File(dir, filename + '_' + version++ + extension);
        }
        return file;
    }

    private class CheckDeletedHandler
    extends DefaultHandler {
        private Collection collection;
        private SAXSerializer serializer;

        private CheckDeletedHandler(Collection collection, SAXSerializer serializer) {
            this.collection = collection;
            this.serializer = serializer;
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (uri.equals("http://exist.sourceforge.net/NS/exist")) {
                String name;
                if (localName.equals("subcollection")) {
                    String name2 = attributes.getValue("filename");
                    if (name2 == null) {
                        name2 = attributes.getValue("name");
                    }
                    if (!this.collection.hasChildCollection(XmldbURI.create(name2))) {
                        AttributesImpl attr = new AttributesImpl();
                        attr.addAttribute("http://exist.sourceforge.net/NS/exist", "name", "name", "CDATA", name2);
                        attr.addAttribute("http://exist.sourceforge.net/NS/exist", "type", "type", "CDATA", "collection");
                        this.serializer.startElement("http://exist.sourceforge.net/NS/exist", "deleted", "deleted", attr);
                        this.serializer.endElement("http://exist.sourceforge.net/NS/exist", "deleted", "deleted");
                    }
                } else if (localName.equals("resource") && !this.collection.hasDocument(XmldbURI.create(name = attributes.getValue("name")))) {
                    AttributesImpl attr = new AttributesImpl();
                    attr.addAttribute("http://exist.sourceforge.net/NS/exist", "name", "name", "CDATA", name);
                    attr.addAttribute("http://exist.sourceforge.net/NS/exist", "type", "type", "CDATA", "resource");
                    this.serializer.startElement("http://exist.sourceforge.net/NS/exist", "deleted", "deleted", attr);
                    this.serializer.endElement("http://exist.sourceforge.net/NS/exist", "deleted", "deleted");
                }
            }
        }
    }

    private class DocumentCallback
    implements BTreeCallback {
        private DocumentSet exportedDocs;
        private Set writtenDocs = null;
        private SAXSerializer serializer;
        private BackupWriter output;
        private Date date;
        private BackupDescriptor prevBackup;

        private DocumentCallback(BackupWriter output, SAXSerializer serializer, Date date, BackupDescriptor prevBackup, DocumentSet exportedDocs, boolean checkNames) {
            this.exportedDocs = exportedDocs;
            this.serializer = serializer;
            this.output = output;
            this.date = date;
            this.prevBackup = prevBackup;
            if (checkNames) {
                this.writtenDocs = new TreeSet();
            }
        }

        public boolean indexInfo(Value key, long pointer) throws TerminatedException {
            CollectionStore store = (CollectionStore)((NativeBroker)SystemExport.this.broker).getStorage((byte)0);
            int docId = CollectionStore.DocumentKey.getDocumentId(key);
            if (!this.exportedDocs.contains(docId)) {
                try {
                    byte type = key.data()[key.start() + Collection.LENGTH_COLLECTION_ID + DocumentImpl.LENGTH_DOCUMENT_TYPE];
                    VariableByteInput istream = store.getAsStream(pointer);
                    DocumentImpl doc = null;
                    doc = type == 1 ? new BinaryDocument(SystemExport.this.broker.getBrokerPool()) : new DocumentImpl(SystemExport.this.broker.getBrokerPool());
                    doc.read(istream);
                    SystemExport.this.reportError("Found an orphaned document: " + doc.getFileURI().toString(), null);
                    if (this.writtenDocs != null) {
                        String fileURI;
                        int count = 1;
                        String origURI = fileURI = doc.getFileURI().toString();
                        while (this.writtenDocs.contains(fileURI)) {
                            fileURI = origURI + "." + count++;
                        }
                        doc.setFileURI(XmldbURI.createInternal(fileURI));
                        this.writtenDocs.add(fileURI);
                    }
                    SystemExport.this.exportDocument(this.output, this.date, this.prevBackup, this.serializer, 0, 0, doc);
                }
                catch (Exception e) {
                    SystemExport.this.reportError("Caught an exception while scanning documents: " + e.getMessage(), e);
                }
            }
            return true;
        }
    }

    private class CollectionCallback
    implements BTreeCallback {
        private BackupWriter writer;
        private BackupDescriptor prevBackup;
        private Date date;
        private List errors;
        private DocumentSet docs = new DocumentSet();

        private CollectionCallback(BackupWriter writer, Date date, BackupDescriptor prevBackup, List errorList) {
            this.writer = writer;
            this.errors = errorList;
            this.date = date;
            this.prevBackup = prevBackup;
        }

        public boolean indexInfo(Value value, long pointer) throws TerminatedException {
            String uri = null;
            try {
                CollectionStore store = (CollectionStore)((NativeBroker)SystemExport.this.broker).getStorage((byte)0);
                uri = UTF8.decode(value.data(), value.start() + CollectionStore.CollectionKey.OFFSET_VALUE, value.getLength() - CollectionStore.CollectionKey.OFFSET_VALUE).toString();
                if ("__next_collection_id".equals(uri) || "__next_doc_id".equals(uri) || "__free_collection_id".equals(uri) || "__free_doc_id".equals(uri)) {
                    return true;
                }
                if (SystemExport.this.callback != null) {
                    SystemExport.this.callback.startCollection(uri);
                }
                Collection collection = new Collection(XmldbURI.createInternal(uri));
                VariableByteInput istream = store.getAsStream(pointer);
                collection.read(SystemExport.this.broker, istream);
                BackupDescriptor bd = null;
                if (this.prevBackup != null) {
                    bd = this.prevBackup.getBackupDescriptor(uri);
                }
                SystemExport.this.export(collection, this.writer, this.date, bd, this.errors, this.docs);
            }
            catch (Exception e) {
                SystemExport.this.reportError("Caught exception while scanning collections: " + uri, e);
            }
            return true;
        }

        public DocumentSet getDocs() {
            return this.docs;
        }
    }

    public static interface StatusCallback {
        public void startCollection(String var1);

        public void startDocument(String var1, int var2, int var3);

        public void error(String var1, Throwable var2);
    }
}

