/*
 * Decompiled with CFR 0.152.
 */
package org.exist.backup.xquery;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.exist.backup.AbstractBackupDescriptor;
import org.exist.backup.FileSystemBackupDescriptor;
import org.exist.backup.ZipArchiveBackupDescriptor;
import org.exist.dom.QName;
import org.exist.memtree.MemTreeBuilder;
import org.exist.memtree.NodeImpl;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.xml.sax.helpers.AttributesImpl;

public class ListBackups
extends BasicFunction {
    public static final FunctionSignature signature = new FunctionSignature(new QName("list", "http://exist-db.org/xquery/backups", "backups"), "Returns an XML fragment listing all eXist backups found in a specific backup directory. The directory is passed in the argument.", new SequenceType[]{new SequenceType(22, 2)}, new SequenceType(-1, 6));
    public static final QName DIRECTORY_ELEMENT = new QName("directory", "http://exist.sourceforge.net/NS/exist", "");
    public static final QName BACKUP_ELEMENT = new QName("backup", "http://exist.sourceforge.net/NS/exist", "");

    public ListBackups(XQueryContext context) {
        super(context, signature);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        String exportDir = args[0].getStringValue();
        File dir = new File(exportDir);
        if (!dir.isAbsolute()) {
            dir = new File((String)this.context.getBroker().getConfiguration().getProperty("db-connection.data-dir"), exportDir);
        }
        this.context.pushDocumentContext();
        try {
            MemTreeBuilder builder = this.context.getDocumentBuilder();
            int nodeNr = builder.startElement(DIRECTORY_ELEMENT, null);
            if (dir.isDirectory() && dir.canRead()) {
                Pattern pattern = Pattern.compile("(full|inc)(\\d{8}-\\d{4}).*");
                Matcher matcher = pattern.matcher("");
                File[] files = dir.listFiles();
                for (int i = 0; i < files.length; ++i) {
                    matcher.reset(files[i].getName());
                    if (!matcher.matches()) continue;
                    try {
                        AbstractBackupDescriptor descriptor = files[i].getName().endsWith(".zip") ? new ZipArchiveBackupDescriptor(files[i]) : new FileSystemBackupDescriptor(files[i]);
                        Properties properties = descriptor.getProperties();
                        if (properties == null) continue;
                        AttributesImpl attrs = new AttributesImpl();
                        attrs.addAttribute("", "file", "file", "CDATA", files[i].getName());
                        builder.startElement(BACKUP_ELEMENT, attrs);
                        Iterator<Object> iter = properties.keySet().iterator();
                        while (iter.hasNext()) {
                            String key = iter.next().toString();
                            builder.startElement(new QName(key, "http://exist.sourceforge.net/NS/exist", ""), null);
                            builder.characters((String)properties.get(key));
                            builder.endElement();
                        }
                        builder.endElement();
                        continue;
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                }
            }
            builder.endElement();
            NodeImpl nodeImpl = builder.getDocument().getNode(nodeNr);
            return nodeImpl;
        }
        finally {
            this.context.popDocumentContext();
        }
    }
}

