/*
 * Decompiled with CFR 0.152.
 */
package org.exist.backup.xquery;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;
import org.exist.backup.ZipArchiveBackupDescriptor;
import org.exist.dom.QName;
import org.exist.http.servlets.ResponseWrapper;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.Variable;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.functions.response.ResponseModule;
import org.exist.xquery.value.JavaObjectValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;

public class RetrieveBackup
extends BasicFunction {
    public static final FunctionSignature signature = new FunctionSignature(new QName("retrieve", "http://exist-db.org/xquery/backups", "backups"), "Retrieves a zipped backup archive and directly streams it to the HTTP response. For security reasons, the function will not allow to read other files. The base directory for the backup files is specified in the first parameter, the second parameter contains the name of the file to retrieve.", new SequenceType[]{new SequenceType(22, 2), new SequenceType(22, 2)}, new SequenceType(11, 1));

    public RetrieveBackup(XQueryContext context) {
        super(context, signature);
    }

    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        String name;
        File backupFile;
        String exportDir = args[0].getStringValue();
        File dir = new File(exportDir);
        if (!dir.isAbsolute()) {
            dir = new File((String)this.context.getBroker().getConfiguration().getProperty("db-connection.data-dir"), exportDir);
        }
        if (!(backupFile = new File(dir, name = args[1].getStringValue())).canRead()) {
            return Sequence.EMPTY_SEQUENCE;
        }
        if (!name.endsWith(".zip")) {
            throw new XPathException(this.getASTNode(), "for security reasons, the function only allows reading zipped backup archives");
        }
        try {
            ZipArchiveBackupDescriptor descriptor = new ZipArchiveBackupDescriptor(backupFile);
            Properties properties = descriptor.getProperties();
            if (properties == null || properties.size() == 0) {
                throw new XPathException(this.getASTNode(), "the file does not see to be a valid backup archive");
            }
        }
        catch (IOException e) {
            throw new XPathException(this.getASTNode(), "the file does not see to be a valid backup archive");
        }
        ResponseModule myModule = (ResponseModule)this.context.getModule("http://exist-db.org/xquery/response");
        Variable respVar = myModule.resolveVariable(ResponseModule.RESPONSE_VAR);
        if (respVar == null) {
            throw new XPathException(this.getASTNode(), "No response object found in the current XQuery context.");
        }
        if (respVar.getValue().getItemType() != 100) {
            throw new XPathException(this.getASTNode(), "Variable $response is not bound to an Java object.");
        }
        JavaObjectValue respValue = (JavaObjectValue)respVar.getValue().itemAt(0);
        if (!"org.exist.http.servlets.HttpResponseWrapper".equals(respValue.getObject().getClass().getName())) {
            throw new XPathException(this.getASTNode(), signature.toString() + " can only be used within the EXistServlet or XQueryServlet");
        }
        ResponseWrapper response = (ResponseWrapper)respValue.getObject();
        response.setHeader("Content-Type", "application/zip");
        try {
            int c;
            FileInputStream is = new FileInputStream(backupFile);
            OutputStream os = response.getOutputStream();
            byte[] buf = new byte[4096];
            while ((c = ((InputStream)is).read(buf)) > -1) {
                os.write(buf, 0, c);
            }
            ((InputStream)is).close();
            os.close();
            response.flushBuffer();
        }
        catch (IOException e) {
            throw new XPathException(this.getASTNode(), "An IO error occurred while reading the backup archive");
        }
        return Sequence.EMPTY_SEQUENCE;
    }
}

