/*
 * Decompiled with CFR 0.152.
 */
package org.exist.client;

import java.util.Date;
import org.exist.xmldb.XmldbURI;

public abstract class ResourceDescriptor {
    private XmldbURI name;
    private String owner;
    private String group;
    private String permissions;
    private Date date;

    public ResourceDescriptor(XmldbURI aName, String aOwner, String aGroup, String aPermissions, Date date) {
        this.name = aName;
        this.owner = aOwner;
        this.group = aGroup;
        this.permissions = aPermissions;
        this.date = date;
    }

    public String getGroup() {
        return this.group;
    }

    public XmldbURI getName() {
        return this.name;
    }

    public String getOwner() {
        return this.owner;
    }

    public String getPermissions() {
        return this.permissions;
    }

    public Date getDate() {
        return this.date;
    }

    public abstract boolean isCollection();

    public static class Collection
    extends ResourceDescriptor {
        public Collection(XmldbURI aName) {
            super(aName, null, null, null, null);
        }

        public Collection(XmldbURI aName, String aOwner, String aGroup, String aPermissions, Date date) {
            super(aName, aOwner, aGroup, aPermissions, date);
        }

        public boolean isCollection() {
            return true;
        }
    }

    public static class Document
    extends ResourceDescriptor {
        public Document(XmldbURI aName, String aOwner, String aGroup, String aPermissions, Date date) {
            super(aName, aOwner, aGroup, aPermissions, date);
        }

        public boolean isCollection() {
            return false;
        }
    }
}

