/*
 * Decompiled with CFR 0.152.
 */
package org.exist.client.xacml;

import com.sun.xacml.ParsingException;
import com.sun.xacml.Policy;
import com.sun.xacml.PolicySet;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Iterator;
import java.util.TreeSet;
import org.apache.log4j.Logger;
import org.exist.client.ClientFrame;
import org.exist.client.xacml.AbstractPolicyNode;
import org.exist.client.xacml.NodeContainer;
import org.exist.client.xacml.PolicyNode;
import org.exist.client.xacml.PolicySetNode;
import org.exist.client.xacml.RootNode;
import org.exist.security.xacml.XACMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.Resource;
import org.xmldb.api.base.XMLDBException;
import org.xmldb.api.modules.CollectionManagementService;
import org.xmldb.api.modules.XMLResource;

public class DatabaseInterface {
    private static final Logger LOG = Logger.getLogger((Class)DatabaseInterface.class);
    private Collection policyCollection;

    private DatabaseInterface() {
    }

    public DatabaseInterface(Collection systemCollection) {
        this.setup(systemCollection);
    }

    public Collection getPolicyCollection() {
        return this.policyCollection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setup(Collection systemCollection) {
        if (systemCollection == null) {
            throw new NullPointerException("System collection cannot be null");
        }
        InputStream in = null;
        try {
            CollectionManagementService service = (CollectionManagementService)systemCollection.getService("CollectionManagementService", "1.0");
            this.policyCollection = service.createCollection("policies");
            Collection confCol = service.createCollection("config/db/system/policies");
            String confName = "policies.xconf";
            XMLResource res = (XMLResource)confCol.createResource(confName, "XMLResource");
            in = DatabaseInterface.class.getResourceAsStream(confName);
            if (in == null) {
                LOG.warn((Object)("Could not find policy collection configuration file '" + confName + "'"));
            }
            String content = XACMLUtil.toString(in);
            res.setContent((Object)content);
            confCol.storeResource((Resource)res);
        }
        catch (IOException ioe) {
            ClientFrame.showErrorMessage("Error setting up XACML editor", ioe);
        }
        catch (XMLDBException xe) {
            ClientFrame.showErrorMessage("Error setting up XACML editor", xe);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException ioe) {}
            }
        }
    }

    public void writePolicies(RootNode root) {
        TreeSet<String> removeDocs;
        try {
            removeDocs = new TreeSet<String>(Arrays.asList(this.policyCollection.listResources()));
        }
        catch (XMLDBException xe) {
            LOG.warn((Object)"Could not list policy collection resources", (Throwable)xe);
            removeDocs = null;
        }
        int size = root.getChildCount();
        for (int i = 0; i < size; ++i) {
            AbstractPolicyNode node = (AbstractPolicyNode)root.getChild(i);
            String documentName = node.getDocumentName();
            if (documentName != null && removeDocs != null) {
                removeDocs.remove(documentName);
            }
            if (!node.isModified(true)) continue;
            node.commit(true);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            node.create().encode((OutputStream)out);
            try {
                XMLResource xres;
                Resource res;
                Resource resource = res = documentName == null ? null : this.policyCollection.getResource(documentName);
                if (res == null) {
                    xres = null;
                } else if (res instanceof XMLResource) {
                    xres = (XMLResource)res;
                } else {
                    xres = null;
                    this.policyCollection.removeResource(res);
                }
                if (xres == null) {
                    xres = (XMLResource)this.policyCollection.createResource(documentName, "XMLResource");
                    if (documentName == null) {
                        documentName = xres.getDocumentId();
                        node.setDocumentName(documentName);
                    }
                }
                xres.setContent((Object)out.toString());
                this.policyCollection.storeResource((Resource)xres);
                node.commit(true);
                continue;
            }
            catch (XMLDBException e) {
                StringBuffer message = new StringBuffer();
                message.append("Error saving policy '");
                message.append(node.getId());
                message.append("' ");
                if (documentName != null) {
                    message.append(" to document '");
                    message.append(documentName);
                    message.append("' ");
                }
                ClientFrame.showErrorMessage(message.toString(), e);
            }
        }
        if (removeDocs == null) {
            return;
        }
        Iterator it = removeDocs.iterator();
        while (it.hasNext()) {
            String documentName = (String)it.next();
            try {
                Resource removeResource = this.policyCollection.getResource(documentName);
                this.policyCollection.removeResource(removeResource);
            }
            catch (XMLDBException xe) {
                LOG.warn((Object)("Could not remove resource '" + documentName + "'"), (Throwable)xe);
            }
        }
    }

    public RootNode getPolicies() {
        RootNode root = new RootNode();
        this.findPolicies(root);
        root.commit(true);
        return root;
    }

    private void findPolicies(RootNode root) {
        try {
            String[] resourceIds = this.policyCollection.listResources();
            for (int i = 0; i < resourceIds.length; ++i) {
                String resourceId = resourceIds[i];
                Resource resource = this.policyCollection.getResource(resourceId);
                if (resource == null || !(resource instanceof XMLResource)) continue;
                this.handleResource((XMLResource)resource, root);
            }
        }
        catch (XMLDBException xe) {
            ClientFrame.showErrorMessage("Error scanning for policies", xe);
        }
    }

    private void handleResource(XMLResource xres, RootNode root) throws XMLDBException {
        Element rootElement;
        String documentName = xres.getDocumentId();
        Node content = xres.getContentAsDOM();
        if (content instanceof Document) {
            rootElement = ((Document)content).getDocumentElement();
        } else if (content instanceof Element) {
            rootElement = (Element)content;
        } else {
            LOG.warn((Object)("The DOM representation of resource '" + documentName + "' in the policy collection was not a Document or Element node."));
            return;
        }
        String namespace = rootElement.getNamespaceURI();
        String tagName = rootElement.getTagName();
        if ("Policy".equals(tagName)) {
            Policy policy;
            try {
                policy = Policy.getInstance((Node)rootElement);
            }
            catch (ParsingException pe) {
                ClientFrame.showErrorMessage("Error parsing policy document '" + documentName + "'", pe);
                return;
            }
            root.add(new PolicyNode((NodeContainer)root, documentName, policy));
        } else if ("PolicySet".equals(tagName)) {
            PolicySet policySet;
            try {
                policySet = PolicySet.getInstance((Node)rootElement);
            }
            catch (ParsingException pe) {
                ClientFrame.showErrorMessage("Error parsing policy set document '" + documentName + "'", pe);
                return;
            }
            root.add(new PolicySetNode((NodeContainer)root, documentName, policySet));
        } else {
            LOG.warn((Object)("Document '" + documentName + "' in policy collection is not a policy: root tag has namespace '" + namespace + "' and name '" + tagName + "'"));
        }
    }
}

