/*
 * Decompiled with CFR 0.152.
 */
package org.exist.client.xacml;

import com.sun.xacml.ParsingException;
import com.sun.xacml.UnknownIdentifierException;
import com.sun.xacml.attr.AttributeDesignator;
import com.sun.xacml.attr.AttributeFactory;
import com.sun.xacml.attr.AttributeValue;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URI;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.Spring;
import javax.swing.SpringLayout;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.exist.client.ClientFrame;
import org.exist.client.xacml.Abbreviator;
import org.exist.client.xacml.AttributeHandler;

public class MatchEditor
extends JPanel
implements ActionListener,
DocumentListener {
    private static final String EMPTY_TEXT = "Select an attribute to edit";
    private static final int MAXIMUM_BOX_WIDTH = 450;
    private AttributeDesignator attribute;
    private JLabel label;
    private JComboBox functionBox;
    private JComboBox valueBox;
    private Abbreviator abbrev;
    private List listeners = new ArrayList(2);
    private List attributeHandlers = new ArrayList(2);
    private Object currentFunction;
    private Object currentValue;

    private MatchEditor() {
    }

    public MatchEditor(Abbreviator abbrev) {
        this.abbrev = abbrev;
        this.setup();
    }

    private void setup() {
        SpringLayout layout = new SpringLayout();
        this.setLayout(layout);
        this.setOpaque(true);
        this.label = new JLabel(EMPTY_TEXT);
        this.functionBox = new JComboBox();
        this.functionBox.setEditable(false);
        this.functionBox.setMaximumSize(this.restrictWidth(this.functionBox.getMaximumSize()));
        this.valueBox = new JComboBox();
        this.valueBox.setEditable(true);
        this.valueBox.setMaximumSize(this.restrictWidth(this.functionBox.getMaximumSize()));
        Component comp = this.valueBox.getEditor().getEditorComponent();
        if (comp instanceof JTextComponent) {
            ((JTextComponent)comp).getDocument().addDocumentListener(this);
        }
        this.setBoxesVisible(false);
        this.add(this.label);
        this.add(this.functionBox);
        this.add(this.valueBox);
        Spring constant6 = Spring.constant(6);
        layout.putConstraint("North", (Component)this.label, constant6, "North", (Component)this);
        layout.putConstraint("North", (Component)this.functionBox, constant6, "North", (Component)this);
        layout.putConstraint("North", (Component)this.valueBox, constant6, "North", (Component)this);
        Spring bottom = layout.getConstraint("South", this.label);
        bottom = Spring.max(bottom, layout.getConstraint("South", this.functionBox));
        bottom = Spring.max(bottom, layout.getConstraint("South", this.valueBox));
        layout.putConstraint("South", (Component)this, bottom, "North", (Component)this);
        layout.putConstraint("West", (Component)this.functionBox, constant6, "East", (Component)this.label);
        layout.putConstraint("West", (Component)this.valueBox, constant6, "East", (Component)this.functionBox);
        layout.putConstraint("East", (Component)this, Spring.constant(6, 6, Short.MAX_VALUE), "East", (Component)this.valueBox);
    }

    public void setMatch(AttributeDesignator attribute, URI functionId, AttributeValue value) {
        this.valueBox.removeActionListener(this);
        this.functionBox.removeActionListener(this);
        Component comp = this.valueBox.getEditor().getEditorComponent();
        Document doc = null;
        if (comp instanceof JTextComponent) {
            doc = ((JTextComponent)comp).getDocument();
            doc.removeDocumentListener(this);
        }
        this.attribute = attribute;
        if (attribute == null) {
            this.label.setText(EMPTY_TEXT);
            this.setBoxesVisible(false);
            return;
        }
        URI dataType = attribute.getType();
        this.label.setText(this.abbrev.getAbbreviatedId(attribute.getId()) + " (" + this.abbrev.getAbbreviatedType(dataType) + ")");
        Set targetFunctions = this.abbrev.getAbbreviatedTargetFunctions(dataType);
        Iterator it = this.attributeHandlers.iterator();
        while (it.hasNext()) {
            ((AttributeHandler)it.next()).filterFunctions(targetFunctions, attribute);
        }
        this.functionBox.setModel(new DefaultComboBoxModel<Object>(targetFunctions.toArray()));
        if (functionId == null) {
            if (this.functionBox.getItemCount() > 0) {
                this.functionBox.setSelectedIndex(0);
            }
        } else {
            this.functionBox.setSelectedItem(this.abbrev.getAbbreviatedTargetFunctionId(functionId, dataType));
        }
        this.functionBox.setMaximumSize(this.restrictWidth(this.functionBox.getPreferredSize()));
        this.valueBox.setEditable(true);
        TreeSet allowedValues = new TreeSet();
        Iterator it2 = this.attributeHandlers.iterator();
        while (it2.hasNext()) {
            if (((AttributeHandler)it2.next()).getAllowedValues(allowedValues, attribute)) continue;
            this.valueBox.setEditable(false);
            break;
        }
        this.valueBox.setModel(new DefaultComboBoxModel<Object>(allowedValues.toArray()));
        if (this.valueBox.isEditable()) {
            Dimension max = this.valueBox.getMaximumSize();
            max.width = 450;
            this.valueBox.setMaximumSize(max);
        } else {
            this.valueBox.setMaximumSize(this.restrictWidth(this.valueBox.getMaximumSize()));
        }
        this.valueBox.setSelectedItem(value == null ? null : value.encode());
        this.setBoxesVisible(true);
        this.currentValue = this.valueBox.getSelectedItem();
        this.currentFunction = this.functionBox.getSelectedItem();
        this.valueBox.addActionListener(this);
        this.functionBox.addActionListener(this);
        if (doc != null) {
            doc.addDocumentListener(this);
        }
    }

    private Dimension restrictWidth(Dimension size) {
        if (size.width > 450) {
            size.width = 450;
        }
        return size;
    }

    private void setBoxesVisible(boolean b) {
        this.functionBox.setVisible(b);
        this.valueBox.setVisible(b);
    }

    public URI getFunctionId() {
        return this.currentFunction == null ? null : this.abbrev.getFullFunctionId((String)this.currentFunction, this.attribute.getType());
    }

    public AttributeValue getValue() {
        if (this.attribute == null || this.currentValue == null) {
            return null;
        }
        AttributeFactory factory = AttributeFactory.getInstance();
        try {
            String textValue = this.currentValue.toString();
            if (textValue == null || textValue.length() == 0) {
                return null;
            }
            AttributeValue value = factory.createValue(this.attribute.getType(), textValue);
            Iterator it = this.attributeHandlers.iterator();
            while (it.hasNext()) {
                ((AttributeHandler)it.next()).checkUserValue(value, this.attribute);
            }
            return value;
        }
        catch (UnknownIdentifierException e) {
            ClientFrame.showErrorMessage("Invalid attribute type '" + this.attribute.getType() + "'", e);
            return null;
        }
        catch (ParsingException e) {
            ClientFrame.showErrorMessage("Invalid value '" + this.currentValue + "'", e);
            return null;
        }
    }

    public AttributeDesignator getAttribute() {
        return this.attribute;
    }

    public void addAttributeHandler(AttributeHandler ah) {
        if (ah == null) {
            return;
        }
        if (this.attributeHandlers == null) {
            this.attributeHandlers = new ArrayList();
        }
        this.attributeHandlers.add(ah);
    }

    public void removeAttributeHandler(AttributeHandler ah) {
        if (ah == null || this.attributeHandlers == null) {
            return;
        }
        this.attributeHandlers.remove(ah);
    }

    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (source == this.functionBox) {
            this.currentFunction = this.functionBox.getSelectedItem();
        } else if (source == this.valueBox) {
            this.currentValue = this.valueBox.getSelectedItem();
        } else {
            return;
        }
        this.fireChanged();
    }

    private void fireChanged() {
        ChangeEvent event = new ChangeEvent(this);
        Iterator it = this.listeners.iterator();
        while (it.hasNext()) {
            ((ChangeListener)it.next()).stateChanged(event);
        }
    }

    public void addChangeListener(ChangeListener listener) {
        if (listener != null) {
            this.listeners.add(listener);
        }
    }

    public void removeChangeListener(ChangeListener listener) {
        if (this.listeners != null) {
            this.listeners.remove(this.listeners);
        }
    }

    private void documentUpdated(DocumentEvent event) {
        Document doc = event.getDocument();
        try {
            this.currentValue = doc.getText(0, doc.getLength());
        }
        catch (BadLocationException e) {
            return;
        }
        this.fireChanged();
    }

    public void changedUpdate(DocumentEvent event) {
        this.documentUpdated(event);
    }

    public void insertUpdate(DocumentEvent event) {
        this.documentUpdated(event);
    }

    public void removeUpdate(DocumentEvent event) {
        this.documentUpdated(event);
    }
}

