/*
 * Decompiled with CFR 0.152.
 */
package org.exist.client.xacml;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.exist.client.xacml.AbstractPolicyNode;
import org.exist.client.xacml.AbstractTreeNode;
import org.exist.client.xacml.ConditionNode;
import org.exist.client.xacml.PolicyElementNode;
import org.exist.client.xacml.PolicyNode;
import org.exist.client.xacml.PolicySetNode;
import org.exist.client.xacml.RootNode;
import org.exist.client.xacml.RuleNode;
import org.exist.client.xacml.TargetNode;
import org.exist.client.xacml.XACMLTreeNode;
import org.exist.util.MimeType;

public class NodeTransferable
implements Transferable {
    private static final String FLAVOR_DESCRIPTION = "XACML Element";
    private static final Map CLASS_TO_FLAVOR = new HashMap();
    public static final DataFlavor CONDITION_FLAVOR = NodeTransferable.createFlavor(ConditionNode.class);
    public static final DataFlavor TARGET_FLAVOR = NodeTransferable.createFlavor(TargetNode.class);
    public static final DataFlavor RULE_FLAVOR = NodeTransferable.createFlavor(RuleNode.class);
    public static final DataFlavor POLICY_FLAVOR = NodeTransferable.createFlavor(PolicyNode.class);
    public static final DataFlavor POLICY_SET_FLAVOR = NodeTransferable.createFlavor(PolicySetNode.class);
    public static final DataFlavor ABSTRACT_POLICY_FLAVOR = NodeTransferable.createFlavor(AbstractPolicyNode.class);
    public static final DataFlavor POLICY_ELEMENT_FLAVOR = NodeTransferable.createFlavor(PolicyElementNode.class);
    public static final DataFlavor ROOT_FLAVOR = NodeTransferable.createFlavor(RootNode.class);
    public static final DataFlavor ABSTRACT_NODE_FLAVOR = NodeTransferable.createFlavor(AbstractTreeNode.class);
    public static final DataFlavor NODE_FLAVOR = NodeTransferable.createFlavor(XACMLTreeNode.class);
    public static final DataFlavor TEXT_XML_FLAVOR = new DataFlavor(MimeType.XML_TYPE.getName(), "XACML Element (XML)");
    public static final DataFlavor APPLICATION_XML_FLAVOR = new DataFlavor("application/xml", "XACML Element (XML)");
    private Set supportedFlavors;
    private XACMLTreeNode node;

    private static DataFlavor createFlavor(Class c) {
        DataFlavor ret = new DataFlavor(c, FLAVOR_DESCRIPTION);
        CLASS_TO_FLAVOR.put(c, ret);
        return ret;
    }

    public NodeTransferable(XACMLTreeNode node) {
        this.node = node;
        this.supportedFlavors = new LinkedHashSet();
        this.supportedFlavors.add(TEXT_XML_FLAVOR);
        this.supportedFlavors.add(APPLICATION_XML_FLAVOR);
        this.supportedFlavors.add(DataFlavor.stringFlavor);
        for (Class<?> c = node.getClass(); c != null; c = c.getSuperclass()) {
            DataFlavor flavor = (DataFlavor)CLASS_TO_FLAVOR.get(c);
            if (flavor == null) continue;
            this.supportedFlavors.add(flavor);
        }
    }

    public DataFlavor[] getTransferDataFlavors() {
        DataFlavor[] ret = new DataFlavor[this.supportedFlavors.size()];
        this.supportedFlavors.toArray(ret);
        return ret;
    }

    public boolean isDataFlavorSupported(DataFlavor flavor) {
        return this.supportedFlavors.contains(flavor);
    }

    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
        if (XACMLTreeNode.class.isAssignableFrom(flavor.getRepresentationClass())) {
            return this.node;
        }
        if (DataFlavor.stringFlavor.equals(flavor)) {
            return this.node.serialize(true);
        }
        if (TEXT_XML_FLAVOR.equals(flavor)) {
            return this.serialize(true);
        }
        if (APPLICATION_XML_FLAVOR.equals(flavor)) {
            return this.serialize(false);
        }
        throw new UnsupportedFlavorException(flavor);
    }

    private InputStream serialize(boolean indent) {
        String serializedString = this.node.serialize(true);
        return new ByteArrayInputStream(serializedString.getBytes());
    }
}

