/*
 * Decompiled with CFR 0.152.
 */
package org.exist.client.xacml;

import com.sun.xacml.Policy;
import com.sun.xacml.PolicySet;
import com.sun.xacml.Rule;
import com.sun.xacml.Target;
import com.sun.xacml.combine.OrderedPermitOverridesPolicyAlg;
import com.sun.xacml.combine.OrderedPermitOverridesRuleAlg;
import com.sun.xacml.combine.PolicyCombiningAlgorithm;
import com.sun.xacml.combine.RuleCombiningAlgorithm;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;
import org.exist.client.xacml.AbstractPolicyEditor;
import org.exist.client.xacml.AbstractPolicyNode;
import org.exist.client.xacml.ConditionNode;
import org.exist.client.xacml.CustomRenderer;
import org.exist.client.xacml.DatabaseInterface;
import org.exist.client.xacml.NodeEditor;
import org.exist.client.xacml.PolicyElementContainer;
import org.exist.client.xacml.RootNode;
import org.exist.client.xacml.RuleEditor;
import org.exist.client.xacml.RuleNode;
import org.exist.client.xacml.TargetEditor;
import org.exist.client.xacml.TargetNode;
import org.exist.client.xacml.TreeMutator;
import org.exist.client.xacml.XACMLTreeModel;
import org.exist.client.xacml.XACMLTreeNode;
import org.xmldb.api.base.Collection;

public class XACMLEditor
extends JFrame
implements ActionListener,
TreeModelListener,
TreeSelectionListener,
WindowListener {
    private static final String DEFAULT_DESCRIPTION = "This is a policy template.  It will match and deny everything until you change the target and add rules.";
    private static final String DEFAULT_RULE_DESCRIPTION = "This rule denies everything that is not permitted by the rules above it when used with the ordered permit overrides combining algorithm.  Any rules below it will not be evaluated, so it should be the last rule";
    private static final String DEFAULT_POLICY_ID = "NewPolicy";
    private static final String DEFAULT_POLICY_SET_ID = "NewPolicySet";
    private static final String DEFAULT_RULE_ID = "NewRule";
    private static final String CLOSE = "Close";
    private static final String SAVE = "Save";
    private static final int MIN_FRAME_WIDTH = 600;
    private static final int MIN_FRAME_HEIGHT = 350;
    private static final int MINIMUM_TREE_WIDTH = 100;
    private DatabaseInterface dbInterface;
    private XACMLTreeModel model;
    private JTree tree;
    private NodeEditor editor;
    private JSplitPane split;

    private XACMLEditor() {
    }

    public XACMLEditor(Collection systemCollection) {
        super("XACML Policy Editor");
        this.setDefaultCloseOperation(0);
        this.addWindowListener(this);
        this.dbInterface = new DatabaseInterface(systemCollection);
        this.setupMenuBar();
        this.createInterface();
        this.pack();
        Dimension size = this.getSize();
        if (size.width <= 600) {
            size.width = 600;
        }
        if (size.height <= 350) {
            size.height = 350;
        }
        this.setSize(size);
    }

    private void createInterface() {
        this.split = new JSplitPane(1, true);
        this.getContentPane().add(this.split);
        this.model = new XACMLTreeModel(this.dbInterface.getPolicies());
        this.model.addTreeModelListener(this);
        this.tree = new JTree(this.model);
        this.tree.getSelectionModel().setSelectionMode(1);
        TreeMutator mutator = new TreeMutator(this.tree);
        this.tree.addTreeSelectionListener(this);
        this.tree.setCellRenderer(new CustomRenderer(mutator));
        this.tree.setEditable(false);
        this.tree.setShowsRootHandles(true);
        this.tree.setRootVisible(false);
        Dimension minSize = this.tree.getMinimumSize();
        if (minSize.width < 100) {
            minSize.width = 100;
        }
        this.tree.setMinimumSize(minSize);
        JScrollPane scroll = new JScrollPane(this.tree);
        this.split.setLeftComponent(scroll);
        this.split.setRightComponent(new JScrollPane());
        this.split.setOneTouchExpandable(false);
    }

    public void close() {
        if (this.hasUnsavedChanges()) {
            String message = "There are unsaved changes.  Do you want to save your changes before closing?";
            String title = "Save changes?";
            int ret = JOptionPane.showConfirmDialog(this, message, title, 1, 3);
            if (ret == 2) {
                return;
            }
            if (ret == 0) {
                this.saveAll();
            }
        }
        this.dispose();
    }

    public boolean hasUnsavedChanges() {
        return this.model.hasUnsavedChanges();
    }

    public void saveAll() {
        if (this.editor != null) {
            this.editor.pushChanges();
        }
        this.dbInterface.writePolicies((RootNode)this.model.getRoot());
        this.tree.repaint();
    }

    public static PolicySet createDefaultPolicySet(PolicyElementContainer parent) {
        return XACMLEditor.createDefaultPolicySet(XACMLEditor.createUniqueId(parent, DEFAULT_POLICY_SET_ID));
    }

    public static PolicySet createDefaultPolicySet(String policySetID) {
        OrderedPermitOverridesPolicyAlg alg = new OrderedPermitOverridesPolicyAlg();
        return new PolicySet(URI.create(policySetID), (PolicyCombiningAlgorithm)alg, XACMLEditor.createEmptyTarget());
    }

    public static Target createEmptyTarget() {
        return new Target(Collections.EMPTY_LIST, Collections.EMPTY_LIST, Collections.EMPTY_LIST);
    }

    public static Policy createDefaultPolicy(PolicyElementContainer parent) {
        return XACMLEditor.createDefaultPolicy(XACMLEditor.createUniqueId(parent, DEFAULT_POLICY_ID));
    }

    public static Policy createDefaultPolicy(String policyID) {
        Target emptyTarget = XACMLEditor.createEmptyTarget();
        OrderedPermitOverridesRuleAlg alg = new OrderedPermitOverridesRuleAlg();
        Rule denyEverythingRule = XACMLEditor.createDefaultRule("DenyAll");
        List<Rule> rules = Collections.singletonList(denyEverythingRule);
        return new Policy(URI.create(policyID), (RuleCombiningAlgorithm)alg, DEFAULT_DESCRIPTION, emptyTarget, rules);
    }

    public static Rule createDefaultRule(PolicyElementContainer parent) {
        return XACMLEditor.createDefaultRule(XACMLEditor.createUniqueId(parent, DEFAULT_RULE_ID));
    }

    public static String createUniqueId(PolicyElementContainer parent, String base) {
        if (parent == null) {
            throw new NullPointerException("Parent cannot be null");
        }
        String newId = base;
        int i = 2;
        while (parent.containsId(newId)) {
            newId = base + Integer.toString(i);
            ++i;
        }
        return newId;
    }

    public static Rule createDefaultRule(String id) {
        return new Rule(URI.create(id), 1, DEFAULT_RULE_DESCRIPTION, null, null);
    }

    private void setupMenuBar() {
        JMenuBar menuBar = new JMenuBar();
        this.setJMenuBar(menuBar);
        JMenu file = new JMenu("File");
        file.setMnemonic(70);
        menuBar.add(file);
        JMenuItem saveItem = new JMenuItem(SAVE, 83);
        saveItem.setActionCommand(SAVE);
        saveItem.setAccelerator(KeyStroke.getKeyStroke(83, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        saveItem.addActionListener(this);
        file.add(saveItem);
        JMenuItem closeItem = new JMenuItem(CLOSE, 87);
        closeItem.setActionCommand(CLOSE);
        closeItem.setAccelerator(KeyStroke.getKeyStroke(87, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        closeItem.addActionListener(this);
        file.add(closeItem);
    }

    public void actionPerformed(ActionEvent event) {
        String actionCommand = event.getActionCommand();
        if (CLOSE.equals(actionCommand)) {
            this.close();
        } else if (SAVE.equals(actionCommand)) {
            this.saveAll();
        }
    }

    private void forceRepaint() {
        Container contentPane = this.getContentPane();
        contentPane.invalidate();
        contentPane.validate();
        contentPane.repaint();
    }

    public void valueChanged(TreeSelectionEvent event) {
        TreePath selectedPath;
        Object value;
        if (this.editor != null) {
            this.editor.pushChanges();
            this.editor = null;
        }
        if ((value = (selectedPath = event.getPath()).getLastPathComponent()) instanceof AbstractPolicyNode) {
            this.editor = new AbstractPolicyEditor();
        } else if (value instanceof RuleNode) {
            this.editor = new RuleEditor();
        } else if (value instanceof ConditionNode) {
            this.editor = null;
        } else if (value instanceof TargetNode) {
            this.editor = new TargetEditor(this.dbInterface);
        }
        int dividerLocation = this.split.getDividerLocation();
        JScrollPane scroll = (JScrollPane)this.split.getRightComponent();
        if (this.editor == null) {
            scroll.setViewportView(null);
        } else {
            this.editor.setNode((XACMLTreeNode)value);
            scroll.setViewportView(this.editor.getComponent());
        }
        this.split.setDividerLocation(dividerLocation);
        this.forceRepaint();
    }

    public void windowActivated(WindowEvent event) {
    }

    public void windowClosed(WindowEvent event) {
    }

    public void windowClosing(WindowEvent event) {
        this.close();
    }

    public void windowDeactivated(WindowEvent event) {
    }

    public void windowDeiconified(WindowEvent event) {
    }

    public void windowIconified(WindowEvent event) {
    }

    public void windowOpened(WindowEvent event) {
    }

    private void treeChanged(TreeModelEvent event) {
        this.tree.revalidate();
        this.tree.repaint();
    }

    public void treeNodesChanged(TreeModelEvent event) {
        this.treeChanged(event);
    }

    public void treeNodesInserted(TreeModelEvent event) {
        this.treeChanged(event);
    }

    public void treeNodesRemoved(TreeModelEvent event) {
        this.treeChanged(event);
    }

    public void treeStructureChanged(TreeModelEvent event) {
        this.treeChanged(event);
    }
}

