/*
 * Decompiled with CFR 0.152.
 */
package org.exist.client.xacml;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.exist.client.xacml.NodeChangeListener;
import org.exist.client.xacml.NodeContainer;
import org.exist.client.xacml.PolicyElementNode;
import org.exist.client.xacml.RootNode;
import org.exist.client.xacml.XACMLTreeNode;

public class XACMLTreeModel
implements NodeChangeListener,
TreeModel {
    private List listeners = new ArrayList(2);
    private RootNode root;

    private XACMLTreeModel() {
    }

    public XACMLTreeModel(RootNode root) {
        if (root == null) {
            throw new NullPointerException("Root node cannot be null");
        }
        this.root = root;
        root.addNodeChangeListener(this);
    }

    public Object getRoot() {
        return this.root;
    }

    public int getChildCount(Object parent) {
        if (parent instanceof NodeContainer) {
            return ((NodeContainer)parent).getChildCount();
        }
        return 0;
    }

    public boolean isLeaf(Object parent) {
        return parent != this.root && !(parent instanceof PolicyElementNode);
    }

    public Object getChild(Object parent, int index) {
        if (parent instanceof NodeContainer) {
            return ((NodeContainer)parent).getChild(index);
        }
        return null;
    }

    public int getIndexOfChild(Object parent, Object child) {
        if (parent instanceof NodeContainer) {
            return ((NodeContainer)parent).indexOfChild(child);
        }
        return -1;
    }

    public void valueForPathChanged(TreePath path, Object newValue) {
    }

    public void addTreeModelListener(TreeModelListener listener) {
        if (listener != null) {
            this.listeners.add(listener);
        }
    }

    public void removeTreeModelListener(TreeModelListener listener) {
        if (listener != null) {
            this.listeners.remove(listener);
        }
    }

    public boolean hasUnsavedChanges() {
        return this.root.isModified(true);
    }

    public void revert() {
        this.root.revert(true);
    }

    public void commit() {
        this.root.commit(true);
    }

    public void nodeChanged(XACMLTreeNode node) {
        TreePath path = XACMLTreeModel.getPathToNode(node);
        TreeModelEvent event = new TreeModelEvent((Object)this, path);
        Iterator it = this.listeners.iterator();
        while (it.hasNext()) {
            ((TreeModelListener)it.next()).treeNodesChanged(event);
        }
    }

    public void nodeAdded(XACMLTreeNode node, int newIndex) {
        TreeModelEvent event = this.getEvent(node, newIndex);
        Iterator it = this.listeners.iterator();
        while (it.hasNext()) {
            ((TreeModelListener)it.next()).treeNodesInserted(event);
        }
    }

    public void nodeRemoved(XACMLTreeNode removedNode, int oldChildIndex) {
        TreeModelEvent event = this.getEvent(removedNode, oldChildIndex);
        Iterator it = this.listeners.iterator();
        while (it.hasNext()) {
            ((TreeModelListener)it.next()).treeNodesRemoved(event);
        }
    }

    private TreeModelEvent getEvent(XACMLTreeNode node, int index) {
        TreePath path = XACMLTreeModel.getPathToNode(node.getParent());
        int[] childIndices = new int[]{index};
        Object[] child = new Object[]{node};
        TreeModelEvent event = new TreeModelEvent((Object)this, path, childIndices, child);
        return event;
    }

    public static TreePath getPathToNode(XACMLTreeNode node) {
        NodeContainer parent = node.getParent();
        if (parent == null) {
            return new TreePath(node);
        }
        return XACMLTreeModel.getPathToNode(parent).pathByAddingChild(node);
    }
}

