/*
 * Decompiled with CFR 0.152.
 */
package org.exist.cluster;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.exist.cluster.ClusterChannel;
import org.exist.cluster.ClusterEvent;
import org.exist.cluster.ClusterException;
import org.exist.cluster.CreateCollectionClusterEvent;
import org.exist.cluster.RemoveClusterEvent;
import org.exist.cluster.RemoveCollectionClusterEvent;
import org.exist.cluster.StoreClusterEvent;
import org.exist.cluster.UpdateClusterEvent;
import org.exist.cluster.cocoon.ConsoleInfo;
import org.exist.cluster.journal.JournalIdGenerator;
import org.exist.cluster.journal.JournalManager;
import org.exist.util.Configuration;
import org.jgroups.Address;
import org.jgroups.Channel;
import org.jgroups.JChannel;
import org.jgroups.MembershipListener;
import org.jgroups.SuspectedException;
import org.jgroups.View;
import org.jgroups.blocks.RpcDispatcher;
import org.jgroups.util.RspList;

public class ClusterComunication
implements MembershipListener {
    public static final String CONFIGURATION_ELEMENT_NAME = "cluster";
    public static final String CLUSTER_PROTOCOL_ATTRIBUTE = "protocol";
    public static final String CLUSTER_USER_ATTRIBUTE = "dbaUser";
    public static final String CLUSTER_PWD_ATTRIBUTE = "dbaPassword";
    public static final String CLUSTER_EXCLUDED_COLLECTIONS_ATTRIBUTE = "exclude";
    public static final String PROPERTY_CLUSTER_PROTOCOL = "cluster.protocol";
    public static final String PROPERTY_CLUSTER_USER = "cluster.user";
    public static final String PROPERTY_CLUSTER_PWD = "cluster.pwd";
    public static final String PROPERTY_CLUSTER_EXCLUDED_COLLECTIONS = "cluster.exclude";
    private static Logger log = Logger.getLogger((Class)ClusterComunication.class);
    private static JChannel channel;
    private static RpcDispatcher disp;
    private static final String banner = " #####  #       #     #  #####  ####### ####### ######\n#     # #       #     # #     #    #    #       #     #\n#       #       #     # #          #    #       #     #\n#       #       #     #  #####     #    #####   ######\n#       #       #     #       #    #    #       #   #\n#     # #       #     # #     #    #    #       #    #\n #####  #######  #####   #####     #    ####### #     #\n\n\n ######  #    #     #     ####    #####\n #        #  #      #    #          #\n #####     ##       #     ####      #\n #         ##       #         #     #\n #        #  #      #    #    #     #\n ######  #    #     #     ####      #";
    public static final String DEFAULT_PROTOCOL_STACK = "UDP(mcast_addr=228.1.2.3;mcast_port=45566;ip_ttl=32;loopback=true):PING(timeout=3000;num_initial_members=6):FD(timeout=3000):VERIFY_SUSPECT(timeout=1500):pbcast.NAKACK(gc_lag=10;retransmit_timeout=600,1200,2400,4800):UNICAST(timeout=600,1200,2400,4800):pbcast.STABLE(desired_avg_gossip=10000):FRAG:pbcast.GMS(join_timeout=5000;join_retry_timeout=2000;shun=true;print_local_addr=true)";
    private static ClusterComunication instance;
    private Vector membersNoSender = new Vector();
    private Address localAddress;
    private Address coordinatorAddress;
    private static String dbaUser;
    private static String dbaPwd;
    private static ArrayList excludedCollection;
    private JournalManager journalManager;
    private JournalIdGenerator journalIdGenerator;
    private boolean coordinator = false;
    private boolean isRealign = true;
    private ArrayList realignQueue = new ArrayList();
    private boolean viewConfigured = false;
    private int shift;
    private Configuration configuration;
    static /* synthetic */ Class array$I;
    static /* synthetic */ Class class$java$lang$Integer;

    public static String getDbaUser() {
        return dbaUser;
    }

    public static String getDbaPwd() {
        return dbaPwd;
    }

    private static void createInstance(Configuration conf) throws ClusterException {
        ClusterComunication c = new ClusterComunication();
        System.out.println(banner);
        try {
            String protocol = (String)conf.getProperty(PROPERTY_CLUSTER_PROTOCOL);
            dbaUser = (String)conf.getProperty(PROPERTY_CLUSTER_USER);
            dbaPwd = (String)conf.getProperty(PROPERTY_CLUSTER_PWD);
            excludedCollection = (ArrayList)conf.getProperty(PROPERTY_CLUSTER_EXCLUDED_COLLECTIONS);
            if (protocol == null) {
                protocol = DEFAULT_PROTOCOL_STACK;
            }
            System.out.println("PROTOCOL \n" + protocol);
            channel = new JChannel(protocol);
            disp = new RpcDispatcher((Channel)channel, null, (MembershipListener)c, (Object)c);
            disp.setDeadlockDetection(true);
            c.configuration = conf;
            c.journalManager = new JournalManager(conf);
            c.journalIdGenerator = new JournalIdGenerator(c.journalManager, (Integer)conf.getProperty("cluster.journal.maxStore"));
            c.shift = (Integer)conf.getProperty("cluster.journal.shift");
            instance = c;
            channel.connect("eXist-cluster");
            c.localAddress = channel.getLocalAddress();
            while (!c.viewConfigured) {
                log.info((Object)"SLEEPING - WAITING TO CONFIGURE THE CLUSTER");
                Thread.sleep(2000L);
            }
            if (c.isRealign) {
                log.info((Object)("TRY TO REALIGNING " + Thread.currentThread().getName()));
                c.realign();
                c.isRealign = false;
            }
            log.info((Object)("REALIGNED ... " + Thread.currentThread().getName()));
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error((Object)("Error during cluster JGroups environment configuration " + e));
            throw new ClusterException("ERROR CREATING CLUSTER ...", e);
        }
    }

    private ClusterComunication() {
    }

    public void viewAccepted(View view) {
        this.coordinatorAddress = view.getCreator();
        boolean coordinator = this.coordinatorAddress.equals(this.localAddress);
        log.info((Object)("COordinator : " + coordinator + " localAddress : " + this.localAddress));
        if (coordinator) {
            log.info((Object)"***************** I'M MASTER!!!!!!!!!");
        }
        if (coordinator && !this.coordinator && this.journalIdGenerator != null) {
            this.journalIdGenerator.shiftId(this.shift);
        }
        this.coordinator = this.coordinatorAddress.equals(this.localAddress);
        Vector members = (Vector)view.getMembers().clone();
        members.removeElement(channel.getLocalAddress());
        this.membersNoSender = members;
        this.viewConfigured = true;
    }

    public void suspect(Address address) {
        if (this.coordinatorAddress.equals(address)) {
            log.info((Object)"MASTER IS DEAD");
        }
    }

    public void block() {
    }

    public static ClusterComunication getInstance() {
        return instance;
    }

    public boolean isCoordinator() {
        return this.coordinator;
    }

    public Address getCoordinator() {
        return this.coordinatorAddress;
    }

    public Address getAddress() {
        return this.localAddress;
    }

    public Vector getMembersNoCoordinator() {
        Vector members = (Vector)this.membersNoSender.clone();
        members.remove(this.coordinatorAddress);
        return members;
    }

    public HashMap getConsoleInfos(Vector address) {
        HashMap<String, Object> response = new HashMap<String, Object>();
        RspList list = disp.callRemoteMethods(address, "getConsoleProperties", new Object[0], new Class[0], 2, 0L);
        for (int i = 0; i < address.size(); ++i) {
            Address addr = (Address)address.get(i);
            response.put(addr.toString(), list.get(addr));
        }
        return response;
    }

    public int[][] getHeaders() throws ClusterException {
        int[][] data = new int[2][];
        data[0] = new int[]{this.journalManager.getLastIdSaved(), this.journalManager.getMaxIdSaved(), this.journalManager.getCounter()};
        try {
            if (!this.coordinator) {
                data[1] = (int[])disp.callRemoteMethod(this.coordinatorAddress, "getRemoteHeader", new Object[0], new Class[0], 1, 0L);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new ClusterException("Error retrieving ...", e);
        }
        return data;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public static void configure(Configuration c) throws ClusterException {
        ClusterComunication.createInstance(c);
    }

    public void synch() throws ClusterException {
        this.journalManager.squeueEvent();
    }

    public void removeDocument(String collection, String documentName) throws ClusterException {
        if (excludedCollection.contains(collection)) {
            return;
        }
        this.remoteInvocation(new RemoveClusterEvent(documentName, collection));
    }

    public void storeDocument(String collection, String documentName, String content) throws ClusterException {
        if (excludedCollection.contains(collection)) {
            return;
        }
        this.remoteInvocation(new StoreClusterEvent(content, collection, documentName));
    }

    public void addCollection(String parent, String collectionName) throws ClusterException {
        if (excludedCollection.contains(parent) || excludedCollection.contains(parent + "/" + collectionName)) {
            return;
        }
        this.remoteInvocation(new CreateCollectionClusterEvent(parent, collectionName));
    }

    public void update(String resource, String name, String xupdate) throws ClusterException {
        if (excludedCollection.contains(resource)) {
            return;
        }
        this.remoteInvocation(new UpdateClusterEvent(resource, name, xupdate));
    }

    public void removeCollection(String parent, String collection) throws ClusterException {
        if (excludedCollection.contains(collection) || excludedCollection.contains(parent + "/" + collection)) {
            return;
        }
        this.remoteInvocation(new RemoveCollectionClusterEvent(parent, collection));
    }

    private void remoteInvocation(ClusterEvent event) throws ClusterException {
        String code = "" + event.hashCode();
        if (!ClusterChannel.hasToBePublished(code)) {
            ClusterChannel.removeEvent(code);
            return;
        }
        int[] data = this.getId(true);
        event.setId(data[0]);
        event.setCounter(data[1]);
        this.journalManager.enqueEvent(event);
        disp.callRemoteMethods(this.membersNoSender, "invoke", new Object[]{event}, new Class[]{ClusterEvent.class}, 6, 0L);
        if (!this.coordinator) {
            this.journalIdGenerator.increaseId(event.getId(), event.getCounter());
        }
    }

    private int[] getId(boolean firstRequest) throws ClusterException {
        try {
            int[] id;
            if (this.coordinator) {
                log.info((Object)"GENERATING LOCAL ID...");
                id = this.journalIdGenerator.getNextData(this.localAddress.toString());
            } else {
                log.info((Object)("RETRIEVING ID FROM " + this.coordinatorAddress));
                Object idObj = disp.callRemoteMethod(this.coordinatorAddress, "getNextDataRemote", new Object[]{this.localAddress.toString()}, new Class[]{String.class}, 1, 0L);
                id = (int[])idObj;
            }
            return id;
        }
        catch (SuspectedException se) {
            if (!firstRequest) {
                throw new ClusterException("unable to retrieve the journal id... master down ... no more retry ", se);
            }
            log.info((Object)"SUSPECTED MASTER SHUTDOWN .... RETRY...");
            try {
                log.info((Object)"WAITING FOR NEW MASTER");
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return this.getId(false);
        }
        catch (Exception e) {
            throw new ClusterException("unable to retrieve the journal id ", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void realign() throws ClusterException {
        if (this.coordinator) {
            return;
        }
        int last = -1;
        try {
            ArrayList events = null;
            int[] header = new int[]{this.journalManager.getLastIdSaved(), this.journalManager.getMaxIdSaved(), this.journalManager.getCounter()};
            int[] remoteHeader = (int[])disp.callRemoteMethod(this.coordinatorAddress, "getRemoteHeader", new Object[0], new Class[0], 1, 0L);
            int counterDiff = Math.abs(header[2] - remoteHeader[2]);
            if (counterDiff > 1) {
                this.killNoRealign();
            }
            if (counterDiff == 1 && remoteHeader[1] > header[1]) {
                this.killNoRealign();
            }
            if (counterDiff == 0 && header[1] > remoteHeader[1]) {
                this.killClusterMasterDisaligned();
            }
            while (true) {
                log.info((Object)("Call remote method getNextEvents: " + Thread.currentThread().getName()));
                Object idObj = disp.callRemoteMethod(this.coordinatorAddress, "getNextEvents", new Object[]{header, remoteHeader, new Integer(last)}, new Class[]{array$I == null ? ClusterComunication.class$("[I") : array$I, array$I == null ? ClusterComunication.class$("[I") : array$I, class$java$lang$Integer == null ? ClusterComunication.class$("java.lang.Integer") : class$java$lang$Integer}, 1, 0L);
                events = (ArrayList)idObj;
                if (events == null || events.size() == 0) break;
                last = this.manageEvents(events);
                log.info((Object)("Last id managed : " + last));
            }
            ArrayList arrayList = this.realignQueue;
            synchronized (arrayList) {
                while (this.realignQueue.size() > 0) {
                    ClusterEvent event = (ClusterEvent)this.realignQueue.remove(0);
                    log.info((Object)("Execute the event " + event.getId()));
                    ClusterChannel.accountEvent("" + event.hashCode());
                    if (this.journalManager.isProcessed(event)) {
                        log.info((Object)"Event  processed ..........");
                        continue;
                    }
                    this.manageEvent(event);
                }
            }
            this.isRealign = false;
        }
        catch (Throwable e) {
            e.printStackTrace();
            log.error((Object)"No align done successfully ...");
            throw new ClusterException("No align done successfully ...", e);
        }
    }

    private void killClusterMasterDisaligned() {
        log.fatal((Object)"MASTER DISALIGNED... CLUSTER DATA MAY BE CORRUPTED");
        log.fatal((Object)"PLEASE STOP CLUSTER AND FIX COLLECTION AND JOURNAL DATA");
    }

    private void killNoRealign() throws ClusterException {
        log.fatal((Object)"NODE DISALIGNED... no hot realignement available.... please fix node collection and journal data");
        throw new ClusterException("NODE DISALIGNED");
    }

    private int manageEvents(ArrayList events) throws ClusterException {
        for (int i = 0; i < events.size(); ++i) {
            ClusterEvent event = (ClusterEvent)events.get(i);
            log.info((Object)("Manage event id " + event.getId()));
            if (this.journalManager.isProcessed(event)) {
                log.info((Object)"event already processed .........");
                continue;
            }
            ClusterChannel.accountEvent("" + event.hashCode());
            this.manageEvent(event);
        }
        return ((ClusterEvent)events.get(events.size() - 1)).getId();
    }

    private void manageEvent(ClusterEvent event) throws ClusterException {
        event.execute();
        this.journalManager.enqueEvent(event);
        if (this.coordinator) {
            this.journalIdGenerator.releaseId(event.getId());
        } else {
            this.journalIdGenerator.increaseId(event.getId(), event.getCounter());
        }
    }

    public ArrayList getNextEvents(int[] header, int[] myHeader, Integer start) {
        return this.journalManager.getNextEvents(header, myHeader, start);
    }

    public int[] getNextDataRemote(String address) {
        return this.journalIdGenerator.getNextData(address);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invoke(ClusterEvent event) throws ClusterException {
        String code = "" + event.hashCode();
        ClusterChannel.accountEvent(code);
        ArrayList arrayList = this.realignQueue;
        synchronized (arrayList) {
            if (this.isRealign) {
                this.realignQueue.add(event);
                return;
            }
        }
        this.manageEvent(event);
    }

    public int[] getRemoteHeader() throws ClusterException {
        return new int[]{this.journalManager.getLastIdSaved(), this.journalManager.getMaxIdSaved(), this.journalManager.getCounter()};
    }

    public ConsoleInfo getConsoleProperties() throws ClusterException {
        String port = System.getProperty("jetty.port");
        if (port == null) {
            port = "8080";
        }
        ConsoleInfo info = new ConsoleInfo();
        info.setProperty("port", port);
        return info;
    }

    public void stop() {
        disp.stop();
        channel.disconnect();
        instance = null;
    }
}

