/*
 * Decompiled with CFR 0.152.
 */
package org.exist.collections;

import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;
import org.exist.collections.Collection;
import org.exist.collections.CollectionConfigurationException;
import org.exist.collections.triggers.Trigger;
import org.exist.dom.DocumentImpl;
import org.exist.storage.BrokerPool;
import org.exist.storage.DBBroker;
import org.exist.storage.IndexSpec;
import org.exist.util.DatabaseConfigurationException;
import org.exist.util.XMLReaderObjectFactory;
import org.exist.xmldb.XmldbURI;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CollectionConfiguration {
    public static final String COLLECTION_CONFIG_SUFFIX = ".xconf";
    public static final XmldbURI COLLECTION_CONFIG_SUFFIX_URI = XmldbURI.create(".xconf");
    public static final String DEFAULT_COLLECTION_CONFIG_FILE = "collection.xconf";
    public static final XmldbURI DEFAULT_COLLECTION_CONFIG_FILE_URI = XmldbURI.create("collection.xconf");
    public static final String NAMESPACE = "http://exist-db.org/collection-config/1.0";
    private static final String ROOT_ELEMENT = "collection";
    private static final String TRIGGERS_ELEMENT = "triggers";
    private static final String EVENT_ATTRIBUTE = "event";
    private static final String CLASS_ATTRIBUTE = "class";
    private static final String PARAMETER_ELEMENT = "parameter";
    private static final String PARAM_NAME_ATTRIBUTE = "name";
    private static final String PARAM_VALUE_ATTRIBUTE = "value";
    private static final String INDEX_ELEMENT = "index";
    private static final String PERMISSIONS_ELEMENT = "default-permissions";
    private static final String RESOURCE_PERMISSIONS_ATTR = "resource";
    private static final String COLLECTION_PERMISSIONS_ATTR = "collection";
    private static final String VALIDATION_ELEMENT = "validation";
    private static final String VALIDATION_MODE_ATTR = "mode";
    private static final Logger LOG = Logger.getLogger((Class)CollectionConfiguration.class);
    private TriggerConfig[] triggers = new TriggerConfig[6];
    private IndexSpec indexSpec = null;
    private XmldbURI docName = null;
    private XmldbURI srcCollectionURI;
    private int defCollPermissions;
    private int defResPermissions;
    private int validationMode = -1;

    public CollectionConfiguration(BrokerPool pool) {
        this.defResPermissions = pool.getSecurityManager().getResourceDefaultPerms();
        this.defCollPermissions = pool.getSecurityManager().getCollectionDefaultPerms();
    }

    public static boolean isCollectionConfigDocument(XmldbURI docName) {
        return docName.endsWith(COLLECTION_CONFIG_SUFFIX_URI);
    }

    public static boolean isCollectionConfigDocument(DocumentImpl doc) {
        XmldbURI docName = doc.getURI();
        return CollectionConfiguration.isCollectionConfigDocument(docName);
    }

    protected void read(DBBroker broker, Document doc, boolean checkOnly, XmldbURI srcCollectionURI, XmldbURI docName) throws CollectionConfigurationException {
        Element root;
        if (!checkOnly) {
            this.docName = docName;
            this.srcCollectionURI = srcCollectionURI;
        }
        if ((root = doc.getDocumentElement()) == null) {
            this.throwOrLog("Configuration document can not be parsed", checkOnly);
            return;
        }
        if (!"collection".equals(root.getLocalName())) {
            this.throwOrLog("Expected element 'collection' in configuration document. Got element '" + root.getLocalName() + "'", checkOnly);
            return;
        }
        if (!NAMESPACE.equals(root.getNamespaceURI())) {
            this.throwOrLog("Expected namespace 'http://exist-db.org/collection-config/1.0' for element 'parameter' in configuration document. Got '" + root.getNamespaceURI() + "'", checkOnly);
            return;
        }
        NodeList childNodes = root.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node node = childNodes.item(i);
            if (NAMESPACE.equals(node.getNamespaceURI())) {
                Element elem;
                if (TRIGGERS_ELEMENT.equals(node.getLocalName())) {
                    NodeList triggers = node.getChildNodes();
                    for (int j = 0; j < triggers.getLength(); ++j) {
                        node = triggers.item(j);
                        if (node.getNodeType() != 1) continue;
                        this.createTrigger(broker, (Element)node, checkOnly);
                    }
                    continue;
                }
                if (INDEX_ELEMENT.equals(node.getLocalName())) {
                    elem = (Element)node;
                    try {
                        if (this.indexSpec == null) {
                            this.indexSpec = new IndexSpec(broker, elem);
                            continue;
                        }
                        this.indexSpec.read(broker, elem);
                    }
                    catch (DatabaseConfigurationException e) {
                        if (checkOnly) {
                            throw new CollectionConfigurationException(e.getMessage(), e);
                        }
                        LOG.warn((Object)e.getMessage(), (Throwable)e);
                    }
                    continue;
                }
                if (PERMISSIONS_ELEMENT.equals(node.getLocalName())) {
                    elem = (Element)node;
                    String permsOpt = elem.getAttribute(RESOURCE_PERMISSIONS_ATTR);
                    if (permsOpt != null && permsOpt.length() > 0) {
                        LOG.debug((Object)("RESOURCE: " + permsOpt));
                        try {
                            this.defResPermissions = Integer.parseInt(permsOpt, 8);
                        }
                        catch (NumberFormatException e) {
                            if (checkOnly) {
                                throw new CollectionConfigurationException("Ilegal value for permissions in configuration document : " + e.getMessage(), e);
                            }
                            LOG.warn((Object)("Ilegal value for permissions in configuration document : " + e.getMessage()), (Throwable)e);
                        }
                    }
                    if ((permsOpt = elem.getAttribute("collection")) == null || permsOpt.length() <= 0) continue;
                    LOG.debug((Object)("COLLECTION: " + permsOpt));
                    try {
                        this.defCollPermissions = Integer.parseInt(permsOpt, 8);
                    }
                    catch (NumberFormatException e) {
                        if (checkOnly) {
                            throw new CollectionConfigurationException("Ilegal value for permissions in configuration document : " + e.getMessage(), e);
                        }
                        LOG.warn((Object)("Ilegal value for permissions in configuration document : " + e.getMessage()), (Throwable)e);
                    }
                    continue;
                }
                if (VALIDATION_ELEMENT.equals(node.getLocalName())) {
                    elem = (Element)node;
                    String mode = elem.getAttribute(VALIDATION_MODE_ATTR);
                    if (mode == null) {
                        LOG.debug((Object)("Unable to determine validation mode in " + srcCollectionURI));
                        this.validationMode = -1;
                        continue;
                    }
                    LOG.debug((Object)(srcCollectionURI + " : Validation mode=" + mode));
                    this.validationMode = XMLReaderObjectFactory.convertValidationMode(mode);
                    continue;
                }
                this.throwOrLog("Ignored node '" + node.getLocalName() + "' in configuration document", checkOnly);
                continue;
            }
            if (node.getNodeType() != 1) continue;
            this.throwOrLog("Ignored node '" + node.getLocalName() + "' in namespace '" + node.getNamespaceURI() + "' in configuration document", checkOnly);
        }
    }

    private void throwOrLog(String message, boolean throwExceptions) throws CollectionConfigurationException {
        if (throwExceptions) {
            throw new CollectionConfigurationException(message);
        }
        LOG.warn((Object)message);
    }

    public XmldbURI getDocName() {
        return this.docName;
    }

    protected void setIndexConfiguration(IndexSpec spec) {
        this.indexSpec = spec;
    }

    public XmldbURI getSourceCollectionURI() {
        return this.srcCollectionURI;
    }

    public int getDefCollPermissions() {
        return this.defCollPermissions;
    }

    public int getDefResPermissions() {
        return this.defResPermissions;
    }

    public int getValidationMode() {
        return this.validationMode;
    }

    public IndexSpec getIndexConfiguration() {
        return this.indexSpec;
    }

    public Trigger newTrigger(int eventType, DBBroker broker, Collection collection) throws CollectionConfigurationException {
        TriggerConfig config = this.getTriggerConfiguration(eventType);
        if (config != null) {
            return config.newInstance(broker, collection);
        }
        return null;
    }

    public TriggerConfig getTriggerConfiguration(int eventType) {
        return this.triggers[eventType];
    }

    private void createTrigger(DBBroker broker, Element node, boolean testConfig) throws CollectionConfigurationException {
        String eventAttr = node.getAttribute(EVENT_ATTRIBUTE);
        if (eventAttr == null) {
            this.throwOrLog("'" + node.getNodeName() + "' requires an attribute '" + EVENT_ATTRIBUTE + "'", testConfig);
            return;
        }
        String classAttr = node.getAttribute(CLASS_ATTRIBUTE);
        if (classAttr == null) {
            this.throwOrLog("'" + node.getNodeName() + "' requires an attribute '" + CLASS_ATTRIBUTE + "'", testConfig);
            return;
        }
        TriggerConfig trigger = this.instantiate(broker, node, classAttr, testConfig);
        if (!testConfig) {
            StringTokenizer tok = new StringTokenizer(eventAttr, ", ");
            while (tok.hasMoreTokens()) {
                String event = tok.nextToken();
                LOG.debug((Object)("Registering trigger '" + classAttr + "' for event '" + event + "'"));
                if (event.equalsIgnoreCase("store")) {
                    if (this.triggers[0] != null) {
                        LOG.warn((Object)("Trigger '" + classAttr + "' already registered"));
                    }
                    this.triggers[0] = trigger;
                    continue;
                }
                if (event.equalsIgnoreCase("update")) {
                    if (this.triggers[1] != null) {
                        LOG.warn((Object)("Trigger '" + classAttr + "' already registered"));
                    }
                    this.triggers[1] = trigger;
                    continue;
                }
                if (event.equalsIgnoreCase("remove")) {
                    if (this.triggers[2] != null) {
                        LOG.warn((Object)("Trigger '" + classAttr + "' already registered"));
                    }
                    this.triggers[2] = trigger;
                    continue;
                }
                if (event.equalsIgnoreCase("create-collection")) {
                    if (this.triggers[3] != null) {
                        LOG.warn((Object)("Trigger '" + classAttr + "' already registered"));
                    }
                    this.triggers[3] = trigger;
                    continue;
                }
                if (event.equalsIgnoreCase("rename-collection")) {
                    if (this.triggers[4] != null) {
                        LOG.warn((Object)("Trigger '" + classAttr + "' already registered"));
                    }
                    this.triggers[4] = trigger;
                    continue;
                }
                if (event.equalsIgnoreCase("delete-collection")) {
                    if (this.triggers[5] != null) {
                        LOG.warn((Object)("Trigger '" + classAttr + "' already registered"));
                    }
                    this.triggers[5] = trigger;
                    continue;
                }
                LOG.warn((Object)("Unknown event type '" + event + "' in trigger '" + classAttr + "'"));
            }
        }
    }

    private TriggerConfig instantiate(DBBroker broker, Element node, String classname, boolean testOnly) throws CollectionConfigurationException {
        try {
            Class<?> clazz = Class.forName(classname);
            if (!Trigger.class.isAssignableFrom(clazz)) {
                this.throwOrLog("Trigger's class '" + classname + "' is not assignable from '" + Trigger.class + "'", testOnly);
                return null;
            }
            TriggerConfig triggerConf = new TriggerConfig(clazz);
            NodeList nodes = node.getElementsByTagNameNS(NAMESPACE, PARAMETER_ELEMENT);
            if (nodes.getLength() > 0) {
                HashMap<String, String> parameters = new HashMap<String, String>(nodes.getLength());
                for (int i = 0; i < nodes.getLength(); ++i) {
                    Element param = (Element)nodes.item(i);
                    String name = param.getAttribute(PARAM_NAME_ATTRIBUTE);
                    if (name == null) {
                        this.throwOrLog("Expected attribute 'name' for element 'parameter' in trigger's configuration.", testOnly);
                        continue;
                    }
                    String value = param.getAttribute(PARAM_VALUE_ATTRIBUTE);
                    if (value == null) {
                        this.throwOrLog("Expected attribute 'value' for element 'parameter' in trigger's configuration.", testOnly);
                        continue;
                    }
                    parameters.put(name, value);
                }
                triggerConf.setParameters(parameters);
            }
            return triggerConf;
        }
        catch (ClassNotFoundException e) {
            if (testOnly) {
                throw new CollectionConfigurationException(e.getMessage(), e);
            }
            LOG.warn((Object)("Trigger class not found: " + e.getMessage()), (Throwable)e);
            return null;
        }
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        if (this.indexSpec != null) {
            result.append(this.indexSpec.toString()).append('\n');
        }
        for (int i = 0; i < this.triggers.length; ++i) {
            TriggerConfig trigger = this.triggers[i];
            if (trigger == null) continue;
            switch (i) {
                case 0: {
                    result.append("store document trigger");
                }
                case 1: {
                    result.append("update document trigger");
                }
                case 2: {
                    result.append("remove document trigger");
                }
                case 3: {
                    result.append("create collection trigger");
                }
                case 4: {
                    result.append("rename collection trigger");
                }
                case 5: {
                    result.append("delete collection trigger");
                }
            }
            result.append('\t').append(trigger.toString()).append('\n');
        }
        return result.toString();
    }

    public static class TriggerConfig {
        private Class clazz;
        private Map parameters;

        public TriggerConfig(Class clazz) {
            this.clazz = clazz;
        }

        public Trigger newInstance(DBBroker broker, Collection collection) throws CollectionConfigurationException {
            try {
                Trigger trigger = (Trigger)this.clazz.newInstance();
                trigger.configure(broker, collection, this.parameters);
                return trigger;
            }
            catch (InstantiationException e) {
                throw new CollectionConfigurationException(e.getMessage(), e);
            }
            catch (IllegalAccessException e) {
                throw new CollectionConfigurationException(e.getMessage(), e);
            }
        }

        public Map getParameters() {
            return this.parameters;
        }

        public void setParameters(Map parameters) {
            this.parameters = parameters;
        }

        public Class getTriggerClass() {
            return this.clazz;
        }
    }
}

