/*
 * Decompiled with CFR 0.152.
 */
package org.exist.collections.triggers;

import java.net.URISyntaxException;
import java.util.Map;
import javax.xml.transform.Templates;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TemplatesHandler;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamSource;
import org.exist.collections.Collection;
import org.exist.collections.CollectionConfigurationException;
import org.exist.collections.triggers.FilteringTrigger;
import org.exist.collections.triggers.TriggerException;
import org.exist.dom.DocumentImpl;
import org.exist.security.PermissionDeniedException;
import org.exist.storage.DBBroker;
import org.exist.storage.serializers.Serializer;
import org.exist.storage.txn.Txn;
import org.exist.xmldb.XmldbURI;
import org.xml.sax.SAXException;

public class STXTransformerTrigger
extends FilteringTrigger {
    private Templates template = null;
    private SAXTransformerFactory factory = null;
    private TransformerHandler handler = null;

    public void configure(DBBroker broker, Collection parent, Map parameters) throws CollectionConfigurationException {
        super.configure(broker, parent, parameters);
        String stylesheet = (String)parameters.get("src");
        if (stylesheet == null) {
            throw new CollectionConfigurationException("STXTransformerTrigger requires an attribute 'src'");
        }
        String origProperty = System.getProperty("javax.xml.transform.TransformerFactory");
        System.setProperty("javax.xml.transform.TransformerFactory", "net.sf.joost.trax.TransformerFactoryImpl");
        this.factory = (SAXTransformerFactory)TransformerFactory.newInstance();
        if (origProperty != null) {
            System.setProperty("javax.xml.transform.TransformerFactory", origProperty);
        }
        this.getLogger().debug((Object)("compiling stylesheet " + stylesheet));
        XmldbURI stylesheetUri = null;
        try {
            stylesheetUri = XmldbURI.xmldbUriFor(stylesheet);
        }
        catch (URISyntaxException e) {
            // empty catch block
        }
        if (stylesheetUri == null || stylesheet.indexOf(58) == -1) {
            stylesheetUri = parent.getURI().resolveCollectionPath(stylesheetUri);
            try {
                DocumentImpl doc = (DocumentImpl)broker.getXMLResource(stylesheetUri);
                if (doc == null) {
                    throw new CollectionConfigurationException("stylesheet " + stylesheetUri + " not found in database");
                }
                Serializer serializer = broker.getSerializer();
                TemplatesHandler thandler = this.factory.newTemplatesHandler();
                serializer.setSAXHandlers(thandler, null);
                serializer.toSAX(doc);
                this.template = thandler.getTemplates();
                this.handler = this.factory.newTransformerHandler(this.template);
            }
            catch (TransformerConfigurationException e) {
                throw new CollectionConfigurationException(e.getMessage(), e);
            }
            catch (PermissionDeniedException e) {
                throw new CollectionConfigurationException(e.getMessage(), e);
            }
            catch (SAXException e) {
                throw new CollectionConfigurationException(e.getMessage(), e);
            }
        }
        try {
            this.template = this.factory.newTemplates(new StreamSource(stylesheet));
            this.handler = this.factory.newTransformerHandler(this.template);
        }
        catch (TransformerConfigurationException e) {
            throw new CollectionConfigurationException(e.getMessage(), e);
        }
    }

    public void prepare(int event, DBBroker broker, Txn transaction, XmldbURI documentName, DocumentImpl existingDocument) throws TriggerException {
        SAXResult result = new SAXResult();
        result.setHandler(this.getOutputHandler());
        result.setLexicalHandler(this.getLexicalOutputHandler());
        this.handler.setResult(result);
        this.setOutputHandler(this.handler);
        this.setLexicalOutputHandler(this.handler);
    }
}

