/*
 * Decompiled with CFR 0.152.
 */
package org.exist.collections.triggers;

import org.exist.collections.triggers.DocumentTrigger;
import org.exist.storage.txn.Txn;
import org.exist.xmldb.XmldbURI;

public class TriggerStatePerThread {
    public static final int NO_TRIGGER_RUNNING = 0;
    public static final int TRIGGER_RUNNING_PREPARE = 1;
    public static final int TRIGGER_RUNNING_FINISH = 2;
    private static ThreadLocal triggerRunningState = new ThreadLocal(){

        protected synchronized Object initialValue() {
            return new TriggerState(0);
        }
    };

    public static boolean verifyUniqueTriggerPerThreadBeforePrepare(DocumentTrigger trigger, XmldbURI modifiedDocument) {
        if (TriggerStatePerThread.getTriggerRunningState() == 0) {
            TriggerStatePerThread.setTriggerRunningState(1, trigger, modifiedDocument);
            return true;
        }
        return false;
    }

    public static boolean verifyUniqueTriggerPerThreadBeforeFinish(DocumentTrigger trigger, XmldbURI modifiedDocument) {
        DocumentTrigger runningTrigger = TriggerStatePerThread.getRunningTrigger();
        if (runningTrigger != null && trigger != runningTrigger) {
            return false;
        }
        if (TriggerStatePerThread.getModifiedDocument() != null && !modifiedDocument.equals(TriggerStatePerThread.getModifiedDocument())) {
            return false;
        }
        if (TriggerStatePerThread.getTriggerRunningState() == 1) {
            TriggerStatePerThread.setTriggerRunningState(2, trigger, modifiedDocument);
            return true;
        }
        return false;
    }

    public static int getTriggerRunningState() {
        return ((TriggerState)TriggerStatePerThread.triggerRunningState.get()).getState();
    }

    public static DocumentTrigger getRunningTrigger() {
        return ((TriggerState)triggerRunningState.get()).getTrigger();
    }

    public static void setTriggerRunningState(int state, DocumentTrigger trigger, XmldbURI modifiedDocument) {
        ((TriggerState)TriggerStatePerThread.triggerRunningState.get()).setState(state, trigger, modifiedDocument);
    }

    public static Txn getTransaction() {
        return ((TriggerState)triggerRunningState.get()).getTransaction();
    }

    public static void setTransaction(Txn transaction) {
        ((TriggerState)triggerRunningState.get()).setTransaction(transaction);
    }

    public static XmldbURI getModifiedDocument() {
        return ((TriggerState)TriggerStatePerThread.triggerRunningState.get()).getModifiedDocument();
    }

    public static class TriggerState {
        private int state;
        private DocumentTrigger currentTrigger;
        private Txn transaction;
        private XmldbURI modifiedDocument;

        public TriggerState(int state) {
            this.setState(state, null, null);
        }

        private void setState(int state, DocumentTrigger trigger, XmldbURI modifiedDocument) {
            this.state = state;
            if (state == 0) {
                this.currentTrigger = null;
                this.setModifiedDocument(null);
            } else {
                this.currentTrigger = trigger;
                this.setModifiedDocument(modifiedDocument);
            }
        }

        private int getState() {
            return this.state;
        }

        void setTransaction(Txn transaction) {
            this.transaction = transaction;
        }

        Txn getTransaction() {
            return this.transaction;
        }

        public DocumentTrigger getTrigger() {
            return this.currentTrigger;
        }

        private void setModifiedDocument(XmldbURI modifiedDocument) {
            this.modifiedDocument = modifiedDocument;
        }

        private XmldbURI getModifiedDocument() {
            return this.modifiedDocument;
        }
    }
}

