/*
 * Decompiled with CFR 0.152.
 */
package org.exist.dom;

import java.io.EOFException;
import java.io.IOException;
import org.exist.EXistException;
import org.exist.collections.Collection;
import org.exist.dom.AttrImpl;
import org.exist.dom.DocumentMetadata;
import org.exist.dom.DocumentSet;
import org.exist.dom.ElementImpl;
import org.exist.dom.NodeImpl;
import org.exist.dom.NodeListImpl;
import org.exist.dom.NodeProxy;
import org.exist.dom.NodeSet;
import org.exist.dom.QName;
import org.exist.dom.StoredDOMImplementation;
import org.exist.dom.StoredNode;
import org.exist.dom.TextImpl;
import org.exist.numbering.NodeId;
import org.exist.security.Group;
import org.exist.security.Permission;
import org.exist.security.PermissionFactory;
import org.exist.security.SecurityManager;
import org.exist.security.User;
import org.exist.storage.BrokerPool;
import org.exist.storage.DBBroker;
import org.exist.storage.NodePath;
import org.exist.storage.StorageAddress;
import org.exist.storage.io.VariableByteInput;
import org.exist.storage.io.VariableByteOutputStream;
import org.exist.storage.lock.Lock;
import org.exist.storage.lock.MultiReadReentrantLock;
import org.exist.storage.txn.Txn;
import org.exist.util.SyntaxException;
import org.exist.xmldb.XmldbURI;
import org.exist.xquery.DescendantSelector;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMConfiguration;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.w3c.dom.UserDataHandler;

public class DocumentImpl
extends NodeImpl
implements Document,
Comparable {
    public static final int UNKNOWN_DOCUMENT_ID = -1;
    public static final byte XML_FILE = 0;
    public static final byte BINARY_FILE = 1;
    public static int LENGTH_DOCUMENT_ID = 4;
    public static int LENGTH_DOCUMENT_TYPE = 1;
    protected BrokerPool pool = null;
    private int children = 0;
    private long[] childAddress = null;
    private transient Collection collection = null;
    private int docId = -1;
    private XmldbURI fileURI = null;
    protected Permission permissions = PermissionFactory.getPermission(493);
    private transient Lock updateLock = null;
    private DocumentMetadata metadata = null;

    public DocumentImpl(BrokerPool pool) {
        this(pool, null, null);
    }

    public DocumentImpl(BrokerPool pool, Collection collection) {
        this(pool, collection, null);
    }

    public DocumentImpl(BrokerPool pool, XmldbURI fileURI) {
        this(pool, null, fileURI);
    }

    public DocumentImpl(BrokerPool pool, Collection collection, XmldbURI fileURI) {
        this.pool = pool;
        this.collection = collection;
        this.fileURI = fileURI;
    }

    protected BrokerPool getBrokerPool() {
        return this.pool;
    }

    public String getLocalName() {
        return "";
    }

    public String getNamespaceURI() {
        return "";
    }

    public Collection getCollection() {
        return this.collection;
    }

    public void setCollection(Collection parent) {
        this.collection = parent;
    }

    public int getDocId() {
        return this.docId;
    }

    public void setDocId(int docId) {
        this.docId = docId;
    }

    public byte getResourceType() {
        return 0;
    }

    public XmldbURI getFileURI() {
        return this.fileURI;
    }

    public void setFileURI(XmldbURI fileURI) {
        this.fileURI = fileURI;
    }

    public XmldbURI getURI() {
        return this.collection.getURI().append(this.fileURI);
    }

    public Permission getPermissions() {
        return this.permissions;
    }

    public void setPermissions(int mode) {
        this.permissions.setPermissions(mode);
    }

    public void setPermissions(String mode) throws SyntaxException {
        this.permissions.setPermissions(mode);
    }

    public void setPermissions(Permission perm) {
        this.permissions = perm;
    }

    public void setMetadata(DocumentMetadata meta) {
        this.metadata = meta;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DocumentMetadata getMetadata() {
        if (this.metadata == null) {
            DBBroker broker = null;
            try {
                broker = this.pool.get(null);
                broker.getResourceMetadata(this);
            }
            catch (EXistException e) {
                LOG.warn((Object)("Error while loading document metadata: " + e.getMessage()), (Throwable)e);
            }
            finally {
                this.pool.release(broker);
            }
        }
        return this.metadata;
    }

    public void copyOf(DocumentImpl other) {
        this.childAddress = null;
        this.children = 0;
        if (this.metadata == null) {
            this.metadata = new DocumentMetadata();
        }
        this.metadata.setLastModified(other.getMetadata().getLastModified());
        this.metadata.setPageCount(0);
    }

    public void copyChildren(DocumentImpl other) {
        this.childAddress = other.childAddress;
        this.children = other.children;
    }

    public synchronized boolean isLockedForWrite() {
        return this.getUpdateLock().isLockedForWrite();
    }

    public final synchronized Lock getUpdateLock() {
        if (this.updateLock == null) {
            this.updateLock = new MultiReadReentrantLock(this.fileURI);
        }
        return this.updateLock;
    }

    public void setUserLock(User user) {
        this.getMetadata().setUserLock(user == null ? 0 : user.getUID());
    }

    public User getUserLock() {
        int lockOwnerId = this.getMetadata().getUserLock();
        if (lockOwnerId == 0) {
            return null;
        }
        SecurityManager secman = this.pool.getSecurityManager();
        return secman.getUser(lockOwnerId);
    }

    public int getContentLength() {
        int length = this.getMetadata().getPageCount() * this.pool.getPageSize();
        return length < 0 ? 0 : length;
    }

    public void triggerDefrag() {
        int fragmentationLimit = -1;
        Object property = this.pool.getConfiguration().getProperty("xupdate.fragmentation");
        if (property != null) {
            fragmentationLimit = (Integer)property;
        }
        if (fragmentationLimit != -1) {
            this.getMetadata().setSplitCount(fragmentationLimit);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Node getNode(NodeId nodeId) {
        if (nodeId.getTreeLevel() == 1) {
            return this.getDocumentElement();
        }
        DBBroker broker = null;
        try {
            broker = this.pool.get(null);
            StoredNode storedNode = broker.objectWith(this, nodeId);
            return storedNode;
        }
        catch (EXistException e) {
            LOG.warn((Object)("Error occured while retrieving node: " + e.getMessage()), (Throwable)e);
        }
        finally {
            this.pool.release(broker);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Node getNode(NodeProxy p) {
        if (p.getNodeId().getTreeLevel() == 1) {
            return this.getDocumentElement();
        }
        DBBroker broker = null;
        try {
            broker = this.pool.get(null);
            StoredNode storedNode = broker.objectWith(p);
            return storedNode;
        }
        catch (Exception e) {
            LOG.warn((Object)("Error occured while retrieving node: " + e.getMessage()), (Throwable)e);
        }
        finally {
            this.pool.release(broker);
        }
        return null;
    }

    private void resizeChildList() {
        long[] newChildList = new long[this.children];
        if (this.childAddress != null) {
            System.arraycopy(this.childAddress, 0, newChildList, 0, this.childAddress.length);
        }
        this.childAddress = newChildList;
    }

    public void appendChild(StoredNode child) throws DOMException {
        ++this.children;
        this.resizeChildList();
        this.childAddress[this.children - 1] = child.getInternalAddress();
    }

    public void write(VariableByteOutputStream ostream) throws IOException {
        try {
            if (!this.getCollection().isTempCollection() && !this.getUpdateLock().isLockedForWrite()) {
                LOG.warn((Object)"document not locked for write !");
            }
            ostream.writeInt(this.docId);
            ostream.writeUTF(this.fileURI.toString());
            SecurityManager secman = this.pool.getSecurityManager();
            if (secman == null) {
                ostream.writeInt(1);
                ostream.writeInt(1);
            } else {
                User user = secman.getUser(this.permissions.getOwner());
                Group group = secman.getGroup(this.permissions.getOwnerGroup());
                if (group == null) {
                    group = secman.getGroup("guest");
                }
                ostream.writeInt(user.getUID());
                ostream.writeInt(group.getId());
            }
            ostream.writeInt(this.permissions.getPermissions());
            ostream.writeInt(this.children);
            if (this.children > 0) {
                for (int i = 0; i < this.children; ++i) {
                    ostream.writeInt(StorageAddress.pageFromPointer(this.childAddress[i]));
                    ostream.writeShort(StorageAddress.tidFromPointer(this.childAddress[i]));
                }
            }
            this.getMetadata().write(this.pool, ostream);
        }
        catch (IOException e) {
            LOG.warn((Object)"io error while writing document data", (Throwable)e);
        }
    }

    public void read(VariableByteInput istream) throws IOException, EOFException {
        try {
            this.docId = istream.readInt();
            this.fileURI = XmldbURI.createInternal(istream.readUTF());
            SecurityManager secman = this.pool.getSecurityManager();
            int uid = istream.readInt();
            int gid = istream.readInt();
            int perm = istream.readInt() & 0x1FF;
            if (secman == null) {
                this.permissions.setOwner("admin");
                this.permissions.setGroup("dba");
            } else {
                this.permissions.setOwner(secman.getUser(uid));
                Group group = secman.getGroup(gid);
                if (group != null) {
                    this.permissions.setGroup(group.getName());
                }
            }
            this.permissions.setPermissions(perm);
            this.children = istream.readInt();
            this.childAddress = new long[this.children];
            for (int i = 0; i < this.children; ++i) {
                this.childAddress[i] = StorageAddress.createPointer(istream.readInt(), istream.readShort());
            }
        }
        catch (IOException e) {
            LOG.error((Object)("IO error while reading document data for document " + this.fileURI), (Throwable)e);
        }
    }

    public void readDocumentMeta(VariableByteInput istream) {
        try {
            istream.skip(1);
            istream.readUTF();
            istream.skip(4);
            istream.skip(this.children * 2);
            this.metadata = new DocumentMetadata();
            this.metadata.read(this.pool, istream);
        }
        catch (IOException e) {
            LOG.error((Object)("IO error while reading document metadata for " + this.fileURI), (Throwable)e);
        }
    }

    public final int compareTo(Object other) {
        long otherId = ((DocumentImpl)other).docId;
        if (otherId == (long)this.docId) {
            return 0;
        }
        if ((long)this.docId < otherId) {
            return -1;
        }
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StoredNode updateChild(Txn transaction, Node oldChild, Node newChild) throws DOMException {
        if (!(oldChild instanceof StoredNode)) {
            throw new DOMException(4, "Node does not belong to this document");
        }
        StoredNode oldNode = (StoredNode)oldChild;
        StoredNode newNode = (StoredNode)newChild;
        StoredNode previousNode = (StoredNode)oldNode.getPreviousSibling();
        if (previousNode == null) {
            throw new DOMException(8, "No previous sibling for the old child");
        }
        DBBroker broker = null;
        try {
            broker = this.pool.get(null);
            if (oldChild.getNodeType() == 1) {
                if (newChild.getNodeType() != 1) {
                    throw new DOMException(13, "A node replacing the document root needs to be an element");
                }
                broker.removeNode(transaction, oldNode, oldNode.getPath(), null);
                broker.endRemove(transaction);
                newNode.setNodeId(oldNode.getNodeId());
                broker.insertNodeAfter(null, previousNode, newNode);
                NodePath path = newNode.getPath();
                broker.indexNode(transaction, newNode, path);
                broker.endElement(newNode, path, null);
                broker.flush();
            } else {
                broker.removeNode(transaction, oldNode, oldNode.getPath(), null);
                broker.endRemove(transaction);
                newNode.setNodeId(oldNode.getNodeId());
                broker.insertNodeAfter(transaction, previousNode, newNode);
            }
        }
        catch (EXistException e) {
            LOG.warn((Object)("Exception while updating child node: " + e.getMessage()), (Throwable)e);
        }
        finally {
            this.pool.release(broker);
        }
        return newNode;
    }

    public void insertBefore(NodeList nodes, Node refChild) throws DOMException {
        throw new DOMException(9, "not implemented");
    }

    public void insertAfter(NodeList nodes, Node refChild) throws DOMException {
        throw new DOMException(9, "not implemented");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Node getFirstChild() {
        if (this.children == 0) {
            return null;
        }
        DBBroker broker = null;
        try {
            broker = this.pool.get(null);
            StoredNode storedNode = broker.objectWith(new NodeProxy(this, NodeId.DOCUMENT_NODE, this.childAddress[0]));
            return storedNode;
        }
        catch (EXistException e) {
            LOG.warn((Object)("Exception while inserting node: " + e.getMessage()), (Throwable)e);
        }
        finally {
            this.pool.release(broker);
        }
        return null;
    }

    public NodeProxy getFirstChildProxy() {
        return new NodeProxy(this, NodeId.ROOT_NODE, 1, this.childAddress[0]);
    }

    public long getFirstChildAddress() {
        if (this.children == 0) {
            return -1L;
        }
        return this.childAddress[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NodeList getChildNodes() {
        NodeListImpl list = new NodeListImpl();
        DBBroker broker = null;
        try {
            broker = this.pool.get(null);
            for (int i = 0; i < this.children; ++i) {
                StoredNode child = broker.objectWith(new NodeProxy(this, NodeId.DOCUMENT_NODE, this.childAddress[i]));
                list.add(child);
            }
        }
        catch (EXistException e) {
            LOG.warn((Object)("Exception while retrieving child nodes: " + e.getMessage()), (Throwable)e);
        }
        finally {
            this.pool.release(broker);
        }
        return list;
    }

    protected Node getPreviousSibling(StoredNode node) {
        NodeList cl = this.getChildNodes();
        for (int i = 0; i < cl.getLength(); ++i) {
            StoredNode next = (StoredNode)cl.item(i);
            if (!StorageAddress.equals(node.getInternalAddress(), next.getInternalAddress())) continue;
            return i == 0 ? null : cl.item(i - 1);
        }
        return null;
    }

    protected Node getFollowingSibling(StoredNode node) {
        NodeList cl = this.getChildNodes();
        for (int i = 0; i < cl.getLength(); ++i) {
            StoredNode next = (StoredNode)cl.item(i);
            if (!StorageAddress.equals(node.getInternalAddress(), next.getInternalAddress())) continue;
            return i == this.children - 1 ? null : cl.item(i + 1);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected NodeList findElementsByTagName(StoredNode root, QName qname) {
        DBBroker broker = null;
        try {
            broker = this.pool.get(null);
            DocumentSet docs = new DocumentSet();
            docs.add(this);
            NodeProxy p = new NodeProxy(this, root.getNodeId(), root.getInternalAddress());
            DescendantSelector selector = new DescendantSelector(p, -1);
            NodeSet nodeSet = broker.getElementIndex().findElementsByTagName((byte)0, docs, qname, selector);
            return nodeSet;
        }
        catch (Exception e) {
            LOG.warn((Object)("Exception while finding elements: " + e.getMessage()), (Throwable)e);
        }
        finally {
            this.pool.release(broker);
        }
        return NodeSet.EMPTY_SET;
    }

    public DocumentType getDoctype() {
        return this.getMetadata().getDocType();
    }

    public void setDocumentType(DocumentType docType) {
        this.getMetadata().setDocType(docType);
    }

    public Document getOwnerDocument() {
        return this;
    }

    public void setOwnerDocument(Document doc) {
        if (doc != this) {
            throw new IllegalArgumentException("Can't set owner document");
        }
    }

    public QName getQName() {
        return QName.DOCUMENT_QNAME;
    }

    public short getNodeType() {
        return 9;
    }

    public Node getPreviousSibling() {
        return null;
    }

    public Node getNextSibling() {
        return null;
    }

    public Attr createAttribute(String name) throws DOMException {
        AttrImpl attr = new AttrImpl(new QName(name, "", null));
        attr.setOwnerDocument(this);
        return attr;
    }

    public Attr createAttributeNS(String namespaceURI, String qualifiedName) throws DOMException {
        String name;
        String prefix;
        int p = qualifiedName.indexOf(58);
        if (p == -1) {
            prefix = null;
            name = qualifiedName;
        } else {
            prefix = qualifiedName.substring(0, p);
            name = qualifiedName.substring(p);
        }
        AttrImpl attr = new AttrImpl(new QName(name, namespaceURI, prefix));
        attr.setOwnerDocument(this);
        return attr;
    }

    public Element createElement(String tagName) throws DOMException {
        ElementImpl element = new ElementImpl(new QName(tagName, "", null));
        element.setOwnerDocument(this);
        return element;
    }

    public Element createElementNS(String namespaceURI, String qualifiedName) throws DOMException {
        String name;
        String prefix;
        int p = qualifiedName.indexOf(58);
        if (p == -1) {
            prefix = null;
            name = qualifiedName;
        } else {
            prefix = qualifiedName.substring(0, p);
            name = qualifiedName.substring(p);
        }
        ElementImpl element = new ElementImpl(new QName(name, namespaceURI, prefix));
        element.setOwnerDocument(this);
        return element;
    }

    public Text createTextNode(String data) {
        TextImpl text = new TextImpl(data);
        text.setOwnerDocument(this);
        return text;
    }

    public Element getDocumentElement() {
        NodeList cl = this.getChildNodes();
        for (int i = 0; i < cl.getLength(); ++i) {
            if (cl.item(i).getNodeType() != 1) continue;
            return (Element)cl.item(i);
        }
        return null;
    }

    public NodeList getElementsByTagName(String tagname) {
        return this.getElementsByTagNameNS("", tagname);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NodeList getElementsByTagNameNS(String namespaceURI, String localName) {
        DBBroker broker = null;
        try {
            broker = this.pool.get(null);
            DocumentSet docs = new DocumentSet();
            docs.add(this);
            QName qname = new QName(localName, namespaceURI, null);
            NodeSet nodeSet = broker.getElementIndex().findElementsByTagName((byte)0, docs, qname, null);
            return nodeSet;
        }
        catch (Exception e) {
            LOG.warn((Object)("Exception while finding elements: " + e.getMessage()), (Throwable)e);
        }
        finally {
            this.pool.release(broker);
        }
        return NodeSet.EMPTY_SET;
    }

    public Node getParentNode() {
        return null;
    }

    public int getChildCount() {
        return this.children;
    }

    public void setChildCount(int count) {
        this.children = count;
        if (this.children == 0) {
            this.childAddress = null;
        }
    }

    public String getEncoding() {
        return "UTF-8";
    }

    public void setEncoding(String enc) {
        throw new DOMException(9, "setEncoding not implemented on class " + this.getClass().getName());
    }

    public String getVersion() {
        throw new DOMException(9, "getVersion not implemented on class " + this.getClass().getName());
    }

    public void setVersion(String version) {
        throw new DOMException(9, "setVersion not implemented on class " + this.getClass().getName());
    }

    public boolean getStandalone() {
        throw new DOMException(9, "getStandalone not implemented on class " + this.getClass().getName());
    }

    public void setStandalone(boolean alone) {
        throw new DOMException(9, "setStandalone not implemented on class " + this.getClass().getName());
    }

    public CDATASection createCDATASection(String data) throws DOMException {
        throw new DOMException(9, "createCDATASection not implemented on class " + this.getClass().getName());
    }

    public Comment createComment(String data) {
        throw new DOMException(9, "createComment not implemented on class " + this.getClass().getName());
    }

    public DocumentFragment createDocumentFragment() throws DOMException {
        throw new DOMException(9, "createDocumentFragment not implemented on class " + this.getClass().getName());
    }

    public EntityReference createEntityReference(String name) throws DOMException {
        throw new DOMException(9, "createEntityReference not implemented on class " + this.getClass().getName());
    }

    public ProcessingInstruction createProcessingInstruction(String target, String data) throws DOMException {
        throw new DOMException(9, "createProcessingInstruction not implemented on class " + this.getClass().getName());
    }

    public Element getElementById(String elementId) {
        throw new DOMException(9, "getElementById not implemented on class " + this.getClass().getName());
    }

    public DOMImplementation getImplementation() {
        return new StoredDOMImplementation();
    }

    public boolean getStrictErrorChecking() {
        throw new DOMException(9, "getStrictErrorChecking not implemented on class " + this.getClass().getName());
    }

    public Node adoptNode(Node node) throws DOMException {
        throw new DOMException(9, "adoptNode not implemented on class " + this.getClass().getName());
    }

    public Node importNode(Node importedNode, boolean deep) throws DOMException {
        throw new DOMException(9, "importNode not implemented on class " + this.getClass().getName());
    }

    public boolean isSupported(String type, String value) {
        throw new DOMException(9, "isSupported not implemented on class " + this.getClass().getName());
    }

    public void setStrictErrorChecking(boolean strict) {
        throw new DOMException(9, "setStrictErrorChecking not implemented on class " + this.getClass().getName());
    }

    public String getInputEncoding() {
        throw new DOMException(9, "String getInputEncoding not implemented on class " + this.getClass().getName());
    }

    public String getXmlEncoding() {
        throw new DOMException(9, "getXmlEncoding not implemented on class " + this.getClass().getName());
    }

    public boolean getXmlStandalone() {
        throw new DOMException(9, "getXmlStandalone not implemented on class " + this.getClass().getName());
    }

    public void setXmlStandalone(boolean xmlStandalone) throws DOMException {
        throw new DOMException(9, "setXmlStandalone not implemented on class " + this.getClass().getName());
    }

    public String getXmlVersion() {
        throw new DOMException(9, "getXmlVersion not implemented on class " + this.getClass().getName());
    }

    public void setXmlVersion(String xmlVersion) throws DOMException {
        throw new DOMException(9, "setXmlVersion not implemented on class " + this.getClass().getName());
    }

    public String getDocumentURI() {
        throw new DOMException(9, "getDocumentURI not implemented on class " + this.getClass().getName());
    }

    public void setDocumentURI(String documentURI) {
        throw new DOMException(9, "setDocumentURI not implemented on class " + this.getClass().getName());
    }

    public DOMConfiguration getDomConfig() {
        throw new DOMException(9, "getDomConfig not implemented on class " + this.getClass().getName());
    }

    public void normalizeDocument() {
        throw new DOMException(9, "normalizeDocument not implemented on class " + this.getClass().getName());
    }

    public Node renameNode(Node n, String namespaceURI, String qualifiedName) throws DOMException {
        throw new DOMException(9, "renameNode not implemented on class " + this.getClass().getName());
    }

    public String getBaseURI() {
        try {
            return this.getURI() + "";
        }
        catch (Exception e) {
            System.out.println("dom/DocumentImpl::getBaseURI() 2 exception catched: ");
            return XmldbURI.ROOT_COLLECTION_URI + "";
        }
    }

    public short compareDocumentPosition(Node other) throws DOMException {
        throw new DOMException(9, "compareDocumentPosition not implemented on class " + this.getClass().getName());
    }

    public String getTextContent() throws DOMException {
        throw new DOMException(9, "getTextContent not implemented on class " + this.getClass().getName());
    }

    public void setTextContent(String textContent) throws DOMException {
        throw new DOMException(9, "setTextContent not implemented on class " + this.getClass().getName());
    }

    public boolean isSameNode(Node other) {
        throw new DOMException(9, "isSameNode not implemented on class " + this.getClass().getName());
    }

    public String lookupPrefix(String namespaceURI) {
        throw new DOMException(9, "lookupPrefix(String namespaceURI) not implemented on class " + this.getClass().getName());
    }

    public boolean isDefaultNamespace(String namespaceURI) {
        throw new DOMException(9, "isDefaultNamespace not implemented on class " + this.getClass().getName());
    }

    public String lookupNamespaceURI(String prefix) {
        throw new DOMException(9, "lookupNamespaceURI not implemented on class " + this.getClass().getName());
    }

    public boolean isEqualNode(Node arg) {
        throw new DOMException(9, "isEqualNode not implemented on class " + this.getClass().getName());
    }

    public Object getFeature(String feature, String version) {
        throw new DOMException(9, "getFeature not implemented on class " + this.getClass().getName());
    }

    public Object setUserData(String key, Object data, UserDataHandler handler) {
        throw new DOMException(9, "setUserData not implemented on class " + this.getClass().getName());
    }

    public Object getUserData(String key) {
        throw new DOMException(9, "getUserData not implemented on class " + this.getClass().getName());
    }

    public String toString() {
        return this.getURI() + " - <" + (this.getDocumentElement() != null ? this.getDocumentElement().getNodeName() : null) + ">";
    }
}

