/*
 * Decompiled with CFR 0.152.
 */
package org.exist.dom;

import java.util.ArrayList;
import org.exist.dom.QName;
import org.w3c.dom.DOMException;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class NamedNodeMapImpl
extends ArrayList
implements NamedNodeMap {
    public int getLength() {
        return this.size();
    }

    public Node setNamedItem(Node arg) throws DOMException {
        this.add(arg);
        return arg;
    }

    public Node setNamedItemNS(Node arg) throws DOMException {
        return this.setNamedItem(arg);
    }

    public Node item(int index) {
        if (index < this.size()) {
            return (Node)this.get(index);
        }
        return null;
    }

    public Node getNamedItem(String name) {
        int i = this.indexOf(new QName(name));
        return i < 0 ? null : (Node)this.get(i);
    }

    public Node getNamedItemNS(String namespaceURI, String name) {
        int i = this.indexOf(new QName(name, namespaceURI, null));
        return i < 0 ? null : (Node)this.get(i);
    }

    public Node removeNamedItem(String name) throws DOMException {
        int i = this.indexOf(new QName(name));
        Node node = (Node)this.get(i);
        this.remove(i);
        return node;
    }

    public Node removeNamedItemNS(String namespaceURI, String name) throws DOMException {
        int i = this.indexOf(new QName(name, namespaceURI, null));
        Node node = (Node)this.get(i);
        this.remove(i);
        return node;
    }

    private int indexOf(QName name) {
        for (int i = 0; i < this.size(); ++i) {
            Node temp = (Node)this.get(i);
            if (!temp.getLocalName().equals(name.getLocalName()) || !temp.getNamespaceURI().equals(name.getNamespaceURI())) continue;
            return i;
        }
        return -1;
    }
}

