/*
 * Decompiled with CFR 0.152.
 */
package org.exist.fulltext;

import java.util.Map;
import java.util.Stack;
import org.exist.collections.Collection;
import org.exist.dom.AttrImpl;
import org.exist.dom.DocumentImpl;
import org.exist.dom.DocumentSet;
import org.exist.dom.ElementImpl;
import org.exist.dom.Match;
import org.exist.dom.NodeProxy;
import org.exist.dom.NodeSet;
import org.exist.dom.QName;
import org.exist.dom.StoredNode;
import org.exist.dom.TextImpl;
import org.exist.fulltext.ElementContent;
import org.exist.fulltext.FTIndex;
import org.exist.fulltext.FTMatchListener;
import org.exist.indexing.AbstractStreamListener;
import org.exist.indexing.IndexController;
import org.exist.indexing.IndexWorker;
import org.exist.indexing.MatchListener;
import org.exist.indexing.OrderedValuesIndex;
import org.exist.indexing.QNamedKeysIndex;
import org.exist.indexing.StreamListener;
import org.exist.storage.DBBroker;
import org.exist.storage.FulltextIndexSpec;
import org.exist.storage.IndexSpec;
import org.exist.storage.NativeTextEngine;
import org.exist.storage.NodePath;
import org.exist.storage.TextSearchEngine;
import org.exist.storage.btree.DBException;
import org.exist.storage.txn.Txn;
import org.exist.util.DatabaseConfigurationException;
import org.exist.util.Occurrences;
import org.exist.xquery.XQueryContext;
import org.w3c.dom.NodeList;

public class FTIndexWorker
implements OrderedValuesIndex,
QNamedKeysIndex {
    private NativeTextEngine engine;
    private FTIndex index;
    private DBBroker broker;
    private DocumentImpl document;
    private FulltextIndexSpec config;
    private int mode = -1;
    private FTStreamListener listener = new FTStreamListener();
    private FTMatchListener matchListener = null;

    public FTIndexWorker(FTIndex index, DBBroker broker) throws DatabaseConfigurationException {
        this.index = index;
        this.broker = broker;
        try {
            this.engine = new NativeTextEngine(broker, index.getBFile(), broker.getConfiguration());
        }
        catch (DBException e) {
            throw new DatabaseConfigurationException(e.getMessage(), e);
        }
    }

    public String getIndexId() {
        return FTIndex.ID;
    }

    public String getIndexName() {
        return "ft-index-old";
    }

    public TextSearchEngine getEngine() {
        return this.engine;
    }

    public Object configure(IndexController controller, NodeList configNodes, Map namespaces) throws DatabaseConfigurationException {
        return null;
    }

    public void setDocument(DocumentImpl doc) {
        this.setDocument(doc, -1);
    }

    public void setDocument(DocumentImpl doc, int newMode) {
        this.document = doc;
        this.mode = newMode;
        IndexSpec indexConf = this.document.getCollection().getIndexConfiguration(this.broker);
        if (indexConf != null) {
            this.config = indexConf.getFulltextIndexSpec();
        }
        this.engine.setDocument(this.document);
    }

    public void setMode(int newMode) {
        this.mode = newMode;
    }

    public DocumentImpl getDocument() {
        return this.document;
    }

    public int getMode() {
        return this.mode;
    }

    public StoredNode getReindexRoot(StoredNode node, NodePath path, boolean includeSelf) {
        if (node.getNodeType() == 2) {
            return null;
        }
        IndexSpec indexConf = node.getDocument().getCollection().getIndexConfiguration(this.broker);
        if (indexConf != null) {
            FulltextIndexSpec config = indexConf.getFulltextIndexSpec();
            if (config == null) {
                return null;
            }
            boolean reindexRequired = false;
            int len = node.getNodeType() == 1 && !includeSelf ? path.length() - 1 : path.length();
            for (int i = 0; i < len; ++i) {
                QName qn = path.getComponent(i);
                if (!config.hasQNameIndex(qn)) continue;
                reindexRequired = true;
                break;
            }
            if (reindexRequired) {
                StoredNode topMost = null;
                for (StoredNode currentNode = node; currentNode != null; currentNode = (StoredNode)currentNode.getParentNode()) {
                    if (!config.hasQNameIndex(currentNode.getQName())) continue;
                    topMost = currentNode;
                }
                return topMost;
            }
        }
        return null;
    }

    public StreamListener getListener() {
        return this.listener;
    }

    public MatchListener getMatchListener(DBBroker broker, NodeProxy proxy) {
        boolean needToFilter = false;
        for (Match nextMatch = proxy.getMatches(); nextMatch != null; nextMatch = nextMatch.getNextMatch()) {
            if (nextMatch.getIndexId() != FTIndex.ID) continue;
            needToFilter = true;
            break;
        }
        if (!needToFilter) {
            return null;
        }
        if (this.matchListener == null) {
            this.matchListener = new FTMatchListener(broker, proxy);
        } else {
            this.matchListener.reset(broker, proxy);
        }
        return this.matchListener;
    }

    public void flush() {
        switch (this.mode) {
            case 0: {
                this.engine.flush();
                break;
            }
            case 1: {
                this.engine.dropIndex(this.document);
                break;
            }
            case 2: {
                this.engine.remove();
            }
        }
    }

    public void removeCollection(Collection collection, DBBroker broker) {
        this.engine.dropIndex(collection);
    }

    public boolean checkIndex(DBBroker broker) {
        return false;
    }

    public Occurrences[] scanIndex(XQueryContext context, DocumentSet docs, NodeSet contextSet, Map hints) {
        return new Occurrences[0];
    }

    private class FTStreamListener
    extends AbstractStreamListener {
        private Stack contentStack = new Stack();

        public void startElement(Txn transaction, ElementImpl element, NodePath path) {
            boolean mixedContent;
            if (FTIndexWorker.this.config != null && ((mixedContent = FTIndexWorker.this.config.matchMixedElement(path)) || FTIndexWorker.this.config.hasQNameIndex(element.getQName()))) {
                ElementContent contentBuf = new ElementContent(element.getQName(), mixedContent || FTIndexWorker.this.config.preserveMixedContent(element.getQName()));
                this.contentStack.push(contentBuf);
            }
            super.startElement(transaction, element, path);
        }

        public void endElement(Txn transaction, ElementImpl element, NodePath path) {
            boolean mixedContent;
            if (FTIndexWorker.this.config != null && ((mixedContent = FTIndexWorker.this.config.matchMixedElement(path)) || FTIndexWorker.this.config.hasQNameIndex(element.getQName()))) {
                ElementContent contentBuf = (ElementContent)this.contentStack.pop();
                element.getQName().setNameType((byte)0);
                FTIndexWorker.this.engine.storeText(element, contentBuf, mixedContent ? NativeTextEngine.FOURTH_OPTION : NativeTextEngine.TEXT_BY_QNAME, null, FTIndexWorker.this.mode == 1);
            }
            super.endElement(transaction, element, path);
        }

        public void characters(Txn transaction, TextImpl text, NodePath path) {
            if (FTIndexWorker.this.config == null) {
                FTIndexWorker.this.engine.storeText(text, NativeTextEngine.TOKENIZE, FTIndexWorker.this.config, FTIndexWorker.this.mode == 1);
            } else if (FTIndexWorker.this.config.match(path)) {
                int tokenize = FTIndexWorker.this.config.preserveContent(path) ? NativeTextEngine.DO_NOT_TOKENIZE : NativeTextEngine.TOKENIZE;
                FTIndexWorker.this.engine.storeText(text, tokenize, FTIndexWorker.this.config, FTIndexWorker.this.mode == 1);
            }
            if (!this.contentStack.isEmpty()) {
                for (int i = 0; i < this.contentStack.size(); ++i) {
                    ElementContent next = (ElementContent)this.contentStack.get(i);
                    next.append(text.getXMLString());
                }
            }
            super.characters(transaction, text, path);
        }

        public void attribute(Txn transaction, AttrImpl attrib, NodePath path) {
            path.addComponent(attrib.getQName());
            if (FTIndexWorker.this.config == null || FTIndexWorker.this.config.matchAttribute(path)) {
                FTIndexWorker.this.engine.storeAttribute(attrib, null, NativeTextEngine.ATTRIBUTE_NOT_BY_QNAME, FTIndexWorker.this.config, FTIndexWorker.this.mode == 1);
            }
            if (FTIndexWorker.this.config != null && FTIndexWorker.this.config.hasQNameIndex(attrib.getQName())) {
                FTIndexWorker.this.engine.storeAttribute(attrib, null, NativeTextEngine.ATTRIBUTE_BY_QNAME, FTIndexWorker.this.config, FTIndexWorker.this.mode == 1);
            }
            path.removeLastComponent();
            super.attribute(transaction, attrib, path);
        }

        public IndexWorker getWorker() {
            return FTIndexWorker.this;
        }
    }
}

