/*
 * Decompiled with CFR 0.152.
 */
package org.exist.http.webdav;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Properties;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.exist.EXistException;
import org.exist.http.servlets.Authenticator;
import org.exist.http.servlets.BasicAuthenticator;
import org.exist.http.servlets.DigestAuthenticator;
import org.exist.http.webdav.WebDAVMethod;
import org.exist.http.webdav.WebDAVMethodFactory;
import org.exist.security.User;
import org.exist.storage.BrokerPool;
import org.exist.util.MimeType;
import org.exist.xmldb.XmldbURI;

public class WebDAV {
    public static final String DAV_NS = "DAV:";
    public static final int BASIC_AUTH = 0;
    public static final int DIGEST_AUTH = 1;
    public static final String BINARY_CONTENT = MimeType.BINARY_TYPE.getName();
    public static final String XML_CONTENT = MimeType.XML_TYPE.getName();
    protected String databaseid = "exist";
    public static final Properties OUTPUT_PROPERTIES = new Properties();
    public static final int SC_MULTI_STATUS = 207;
    private static final Logger LOG;
    private WebDAVMethodFactory factory;
    private int defaultAuthMethod;
    private Authenticator digestAuth;
    private Authenticator basicAuth;
    private BrokerPool pool;

    public WebDAV(int authenticationMethod, String id) throws ServletException {
        this(authenticationMethod, id, WebDAVMethodFactory.getInstance());
    }

    public WebDAV(int authenticationMethod, String id, WebDAVMethodFactory factory) throws ServletException {
        this.factory = factory;
        if (id != null && !"".equals(id)) {
            this.databaseid = id;
        }
        try {
            this.pool = BrokerPool.getInstance(this.databaseid);
        }
        catch (EXistException e) {
            throw new ServletException("Error found while initializing database: " + e.getMessage(), (Throwable)e);
        }
        this.defaultAuthMethod = authenticationMethod;
        this.digestAuth = new DigestAuthenticator(this.pool);
        this.basicAuth = new BasicAuthenticator(this.pool);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        User user = this.authenticate(request, response);
        if (user == null) {
            return;
        }
        String path = request.getPathInfo();
        if (path == null || path.length() == 0 || path.equals("/")) {
            response.sendRedirect(request.getRequestURI() + "/db");
            return;
        }
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("method='" + request.getMethod() + "'; path='" + path + "'; user='" + user.getName() + "'; Lock-Token='" + request.getHeader("Lock-Token") + "'; If='" + request.getHeader("If") + "'"));
        }
        long start = System.currentTimeMillis();
        WebDAVMethod method = this.factory.create(request.getMethod(), this.pool);
        if (method == null) {
            response.sendError(405, "Method is not supported: " + request.getMethod());
            return;
        }
        try {
            method.process(user, request, response, XmldbURI.xmldbUriFor(path));
        }
        catch (URISyntaxException e) {
            response.sendError(400, e.getMessage());
        }
        finally {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Completed in " + (System.currentTimeMillis() - start) + " msecs."));
            }
        }
    }

    private User authenticate(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String credentials = request.getHeader("Authorization");
        if (credentials == null) {
            if (this.defaultAuthMethod == 0) {
                this.basicAuth.sendChallenge(request, response);
            } else {
                this.digestAuth.sendChallenge(request, response);
            }
            return null;
        }
        if (credentials.toUpperCase().startsWith("DIGEST")) {
            return this.digestAuth.authenticate(request, response);
        }
        return this.basicAuth.authenticate(request, response);
    }

    static {
        OUTPUT_PROPERTIES.setProperty("indent", "yes");
        OUTPUT_PROPERTIES.setProperty("encoding", "UTF-8");
        OUTPUT_PROPERTIES.setProperty("omit-xml-declaration", "no");
        OUTPUT_PROPERTIES.setProperty("expand-xincludes", "no");
        OUTPUT_PROPERTIES.setProperty("process-xsl-pi", "no");
        LOG = Logger.getLogger((Class)WebDAV.class);
    }
}

