/*
 * Decompiled with CFR 0.152.
 */
package org.exist.http.webdav.methods;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.exist.EXistException;
import org.exist.collections.Collection;
import org.exist.dom.BinaryDocument;
import org.exist.dom.DocumentImpl;
import org.exist.dom.DocumentMetadata;
import org.exist.dom.LockToken;
import org.exist.http.webdav.WebDAV;
import org.exist.http.webdav.methods.AbstractWebDAVMethod;
import org.exist.security.PermissionDeniedException;
import org.exist.security.User;
import org.exist.security.xacml.AccessContext;
import org.exist.source.ClassLoaderSource;
import org.exist.storage.BrokerPool;
import org.exist.storage.DBBroker;
import org.exist.storage.serializers.Serializer;
import org.exist.xmldb.XmldbURI;
import org.exist.xquery.CompiledXQuery;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQuery;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.NodeValue;
import org.exist.xquery.value.Sequence;
import org.xml.sax.SAXException;

public class Get
extends AbstractWebDAVMethod {
    private static final String SERIALIZE_ERROR = "Error while serializing document: ";
    private static final String COLLECTION_XQ = "org/exist/http/webdav/methods/collection.xq";
    private CompiledXQuery compiled = null;

    public Get(BrokerPool pool) {
        super(pool);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(User user, HttpServletRequest request, HttpServletResponse response, XmldbURI path) throws ServletException, IOException {
        block19: {
            DBBroker broker = null;
            DocumentImpl resource = null;
            Collection collection = null;
            try {
                broker = this.pool.get(user);
                resource = broker.getXMLResource(path, 0);
                if (resource == null) {
                    collection = broker.openCollection(path, 0);
                    if (collection == null) {
                        response.sendError(404);
                    } else {
                        this.collectionListing(broker, collection, request, response);
                    }
                    return;
                }
                if (!resource.getPermissions().validate(user, 4)) {
                    response.sendError(403, "Not allowed to read resource");
                    return;
                }
                LockToken token = resource.getMetadata().getLockToken();
                if (token != null && token.isNullResource()) {
                    response.sendError(404, "Document is a Null resource and cannot be retrieved");
                    return;
                }
                DocumentMetadata metadata = resource.getMetadata();
                response.setContentType(metadata.getMimeType());
                response.addDateHeader("Last-Modified", metadata.getLastModified());
                ServletOutputStream os = response.getOutputStream();
                if (resource.getResourceType() == 0) {
                    Serializer serializer = broker.getSerializer();
                    serializer.reset();
                    try {
                        serializer.setProperties(WebDAV.OUTPUT_PROPERTIES);
                        OutputStreamWriter w = new OutputStreamWriter((OutputStream)os, "UTF-8");
                        serializer.serialize(resource, w);
                        ((Writer)w).flush();
                        ((Writer)w).close();
                        break block19;
                    }
                    catch (SAXException e) {
                        LOG.error((Object)e);
                        throw new ServletException(SERIALIZE_ERROR + e.getMessage(), (Throwable)e);
                    }
                }
                broker.readBinaryResource((BinaryDocument)resource, (OutputStream)os);
                os.flush();
            }
            catch (EXistException e) {
                throw new ServletException(SERIALIZE_ERROR + e.getMessage(), (Throwable)e);
            }
            catch (PermissionDeniedException e) {
                LOG.error((Object)e);
                response.sendError(403, "Not allowed to read resource");
                return;
            }
            finally {
                if (resource != null) {
                    resource.getUpdateLock().release(0);
                }
                if (collection != null) {
                    collection.release(0);
                }
                this.pool.release(broker);
            }
        }
    }

    private void collectionListing(DBBroker broker, Collection collection, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        XQuery xquery = broker.getXQueryService();
        try {
            XQueryContext context;
            if (this.compiled == null) {
                context = xquery.newContext(AccessContext.WEBDAV);
            } else {
                this.compiled.reset();
                context = this.compiled.getContext();
            }
            context.declareVariable("collection", collection.getURI().toString());
            context.declareVariable("uri", request.getRequestURI().toString());
            if (this.compiled == null) {
                this.compiled = xquery.compile(context, new ClassLoaderSource(COLLECTION_XQ));
            }
            Sequence result = xquery.execute(this.compiled, null);
            Serializer serializer = broker.getSerializer();
            serializer.reset();
            serializer.setProperties(WebDAV.OUTPUT_PROPERTIES);
            String content = serializer.serialize((NodeValue)result.itemAt(0));
            byte[] contentData = content.getBytes("UTF-8");
            response.setContentType("text/html; charset=UTF-8");
            response.setContentLength(contentData.length);
            response.addDateHeader("Last-Modified", collection.getCreationTime());
            ServletOutputStream os = response.getOutputStream();
            os.write(contentData);
            os.flush();
        }
        catch (XPathException e) {
            LOG.error((Object)"Failed to compile xquery", (Throwable)e);
            throw new ServletException("Failed to compile xquery", (Throwable)e);
        }
        catch (SAXException e) {
            LOG.error((Object)"Failed to serialize query results", (Throwable)e);
            throw new ServletException("Failed to serialize query results", (Throwable)e);
        }
    }
}

