/*
 * Decompiled with CFR 0.152.
 */
package org.exist.http.webdav.methods;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.exist.EXistException;
import org.exist.collections.Collection;
import org.exist.collections.triggers.TriggerException;
import org.exist.dom.DocumentImpl;
import org.exist.http.webdav.methods.AbstractWebDAVMethod;
import org.exist.security.PermissionDeniedException;
import org.exist.security.User;
import org.exist.storage.BrokerPool;
import org.exist.storage.DBBroker;
import org.exist.storage.txn.TransactionManager;
import org.exist.storage.txn.Txn;
import org.exist.util.LockException;
import org.exist.xmldb.XmldbURI;

public class Unlock
extends AbstractWebDAVMethod {
    public Unlock(BrokerPool pool) {
        super(pool);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void process(User user, HttpServletRequest request, HttpServletResponse response, XmldbURI path) throws ServletException, IOException {
        DBBroker broker = null;
        Collection collection = null;
        DocumentImpl resource = null;
        try {
            broker = this.pool.get(user);
            try {
                Txn transaction;
                TransactionManager transact;
                block34: {
                    try {
                        resource = broker.getXMLResource(path, 0);
                    }
                    catch (PermissionDeniedException ex) {
                        response.sendError(403, ex.getMessage());
                        LOG.error((Object)ex);
                        if (resource != null) {
                            resource.getUpdateLock().release(0);
                        }
                        if (collection != null) {
                            collection.release(0);
                        }
                        if (this.pool == null) return;
                        this.pool.release(broker);
                        return;
                    }
                    if (resource == null) {
                        collection = broker.openCollection(path, 0);
                        if (collection != null) {
                            LOG.info((Object)"Lock on collections not supported yet");
                            response.sendError(405, "Lock on collections not supported yet");
                            return;
                        }
                        LOG.info((Object)("No resource or collection found " + path));
                        response.sendError(404, "No resource or collection found " + path);
                        return;
                    }
                    User lock = resource.getUserLock();
                    if (lock == null) {
                        LOG.debug((Object)"No lock found");
                        resource.getMetadata().setLockToken(null);
                        response.sendError(404);
                        return;
                    }
                    LOG.info((Object)"Unlocking resource.");
                    boolean isNullResource = false;
                    if (resource.getMetadata().getLockToken().isNullResource()) {
                        isNullResource = true;
                    }
                    transact = this.pool.getTransactionManager();
                    transaction = transact.beginTransaction();
                    if (isNullResource) {
                        LOG.debug((Object)"Unlock NullResource");
                        try {
                            XmldbURI collUri = path.removeLastSegment();
                            collection = broker.openCollection(collUri, 0);
                            if (resource.getResourceType() == 1) {
                                collection.removeBinaryResource(transaction, broker, resource.getFileURI());
                                break block34;
                            }
                            collection.removeXMLResource(transaction, broker, resource.getFileURI());
                        }
                        catch (LockException ex) {
                            LOG.error((Object)ex);
                        }
                        catch (TriggerException ex) {
                            LOG.error((Object)ex);
                        }
                        catch (PermissionDeniedException ex) {
                            LOG.error((Object)ex);
                        }
                    } else {
                        LOG.debug((Object)"Unlock resource");
                        resource.setUserLock(null);
                        resource.getMetadata().setLockToken(null);
                        broker.storeXMLResource(transaction, resource);
                    }
                }
                transact.commit(transaction);
                LOG.debug((Object)("Sucessfully unlocked '" + path + "'."));
                response.sendError(204, "Unlocked " + path);
                return;
            }
            finally {
                if (resource != null) {
                    resource.getUpdateLock().release(0);
                }
            }
        }
        catch (EXistException e) {
            LOG.error((Object)e);
            response.sendError(500, e.getMessage());
            throw new ServletException((Throwable)e);
        }
        finally {
            if (collection != null) {
                collection.release(0);
            }
            if (this.pool != null) {
                this.pool.release(broker);
            }
        }
    }
}

