/*
 * Decompiled with CFR 0.152.
 */
package org.exist.security;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.apache.log4j.Logger;
import org.exist.security.Group;
import org.exist.security.PermissionDeniedException;
import org.exist.security.SecurityManager;
import org.exist.security.User;
import org.exist.security.xacml.ExistPDP;
import org.exist.storage.BrokerPool;
import org.exist.storage.DBBroker;

public class LDAPSecurityManager
implements SecurityManager {
    private static final Logger LOG = Logger.getLogger((Class)SecurityManager.class);
    protected Map userByNameCache = new HashMap();
    protected Map userByIdCache = new HashMap();
    protected Map groupByNameCache = new HashMap();
    protected Map groupByIdCache = new HashMap();
    protected String contextFactory = LDAPSecurityManager.getProperty("security.ldap.contextFactory", "com.sun.jndi.ldap.LdapCtxFactory");
    protected String connectionURL = LDAPSecurityManager.getProperty("security.ldap.connection.url", null);
    protected String userPasswordAttr = LDAPSecurityManager.getProperty("security.ldap.attr.userPassword", "userPassword");
    protected String userDigestPasswordAttr = LDAPSecurityManager.getProperty("security.ldap.attr.userDigestPassword", "digestPassword");
    protected String uidAttr = LDAPSecurityManager.getProperty("security.ldap.attr.uid", "uid");
    protected String uidNumberAttr = LDAPSecurityManager.getProperty("security.ldap.attr.uidNumber", "uidNumber");
    protected String gidNumberAttr = LDAPSecurityManager.getProperty("security.ldap.attr.gidNumber", "gidNumber");
    protected String groupNameAttr = LDAPSecurityManager.getProperty("security.ldap.attr.groupName", "cn");
    protected String groupMemberName = LDAPSecurityManager.getProperty("security.ldap.attr.groupMemberName", "uniqueMember");
    protected String groupClassName = LDAPSecurityManager.getProperty("security.ldap.groupClass", "posixGroup");
    protected String userClassName = LDAPSecurityManager.getProperty("security.ldap.userClass", "posixAccount");
    protected String userBase = LDAPSecurityManager.getProperty("security.ldap.dn.user", null);
    protected String groupBase = LDAPSecurityManager.getProperty("security.ldap.dn.group", null);
    protected DirContext context = null;
    protected String userByNamePattern = null;
    protected String userByIdPattern = null;
    protected MessageFormat userByNamePatternFormat = null;
    protected MessageFormat userByIdPatternFormat = null;
    protected String groupByIdPattern = null;
    protected String groupByNamePattern = null;
    protected MessageFormat groupByIdPatternFormat = null;
    protected MessageFormat groupByNamePatternFormat = null;
    protected ExistPDP pdp = null;

    static String getProperty(String name, String defaultValue) {
        String value = System.getProperty(name);
        return value == null ? defaultValue : value;
    }

    public LDAPSecurityManager() {
        this.setUserByNamePattern(this.uidAttr + "={0}," + this.userBase);
        this.setUserByIdPattern(this.uidNumberAttr + "={0}," + this.userBase);
        this.setGroupByIdPattern(this.gidNumberAttr + "={0}," + this.groupBase);
        this.setGroupByNamePattern(this.groupNameAttr + "={0}," + this.groupBase);
    }

    public void setUserByNamePattern(String pattern) {
        this.userByNamePattern = pattern;
        this.userByNamePatternFormat = new MessageFormat(this.userByNamePattern);
    }

    public void setUserByIdPattern(String pattern) {
        this.userByIdPattern = pattern;
        this.userByIdPatternFormat = new MessageFormat(this.userByIdPattern);
    }

    public void setGroupByIdPattern(String pattern) {
        this.groupByIdPattern = pattern;
        this.groupByIdPatternFormat = new MessageFormat(this.groupByIdPattern);
    }

    public void setGroupByNamePattern(String pattern) {
        this.groupByNamePattern = pattern;
        this.groupByNamePatternFormat = new MessageFormat(this.groupByNamePattern);
    }

    private String getAttributeValue(String attrId, Attributes attrs) throws NamingException {
        if (attrId == null || attrs == null) {
            return null;
        }
        Attribute attr = attrs.get(attrId);
        if (attr == null) {
            return null;
        }
        Object value = attr.get();
        if (value == null) {
            return null;
        }
        String valueString = null;
        valueString = value instanceof byte[] ? new String((byte[])value) : value.toString();
        return valueString;
    }

    protected Hashtable getDirectoryEnvironment() {
        if (this.connectionURL == null) {
            throw new IllegalStateException("The security.ldap.connection.url property is not set.");
        }
        if (this.userBase == null) {
            throw new IllegalStateException("The security.ldap.dn.user property is not set.");
        }
        if (this.groupBase == null) {
            throw new IllegalStateException("The security.ldap.dn.group property is not set.");
        }
        Hashtable<String, String> env = new Hashtable<String, String>();
        LOG.info((Object)("security.ldap.contextFactory=" + this.contextFactory));
        env.put("java.naming.factory.initial", this.contextFactory);
        LOG.info((Object)("security.ldap.connection.url=" + this.connectionURL));
        env.put("java.naming.provider.url", this.connectionURL);
        return env;
    }

    public void attach(BrokerPool pool, DBBroker sysBroker) {
        try {
            this.context = new InitialDirContext(this.getDirectoryEnvironment());
            Boolean enableXACML = (Boolean)sysBroker.getConfiguration().getProperty("xacml.enable");
            if (enableXACML != null && enableXACML.booleanValue()) {
                this.pdp = new ExistPDP(pool);
                LOG.debug((Object)"XACML enabled");
            }
        }
        catch (NamingException ex) {
            LOG.warn((Object)("Connecting to context failed for LDAP-based security: " + this.connectionURL), (Throwable)ex);
        }
    }

    protected User getUserByName(DirContext context, String username) throws NamingException {
        String dn = this.userByNamePatternFormat.format(new String[]{username});
        LOG.info((Object)("Attempting to get user by: " + dn));
        return this.getUser(context, dn);
    }

    protected User getUserById(DirContext context, int uid) throws NamingException {
        LOG.info((Object)("Searching for " + this.uidNumberAttr + "=" + uid + " in " + this.userBase));
        SearchControls constraints = new SearchControls();
        constraints.setSearchScope(1);
        NamingEnumeration<SearchResult> users = context.search(this.userBase, "(" + this.uidNumberAttr + "=" + uid + ")", constraints);
        if (users.hasMore()) {
            SearchResult result = users.next();
            return this.newUserFromAttributes(context, result.getAttributes());
        }
        return null;
    }

    protected Group getGroupById(DirContext context, int gid) throws NamingException {
        LOG.info((Object)("Searching for " + this.gidNumberAttr + "=" + gid + " in " + this.groupBase));
        SearchControls constraints = new SearchControls();
        constraints.setSearchScope(1);
        NamingEnumeration<SearchResult> groups = context.search(this.groupBase, "(" + this.gidNumberAttr + "=" + gid + ")", constraints);
        if (groups.hasMore()) {
            SearchResult result = groups.next();
            String cn = this.getAttributeValue(this.groupNameAttr, result.getAttributes());
            LOG.info((Object)("Constructing group " + cn));
            return new Group(cn, gid);
        }
        return null;
    }

    protected Group getGroupByName(DirContext context, String name) throws NamingException {
        String g_dn = this.groupByNamePatternFormat.format(new String[]{name});
        LOG.info((Object)("Attempting to get group by: " + g_dn));
        try {
            Attributes attrs = context.getAttributes(g_dn);
            String cn = this.getAttributeValue(this.groupNameAttr, attrs);
            int gid = Integer.parseInt(this.getAttributeValue(this.gidNumberAttr, attrs));
            return new Group(cn, gid);
        }
        catch (NameNotFoundException e) {
            return null;
        }
    }

    protected User newUserFromAttributes(DirContext context, Attributes attrs) throws NamingException {
        String username = this.getAttributeValue(this.uidAttr, attrs);
        String password = this.getAttributeValue(this.userPasswordAttr, attrs);
        String digestPassword = this.getAttributeValue(this.userDigestPasswordAttr, attrs);
        String gid = this.getAttributeValue(this.gidNumberAttr, attrs);
        LOG.info((Object)("Searching for " + this.gidNumberAttr + "=" + gid + " in " + this.groupBase));
        String mainGroup = null;
        SearchControls constraints = new SearchControls();
        constraints.setSearchScope(1);
        NamingEnumeration<SearchResult> groups = context.search(this.groupBase, "(" + this.gidNumberAttr + "=" + gid + ")", constraints);
        while (mainGroup == null && groups.hasMore()) {
            SearchResult result = groups.next();
            mainGroup = this.getAttributeValue(this.groupNameAttr, result.getAttributes());
        }
        if (mainGroup == null || mainGroup.length() == 0) {
            throw new IllegalStateException("Main group " + gid + " for user " + username + " is not able to be found in LDAP for group property " + this.gidNumberAttr);
        }
        int uid = Integer.parseInt(this.getAttributeValue(this.uidNumberAttr, attrs));
        LOG.info((Object)("Constructing user " + username + "/" + uid + " in group " + (mainGroup == null ? "<none>" : mainGroup)));
        User user = new User(username, null, mainGroup);
        user.setUID(uid);
        if (password != null) {
            if (password.charAt(0) == '{') {
                int end = password.indexOf(125);
                String type = password.substring(0, end + 1);
                String value = password.substring(end + 1);
                LOG.info((Object)("  digest: " + type + ", " + value));
                if (!type.equals("{MD5}")) {
                    throw new IllegalStateException("User " + username + " has a non-md5 digested password: " + type);
                }
                user.setEncodedPassword(value);
            } else {
                user.setPassword(password);
            }
        }
        if (digestPassword != null) {
            user.setPasswordDigest(digestPassword);
        }
        LOG.info((Object)"Finding additional groups...");
        String fullName = this.uidAttr + "=" + username + "," + this.userBase;
        groups = context.search(this.groupBase, "(" + this.groupMemberName + "=" + fullName + ")", constraints);
        while (groups.hasMore()) {
            SearchResult result = groups.next();
            String name = this.getAttributeValue(this.groupNameAttr, result.getAttributes());
            if (name == null || name.length() == 0) {
                throw new IllegalStateException("Group associated with " + username + " does not have a valid name for attribute " + this.groupNameAttr);
            }
            if (name.equals(mainGroup)) continue;
            LOG.info((Object)("   ...adding: " + name));
            user.addGroup(name);
        }
        return user;
    }

    protected User getUser(DirContext context, String dn) throws NamingException {
        Attributes attrs = null;
        try {
            attrs = context.getAttributes(dn);
        }
        catch (NameNotFoundException ex) {
            LOG.warn((Object)("Cannot find user " + dn), (Throwable)ex);
            return null;
        }
        if (attrs == null) {
            return null;
        }
        LOG.info((Object)("User " + dn + " found, attempting to find group and construct..."));
        return this.newUserFromAttributes(context, attrs);
    }

    public void addGroup(String name) {
    }

    public void deleteUser(String name) throws PermissionDeniedException {
    }

    public void deleteUser(User user) throws PermissionDeniedException {
    }

    public int getCollectionDefaultPerms() {
        return 493;
    }

    public Group getGroup(int gid) {
        Integer igid = new Integer(gid);
        Group group = (Group)this.groupByIdCache.get(igid);
        if (group == null) {
            try {
                group = this.getGroupById(this.context, gid);
                if (group != null) {
                    this.groupByIdCache.put(igid, group);
                }
            }
            catch (NamingException ex) {
                LOG.warn((Object)("Cannot get group by #" + gid + " due to exception."), (Throwable)ex);
            }
        }
        return group;
    }

    public Group getGroup(String name) {
        Group group = (Group)this.groupByIdCache.get(name);
        if (group == null) {
            try {
                group = this.getGroupByName(this.context, name);
                if (group != null) {
                    this.groupByNameCache.put(name, group);
                }
            }
            catch (NamingException ex) {
                LOG.warn((Object)("Cannot get group " + name + " due to exception."), (Throwable)ex);
            }
        }
        return group;
    }

    public String[] getGroups() {
        try {
            SearchControls constraints = new SearchControls();
            constraints.setSearchScope(1);
            NamingEnumeration<SearchResult> groups = this.context.search(this.groupBase, "(objectClass=" + this.groupClassName + ")", constraints);
            ArrayList<String> groupList = new ArrayList<String>();
            while (groups.hasMore()) {
                SearchResult result = groups.next();
                groupList.add(this.getAttributeValue(this.groupNameAttr, result.getAttributes()));
            }
            String[] retval = new String[groupList.size()];
            System.arraycopy(groupList.toArray(), 0, retval, 0, retval.length);
            return retval;
        }
        catch (NamingException ex) {
            LOG.warn((Object)"Cannot get a list of all groups due to exception.", (Throwable)ex);
            return null;
        }
    }

    public boolean isXACMLEnabled() {
        return this.pdp != null;
    }

    public ExistPDP getPDP() {
        return this.pdp;
    }

    public int getResourceDefaultPerms() {
        return 493;
    }

    public User getUser(int uid) {
        Integer iuid = new Integer(uid);
        User user = (User)this.userByIdCache.get(iuid);
        if (user == null) {
            try {
                user = this.getUserById(this.context, uid);
                if (user != null) {
                    this.userByIdCache.put(iuid, user);
                }
            }
            catch (NamingException ex) {
                LOG.warn((Object)("Cannot get user by #" + uid + " due to exception."), (Throwable)ex);
            }
        }
        return user;
    }

    public User getUser(String name) {
        User user = (User)this.userByNameCache.get(name);
        if (user == null) {
            try {
                user = this.getUserByName(this.context, name);
                if (user != null) {
                    this.userByNameCache.put(name, user);
                }
            }
            catch (NamingException ex) {
                LOG.warn((Object)("Cannot get user " + name + " due to exception."), (Throwable)ex);
            }
        }
        return user;
    }

    public User[] getUsers() {
        try {
            SearchControls constraints = new SearchControls();
            constraints.setSearchScope(1);
            NamingEnumeration<SearchResult> users = this.context.search(this.userBase, "(objectClass=" + this.userClassName + ")", constraints);
            ArrayList<User> userList = new ArrayList<User>();
            while (users.hasMore()) {
                SearchResult result = users.next();
                userList.add(this.newUserFromAttributes(this.context, result.getAttributes()));
            }
            User[] retval = new User[userList.size()];
            System.arraycopy(userList.toArray(), 0, retval, 0, retval.length);
            return retval;
        }
        catch (NamingException ex) {
            LOG.warn((Object)"Cannot get the list of users due to exception.", (Throwable)ex);
            return null;
        }
    }

    public synchronized boolean hasAdminPrivileges(User user) {
        return user.hasDbaRole();
    }

    public synchronized boolean hasUser(String name) {
        try {
            return this.getUserByName(this.context, name) != null;
        }
        catch (NamingException ex) {
            LOG.warn((Object)("Cannot check for user " + name + " due to exception"), (Throwable)ex);
            return false;
        }
    }

    public synchronized boolean hasGroup(String name) {
        try {
            return this.getGroupByName(this.context, name) != null;
        }
        catch (NamingException ex) {
            LOG.warn((Object)("Cannot check for group " + name + " due to exception"), (Throwable)ex);
            return false;
        }
    }

    public void setUser(User user) {
    }
}

