/*
 * Decompiled with CFR 0.152.
 */
package org.exist.security.xacml;

import com.sun.xacml.attr.AnyURIAttribute;
import com.sun.xacml.attr.AttributeValue;
import com.sun.xacml.attr.StringAttribute;
import com.sun.xacml.ctx.Attribute;
import com.sun.xacml.ctx.RequestCtx;
import com.sun.xacml.ctx.Subject;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.exist.dom.QName;
import org.exist.security.User;
import org.exist.security.xacml.AccessContext;
import org.exist.security.xacml.NullAccessContextException;
import org.exist.security.xacml.XACMLConstants;
import org.exist.security.xacml.XACMLSource;
import org.exist.xquery.ExternalModule;
import org.exist.xquery.Module;
import org.exist.xquery.XQueryContext;

public class RequestHelper {
    public RequestCtx createQueryRequest(XQueryContext context, XACMLSource source) {
        Set subjects = this.createQuerySubjects(context.getUser(), null);
        Set resourceAttributes = this.createQueryResource(source);
        Set actionAttributes = this.createBasicAction("execute query");
        Set environmentAttributes = this.createEnvironment(context.getAccessContext());
        return new RequestCtx(subjects, resourceAttributes, actionAttributes, environmentAttributes);
    }

    public RequestCtx createReflectionRequest(XQueryContext context, Module contextModule, String className, String methodName) {
        User user = context.getUser();
        Set subjects = this.createQuerySubjects(user, contextModule);
        Set resourceAttributes = this.createReflectionResource(className, methodName);
        Set actionAttributes = this.createBasicAction("invoke method");
        Set environmentAttributes = this.createEnvironment(context.getAccessContext());
        return new RequestCtx(subjects, resourceAttributes, actionAttributes, environmentAttributes);
    }

    public RequestCtx createFunctionRequest(XQueryContext context, Module contextModule, QName functionName) {
        String namespaceURI = functionName.getNamespaceURI();
        Module functionModule = context.getModule(namespaceURI);
        if (functionModule == null) {
            return null;
        }
        User user = context.getUser();
        Set subjects = this.createQuerySubjects(user, contextModule);
        HashSet resourceAttributes = new HashSet(8);
        RequestHelper.addStringAttribute(resourceAttributes, XACMLConstants.MODULE_CATEGORY_ATTRIBUTE, RequestHelper.getModuleCategory(functionModule));
        XACMLSource moduleSrc = RequestHelper.generateModuleSource(functionModule);
        RequestHelper.addSourceAttributes(resourceAttributes, moduleSrc);
        RequestHelper.addValidURIAttribute(resourceAttributes, XACMLConstants.MODULE_NS_ATTRIBUTE, namespaceURI);
        RequestHelper.addStringAttribute(resourceAttributes, XACMLConstants.RESOURCE_CATEGORY_ATTRIBUTE, "function");
        RequestHelper.addStringAttribute(resourceAttributes, XACMLConstants.RESOURCE_ID_ATTRIBUTE, functionName.getLocalName());
        Set actionAttributes = this.createBasicAction("call function");
        Set environmentAttributes = this.createEnvironment(context.getAccessContext());
        return new RequestCtx(subjects, resourceAttributes, actionAttributes, environmentAttributes);
    }

    public Subject createUserSubject(User user) {
        StringAttribute value = new StringAttribute(user.getName());
        Attribute attr = new Attribute(XACMLConstants.SUBJECT_ID_ATTRIBUTE, null, null, (AttributeValue)value);
        return new Subject(XACMLConstants.ACCESS_SUBJECT, Collections.singleton(attr));
    }

    public Set createBasicAction(String action) {
        if (action == null) {
            return null;
        }
        HashSet attributes = new HashSet(4);
        RequestHelper.addStringAttribute(attributes, XACMLConstants.ACTION_ID_ATTRIBUTE, action);
        RequestHelper.addValidURIAttribute(attributes, XACMLConstants.ACTION_NS_ATTRIBUTE, "http://exist-db.org/xacml/action");
        return attributes;
    }

    public Subject createModuleSubject(Module module) {
        if (module == null) {
            return null;
        }
        HashSet attributes = new HashSet(8);
        RequestHelper.addValidURIAttribute(attributes, XACMLConstants.SUBJECT_NS_ATTRIBUTE, module.getNamespaceURI());
        RequestHelper.addStringAttribute(attributes, XACMLConstants.MODULE_CATEGORY_ATTRIBUTE, RequestHelper.getModuleCategory(module));
        XACMLSource moduleSrc = RequestHelper.generateModuleSource(module);
        RequestHelper.addSourceAttributes(attributes, moduleSrc);
        RequestHelper.addStringAttribute(attributes, XACMLConstants.SUBJECT_ID_ATTRIBUTE, moduleSrc.createId());
        return new Subject(XACMLConstants.CODEBASE_SUBJECT, attributes);
    }

    public Set createReflectionResource(String className, String methodName) {
        if (className == null) {
            throw new NullPointerException("Class name cannot be null");
        }
        if (methodName == null) {
            throw new NullPointerException("Method name cannot be null");
        }
        HashSet resourceAttributes = new HashSet(8);
        RequestHelper.addStringAttribute(resourceAttributes, XACMLConstants.RESOURCE_CATEGORY_ATTRIBUTE, "method");
        XACMLSource source = XACMLSource.getInstance(className);
        RequestHelper.addSourceAttributes(resourceAttributes, source);
        RequestHelper.addStringAttribute(resourceAttributes, XACMLConstants.RESOURCE_ID_ATTRIBUTE, methodName);
        return resourceAttributes;
    }

    public Set createQueryResource(XACMLSource source) {
        if (source == null) {
            throw new NullPointerException("Query source cannot be null");
        }
        HashSet resourceAttributes = new HashSet(4);
        RequestHelper.addSourceAttributes(resourceAttributes, source);
        RequestHelper.addStringAttribute(resourceAttributes, XACMLConstants.RESOURCE_ID_ATTRIBUTE, source.createId());
        RequestHelper.addStringAttribute(resourceAttributes, XACMLConstants.RESOURCE_CATEGORY_ATTRIBUTE, "query");
        return resourceAttributes;
    }

    public Set createQuerySubjects(User user, Module contextModule) {
        if (user == null) {
            throw new NullPointerException("User cannot be null");
        }
        HashSet<Subject> subjects = new HashSet<Subject>(4);
        Subject userSubject = this.createUserSubject(user);
        subjects.add(userSubject);
        if (contextModule != null) {
            Subject moduleSubject = this.createModuleSubject(contextModule);
            subjects.add(moduleSubject);
        }
        return subjects;
    }

    public Set createEnvironment(AccessContext accessCtx) {
        if (accessCtx == null) {
            throw new NullAccessContextException();
        }
        HashSet environment = new HashSet(4);
        RequestHelper.addStringAttribute(environment, XACMLConstants.ACCESS_CONTEXT_ATTRIBUTE, accessCtx.toString());
        return environment;
    }

    public static XACMLSource generateModuleSource(Module module) {
        if (module == null) {
            throw new NullPointerException("Module cannot be null");
        }
        if (module.isInternalModule()) {
            return XACMLSource.getInstance(module.getClass());
        }
        return XACMLSource.getInstance(((ExternalModule)module).getSource());
    }

    public static String getModuleCategory(Module module) {
        if (module == null) {
            return null;
        }
        return module.isInternalModule() ? "internal library" : "external library";
    }

    public static void addSourceAttributes(Set attributes, XACMLSource source) {
        if (source == null) {
            throw new NullPointerException("Source cannot be null");
        }
        RequestHelper.addStringAttribute(attributes, XACMLConstants.SOURCE_KEY_ATTRIBUTE, source.getKey());
        RequestHelper.addStringAttribute(attributes, XACMLConstants.SOURCE_TYPE_ATTRIBUTE, source.getType());
    }

    public static void addStringAttribute(Set attributes, URI attrID, String attrValue) {
        if (attributes == null) {
            return;
        }
        if (attrID == null) {
            throw new NullPointerException("Attribute ID cannot be null");
        }
        if (attrValue == null) {
            throw new NullPointerException("Attribute value cannot be null");
        }
        StringAttribute value = new StringAttribute(attrValue);
        Attribute attr = new Attribute(attrID, null, null, (AttributeValue)value);
        attributes.add(attr);
    }

    public static void addURIAttribute(Set attributes, URI attrID, String uriString) throws URISyntaxException {
        if (attributes == null) {
            return;
        }
        if (attrID == null) {
            throw new NullPointerException("Attribute ID cannot be null");
        }
        if (uriString == null) {
            throw new NullPointerException("Attribute value cannot be null");
        }
        URI uri = new URI(uriString);
        AnyURIAttribute value = new AnyURIAttribute(uri);
        Attribute attr = new Attribute(attrID, null, null, (AttributeValue)value);
        attributes.add(attr);
    }

    private static void addValidURIAttribute(Set attributes, URI attrID, String uriString) {
        try {
            RequestHelper.addURIAttribute(attributes, attrID, uriString);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("URI should never be invalid", e);
        }
    }

    RequestHelper() {
    }
}

