/*
 * Decompiled with CFR 0.152.
 */
package org.exist.security.xacml;

import com.sun.xacml.EvaluationCtx;
import com.sun.xacml.attr.AttributeValue;
import com.sun.xacml.attr.BagAttribute;
import com.sun.xacml.attr.StringAttribute;
import com.sun.xacml.cond.EvaluationResult;
import com.sun.xacml.ctx.Status;
import com.sun.xacml.finder.AttributeFinderModule;
import java.net.URI;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;
import org.exist.security.User;
import org.exist.security.xacml.ExistPDP;
import org.exist.security.xacml.XACMLConstants;

public class UserAttributeModule
extends AttributeFinderModule {
    private static final Logger LOG = Logger.getLogger((Class)UserAttributeModule.class);
    private ExistPDP pdp;

    private UserAttributeModule() {
    }

    public UserAttributeModule(ExistPDP pdp) {
        this.pdp = pdp;
    }

    public EvaluationResult findAttribute(URI attributeType, URI attributeId, URI issuer, URI subjectCategory, EvaluationCtx context, int designatorType) {
        if (designatorType != 0) {
            return UserAttributeModule.errorResult("Invalid designator type: UserAttributeModule only handles subjects");
        }
        if (issuer != null) {
            return UserAttributeModule.errorResult("UserAttributeModule cannot handle requests with an issuer specified.");
        }
        if (!XACMLConstants.ACCESS_SUBJECT.equals(subjectCategory)) {
            return UserAttributeModule.errorResult("UserAttributeModule can only handle subject category '" + XACMLConstants.ACCESS_SUBJECT + "'");
        }
        if (!XACMLConstants.STRING_TYPE.equals(attributeType)) {
            return UserAttributeModule.errorResult("UserAttributeModule can only handle data type '" + XACMLConstants.STRING_TYPE + "'");
        }
        EvaluationResult subjectID = context.getSubjectAttribute(attributeType, XACMLConstants.SUBJECT_ID_ATTRIBUTE, issuer, subjectCategory);
        if (subjectID.indeterminate()) {
            return subjectID;
        }
        AttributeValue value = subjectID.getAttributeValue();
        if (value == null) {
            return UserAttributeModule.errorResult("Could not find user for context: null subject-id");
        }
        if (value.isBag()) {
            BagAttribute bag = (BagAttribute)value;
            if (bag.isEmpty()) {
                return UserAttributeModule.errorResult("Could not find user for context: no subject-id found");
            }
            if (bag.size() > 1) {
                return UserAttributeModule.errorResult("Error finding attribute: Subject-id attribute is not unique.");
            }
            value = (AttributeValue)bag.iterator().next();
        }
        if (!(value instanceof StringAttribute)) {
            return UserAttributeModule.errorResult("Error finding attribute: Subject-id attribute must be a string.");
        }
        String uid = ((StringAttribute)value).getValue();
        User user = this.pdp.getBrokerPool().getSecurityManager().getUser(uid);
        if (user == null) {
            return UserAttributeModule.errorResult("No user exists for UID '" + uid + "'");
        }
        if (XACMLConstants.GROUP_ATTRIBUTE.equals(attributeId)) {
            return this.getGroups(user);
        }
        if (XACMLConstants.USER_NAME_ATTRIBUTE.equals(attributeId)) {
            return new EvaluationResult((AttributeValue)new StringAttribute(user.getName()));
        }
        return UserAttributeModule.errorResult("UserAttributeModule cannot handle attribute '" + attributeId + "'");
    }

    private EvaluationResult getGroups(User user) {
        String[] groupArray = user.getGroups();
        int size = groupArray == null ? 0 : groupArray.length;
        HashSet<StringAttribute> groupAttributes = new HashSet<StringAttribute>(size);
        for (int i = 0; i < size; ++i) {
            groupAttributes.add(new StringAttribute(groupArray[i]));
        }
        BagAttribute value = new BagAttribute(XACMLConstants.STRING_TYPE, groupAttributes);
        return new EvaluationResult((AttributeValue)value);
    }

    private static EvaluationResult errorResult(String message) {
        LOG.warn((Object)message);
        return new EvaluationResult(new Status(Collections.singletonList("urn:oasis:names:tc:xacml:1.0:status:processing-error"), message));
    }

    public boolean isDesignatorSupported() {
        return true;
    }

    public Set getSupportedDesignatorTypes() {
        return Collections.singleton(new Integer(0));
    }

    public Set getSupportedIds() {
        HashSet<URI> set = new HashSet<URI>(4);
        set.add(XACMLConstants.GROUP_ATTRIBUTE);
        set.add(XACMLConstants.USER_NAME_ATTRIBUTE);
        return set;
    }
}

