/*
 * Decompiled with CFR 0.152.
 */
package org.exist.storage;

import java.util.Map;
import org.apache.log4j.Logger;
import org.exist.dom.QName;
import org.exist.util.FastStringBuffer;

public class NodePath {
    private static final Logger LOG = Logger.getLogger((Class)NodePath.class);
    public static final QName WILDCARD = new QName("*", "");
    private QName[] components = new QName[5];
    private int pos = 0;
    private boolean includeDescendants = true;

    public NodePath() {
    }

    public NodePath(NodePath other) {
        this.components = new QName[other.components.length];
        System.arraycopy(other.components, 0, this.components, 0, other.components.length);
        this.pos = other.pos;
        this.includeDescendants = other.includeDescendants;
    }

    public NodePath(Map namespaces, String path) {
        this.init(namespaces, path);
    }

    public NodePath(Map namespaces, String path, boolean includeDescendants) {
        this.includeDescendants = includeDescendants;
        this.init(namespaces, path);
    }

    public void addComponent(QName component) {
        if (this.pos == this.components.length) {
            QName[] t = new QName[this.pos + 1];
            System.arraycopy(this.components, 0, t, 0, this.pos);
            this.components = t;
        }
        this.components[this.pos++] = component;
    }

    public void addComponentAtStart(QName component) {
        if (this.pos == this.components.length) {
            QName[] t = new QName[this.pos + 1];
            System.arraycopy(this.components, 0, t, 1, this.pos);
            this.components = t;
            this.components[0] = component;
        } else {
            System.arraycopy(this.components, 0, this.components, 1, this.pos);
            this.components[0] = component;
            ++this.pos;
        }
    }

    public void removeLastComponent() {
        if (this.pos > 0) {
            this.components[--this.pos] = null;
        }
    }

    public int length() {
        return this.pos;
    }

    public QName getComponent(int at) {
        if (at < 0 || at >= this.pos) {
            throw new ArrayIndexOutOfBoundsException(at);
        }
        return this.components[at];
    }

    public final boolean match(NodePath other) {
        int j;
        boolean skip = false;
        int i = 0;
        for (j = 0; j < other.pos; ++j) {
            if (i == this.pos) {
                if (this.includeDescendants) {
                    return true;
                }
                return j == other.pos;
            }
            if (this.components[i] == WILDCARD) {
                ++i;
                skip = true;
            }
            if (other.components[j].compareTo(this.components[i]) == 0 && (j + 1 == other.pos || other.components[j + 1].compareTo(this.components[i]) != 0)) {
                ++i;
                skip = false;
                continue;
            }
            if (skip) continue;
            return false;
        }
        if (i == this.pos) {
            if (this.includeDescendants) {
                return true;
            }
            return j == other.pos;
        }
        return false;
    }

    public void reset() {
        for (int i = 0; i < this.pos; ++i) {
            this.components[i] = null;
        }
        this.pos = 0;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < this.pos; ++i) {
            buf.append("/");
            if (this.components[i].getNameType() == 1) {
                buf.append("@");
            }
            buf.append(this.components[i]);
        }
        return buf.toString();
    }

    private void addComponent(Map namespaces, String component) {
        boolean isAttribute = false;
        if (component.startsWith("@")) {
            isAttribute = true;
            component = component.substring(1);
        }
        String prefix = QName.extractPrefix(component);
        String localName = QName.extractLocalName(component);
        String namespaceURI = "";
        if (prefix != null && (namespaceURI = (String)namespaces.get(prefix)) == null) {
            LOG.error((Object)("No namespace URI defined for prefix: " + prefix));
            prefix = null;
            namespaceURI = "";
        }
        QName qn = new QName(localName, namespaceURI, prefix);
        if (isAttribute) {
            qn.setNameType((byte)1);
        }
        this.addComponent(qn);
    }

    private void init(Map namespaces, String path) {
        FastStringBuffer token = new FastStringBuffer(path.length());
        int pos = 0;
        block3: while (pos < path.length()) {
            char ch = path.charAt(pos);
            switch (ch) {
                case '/': {
                    String next = token.toString();
                    token.setLength(0);
                    if (next.length() > 0) {
                        this.addComponent(namespaces, next);
                    }
                    if (path.charAt(++pos) != '/') continue block3;
                    this.addComponent(WILDCARD);
                    continue block3;
                }
            }
            token.append(ch);
            ++pos;
        }
        if (token.length() > 0) {
            this.addComponent(namespaces, token.toString());
        }
    }
}

