/*
 * Decompiled with CFR 0.152.
 */
package org.exist.storage;

import java.util.Map;
import org.exist.dom.QName;
import org.exist.storage.RangeIndexSpec;
import org.exist.util.DatabaseConfigurationException;
import org.exist.xquery.XPathException;
import org.exist.xquery.value.Type;

public class QNameRangeIndexSpec
extends RangeIndexSpec {
    private QName qname;

    public QNameRangeIndexSpec(Map namespaces, String name, String typeStr) throws DatabaseConfigurationException {
        try {
            this.type = Type.getType(typeStr);
        }
        catch (XPathException e) {
            throw new DatabaseConfigurationException("Unknown type: " + typeStr);
        }
        boolean isAttribute = false;
        if (name.startsWith("@")) {
            isAttribute = true;
            name = name.substring(1);
        }
        String prefix = QName.extractPrefix(name);
        String localName = QName.extractLocalName(name);
        String namespaceURI = "";
        if (prefix != null && (namespaceURI = (String)namespaces.get(prefix)) == null) {
            throw new DatabaseConfigurationException("No namespace defined for prefix: " + prefix + " in index definition");
        }
        this.qname = new QName(localName, namespaceURI, prefix);
        if (isAttribute) {
            this.qname.setNameType((byte)1);
        }
    }

    public QName getQName() {
        return this.qname;
    }
}

