/*
 * Decompiled with CFR 0.152.
 */
package org.exist.storage.dom;

import java.nio.ByteBuffer;
import org.exist.storage.DBBroker;
import org.exist.storage.NativeBroker;
import org.exist.storage.dom.DOMFile;
import org.exist.storage.journal.AbstractLoggable;
import org.exist.storage.journal.LogException;
import org.exist.storage.txn.Txn;

public class AddLinkLoggable
extends AbstractLoggable {
    protected long pageNum;
    protected short tid;
    protected long link;
    private DOMFile domDb = null;

    public AddLinkLoggable(Txn transaction, long pageNum, short tid, long link) {
        super((byte)26, transaction.getId());
        this.pageNum = pageNum;
        this.tid = tid;
        this.link = link;
    }

    public AddLinkLoggable(DBBroker broker, long transactId) {
        super((byte)26, transactId);
        this.domDb = ((NativeBroker)broker).getDOMFile();
    }

    public void write(ByteBuffer out) {
        out.putInt((int)this.pageNum);
        out.putShort(this.tid);
        out.putLong(this.link);
    }

    public void read(ByteBuffer in) {
        this.pageNum = in.getInt();
        this.tid = in.getShort();
        this.link = in.getLong();
    }

    public int getLogSize() {
        return 14;
    }

    public void redo() throws LogException {
        this.domDb.redoAddLink(this);
    }

    public void undo() throws LogException {
        this.domDb.undoAddLink(this);
    }

    public String dump() {
        return super.dump() + " - created link on page: " + this.pageNum + " for tid: " + this.tid;
    }
}

