/*
 * Decompiled with CFR 0.152.
 */
package org.exist.storage.dom;

import org.apache.log4j.Logger;
import org.exist.dom.DocumentImpl;
import org.exist.storage.dom.DOMFile;
import org.exist.storage.lock.Lock;
import org.exist.util.LockException;
import org.exist.util.ReadOnlyException;

public abstract class DOMTransaction {
    private static final Logger LOG = Logger.getLogger((Class)DOMTransaction.class);
    private Object ownerObject;
    private DOMFile file;
    private DocumentImpl document = null;
    private int mode;

    public DOMTransaction(Object owner, DOMFile f) {
        this.ownerObject = owner;
        this.file = f;
        this.mode = 0;
    }

    public DOMTransaction(Object owner, DOMFile f, int mode) {
        this(owner, f);
        this.mode = mode;
    }

    public DOMTransaction(Object owner, DOMFile f, int mode, DocumentImpl doc) {
        this(owner, f, mode);
        this.document = doc;
    }

    public abstract Object start() throws ReadOnlyException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object run() {
        Lock lock = this.file.getLock();
        try {
            try {
                lock.acquire(this.mode);
            }
            catch (LockException e) {
                System.out.println("Failed to acquire read lock on " + this.file.getFile().getName());
                Object var3_5 = null;
                lock.release(this.mode);
                return var3_5;
            }
            this.file.setOwnerObject(this.ownerObject);
            this.file.setCurrentDocument(this.document);
            Object e = this.start();
            return e;
        }
        catch (ReadOnlyException e) {
            LOG.warn((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            lock.release(this.mode);
        }
        return null;
    }
}

