/*
 * Decompiled with CFR 0.152.
 */
package org.exist.storage.dom;

import java.io.IOException;
import java.util.Iterator;
import org.apache.log4j.Logger;
import org.exist.dom.DocumentImpl;
import org.exist.dom.NodeProxy;
import org.exist.dom.StoredNode;
import org.exist.storage.DBBroker;
import org.exist.storage.StorageAddress;
import org.exist.storage.btree.BTreeException;
import org.exist.storage.dom.DOMFile;
import org.exist.storage.dom.ItemId;
import org.exist.storage.dom.RecordPos;
import org.exist.storage.lock.Lock;
import org.exist.util.ByteConversion;
import org.exist.util.LockException;
import org.exist.util.sanity.SanityCheck;

public final class NodeIterator
implements Iterator {
    private static final Logger LOG = Logger.getLogger((Class)NodeIterator.class);
    private DOMFile db = null;
    private StoredNode node = null;
    private DocumentImpl doc = null;
    private int offset;
    private short lastTID = (short)-1;
    private DOMFile.DOMPage p = null;
    private long page;
    private long startAddress = -1L;
    private DBBroker broker;
    private boolean useNodePool = false;

    public NodeIterator(DBBroker broker, DOMFile db, StoredNode node, boolean poolable) throws BTreeException, IOException {
        this.db = db;
        this.doc = (DocumentImpl)node.getOwnerDocument();
        this.useNodePool = poolable;
        this.node = node;
        this.broker = broker;
    }

    public long currentAddress() {
        return StorageAddress.createPointer((int)this.page, ItemId.getId(this.lastTID));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasNext() {
        Lock lock = this.db.getLock();
        try {
            try {
                lock.acquire(0);
            }
            catch (LockException e) {
                LOG.warn((Object)("Failed to acquire read lock on " + this.db.getFile().getName()));
                boolean bl = false;
                lock.release(0);
                return bl;
            }
            this.db.setOwnerObject(this.broker);
            if (this.gotoNextPosition()) {
                this.db.getPageBuffer().add(this.p);
                DOMFile.DOMFilePageHeader ph = this.p.getPageHeader();
                if (this.offset < ph.getDataLength()) {
                    boolean bl = true;
                    return bl;
                }
                if (ph.getNextDataPage() == -1L) {
                    boolean bl = false;
                    return bl;
                }
                boolean bl = true;
                return bl;
            }
        }
        catch (BTreeException e) {
            LOG.warn((Object)e);
        }
        catch (IOException e) {
            LOG.warn((Object)e);
        }
        finally {
            lock.release(0);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object next() {
        Lock lock = this.db.getLock();
        try {
            try {
                lock.acquire(0);
            }
            catch (LockException e) {
                LOG.warn((Object)("Failed to acquire read lock on " + this.db.getFile().getName()));
                Object var3_6 = null;
                lock.release(0);
                return var3_6;
            }
            this.db.setOwnerObject(this.broker);
            StoredNode nextNode = null;
            if (this.gotoNextPosition()) {
                long backLink = 0L;
                do {
                    DOMFile.DOMFilePageHeader ph;
                    if (this.offset >= (ph = this.p.getPageHeader()).getDataLength()) {
                        long nextPage = ph.getNextDataPage();
                        if (nextPage == -1L) {
                            SanityCheck.TRACE("bad link to next " + this.p.page.getPageInfo() + "; previous: " + ph.getPrevDataPage() + "; offset = " + this.offset + "; lastTID = " + this.lastTID);
                            System.out.println(this.db.debugPageContents(this.p));
                            Object var8_17 = null;
                            return var8_17;
                        }
                        this.page = nextPage;
                        this.p = this.db.getCurrentPage(nextPage);
                        this.db.addToBuffer(this.p);
                        this.offset = 0;
                    }
                    this.lastTID = ByteConversion.byteToShort(this.p.data, this.offset);
                    this.offset += 2;
                    if (ItemId.isLink(this.lastTID)) {
                        this.offset += 8;
                        continue;
                    }
                    int vlen = ByteConversion.byteToShort(this.p.data, this.offset);
                    this.offset += 2;
                    if (vlen < 0) {
                        LOG.warn((Object)("Got negative length" + vlen + " at offset " + this.offset + "!!!"));
                        LOG.debug((Object)this.db.debugPageContents(this.p));
                    }
                    if (ItemId.isRelocated(this.lastTID)) {
                        backLink = ByteConversion.byteToLong(this.p.data, this.offset);
                        this.offset += 8;
                    }
                    if (vlen == 0) {
                        vlen = 8;
                        long overflow = ByteConversion.byteToLong(this.p.data, this.offset);
                        this.offset += 8;
                        try {
                            byte[] odata = this.db.getOverflowValue(overflow);
                            nextNode = StoredNode.deserialize(odata, 0, odata.length, this.doc, this.useNodePool);
                        }
                        catch (Exception e) {
                            LOG.warn((Object)("Exception while loading overflow value: " + e.getMessage() + "; originating page: " + this.p.page.getPageInfo()));
                        }
                    } else {
                        try {
                            nextNode = StoredNode.deserialize(this.p.data, this.offset, vlen, this.doc, this.useNodePool);
                            this.offset += vlen;
                        }
                        catch (Exception e) {
                            LOG.warn((Object)("Error while deserializing node: " + e.getMessage()), (Throwable)e);
                            LOG.warn((Object)("Reading from offset: " + this.offset + "; len = " + vlen));
                            LOG.debug((Object)this.db.debugPageContents(this.p));
                            System.out.println(this.db.debugPageContents(this.p));
                            throw new RuntimeException(e);
                        }
                    }
                    if (nextNode == null) {
                        LOG.warn((Object)("illegal node on page " + this.p.getPageNum() + "; tid = " + ItemId.getId(this.lastTID) + "; next = " + this.p.getPageHeader().getNextDataPage() + "; prev = " + this.p.getPageHeader().getPrevDataPage() + "; offset = " + (this.offset - vlen) + "; len = " + this.p.getPageHeader().getDataLength()));
                        System.out.println(this.db.debugPageContents(this.p));
                        Object var7_14 = null;
                        return var7_14;
                    }
                    if (ItemId.isRelocated(this.lastTID)) {
                        nextNode.setInternalAddress(backLink);
                    } else {
                        nextNode.setInternalAddress(StorageAddress.createPointer((int)this.page, ItemId.getId(this.lastTID)));
                    }
                    nextNode.setOwnerDocument(this.doc);
                } while (nextNode == null);
            }
            StoredNode storedNode = nextNode;
            return storedNode;
        }
        catch (BTreeException e) {
            LOG.warn((Object)e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            LOG.warn((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            lock.release(0);
        }
        return null;
    }

    private boolean gotoNextPosition() throws BTreeException, IOException {
        if (this.node != null) {
            RecordPos rec = null;
            if (this.node.getInternalAddress() != -1L) {
                rec = this.db.findRecord(this.node.getInternalAddress());
            }
            if (rec == null) {
                long addr = this.db.findValue(this.broker, new NodeProxy(this.node));
                if (addr == -1L) {
                    return false;
                }
                rec = this.db.findRecord(addr);
            }
            this.page = rec.getPage().getPageNum();
            this.p = rec.getPage();
            this.offset = rec.offset - 2;
            this.node = null;
            return true;
        }
        if (this.startAddress != -1L) {
            RecordPos rec = this.db.findRecord(this.startAddress);
            if (rec == null) {
                throw new IOException("Node not found at specified address.");
            }
            this.page = rec.getPage().getPageNum();
            this.offset = rec.offset - 2;
            this.p = rec.getPage();
            this.startAddress = -1L;
            return true;
        }
        if (this.page != -1L) {
            this.p = this.db.getCurrentPage(this.page);
            this.db.addToBuffer(this.p);
            return true;
        }
        return false;
    }

    public void remove() {
        throw new RuntimeException("remove() method not implemented");
    }

    public void setTo(StoredNode node) {
        if (node.getInternalAddress() != -1L) {
            this.startAddress = node.getInternalAddress();
        } else {
            this.node = node;
        }
    }

    public void setTo(long address) {
        this.startAddress = address;
    }
}

