/*
 * Decompiled with CFR 0.152.
 */
package org.exist.storage.dom;

import java.nio.ByteBuffer;
import org.exist.storage.DBBroker;
import org.exist.storage.NativeBroker;
import org.exist.storage.dom.DOMFile;
import org.exist.storage.journal.AbstractLoggable;
import org.exist.storage.journal.LogException;
import org.exist.storage.txn.Txn;

public class RemoveOverflowLoggable
extends AbstractLoggable {
    private DOMFile domDb;
    protected long pageNum;
    protected long nextPage;
    protected byte[] oldData;

    public RemoveOverflowLoggable(Txn transaction, long pageNum, long nextPage, byte[] oldData) {
        super((byte)23, transaction.getId());
        this.pageNum = pageNum;
        this.nextPage = nextPage;
        this.oldData = oldData;
    }

    public RemoveOverflowLoggable(DBBroker broker, long transactionId) {
        super((byte)23, transactionId);
        this.domDb = ((NativeBroker)broker).getDOMFile();
    }

    public void write(ByteBuffer out) {
        out.putInt((int)this.pageNum);
        out.putInt((int)this.nextPage);
        out.putShort((short)this.oldData.length);
        out.put(this.oldData);
    }

    public void read(ByteBuffer in) {
        this.pageNum = in.getInt();
        this.nextPage = in.getInt();
        short len = in.getShort();
        this.oldData = new byte[len];
        in.get(this.oldData);
    }

    public int getLogSize() {
        return 10 + this.oldData.length;
    }

    public void redo() throws LogException {
        this.domDb.redoRemoveOverflow(this);
    }

    public void undo() throws LogException {
        this.domDb.undoRemoveOverflow(this);
    }

    public String dump() {
        return super.dump() + " - removed overflow page " + this.pageNum;
    }
}

