/*
 * Decompiled with CFR 0.152.
 */
package org.exist.storage.dom;

import java.nio.ByteBuffer;
import org.exist.storage.DBBroker;
import org.exist.storage.NativeBroker;
import org.exist.storage.dom.DOMFile;
import org.exist.storage.journal.AbstractLoggable;
import org.exist.storage.journal.LogException;
import org.exist.storage.journal.Loggable;
import org.exist.storage.txn.Txn;

public class SplitPageLoggable
extends AbstractLoggable
implements Loggable {
    protected long pageNum;
    protected int splitOffset;
    protected byte[] oldData;
    protected int oldLen;
    private DOMFile domDb = null;

    public SplitPageLoggable(Txn transaction, long pageNum, int splitOffset, byte[] oldData, int oldLen) {
        super((byte)25, transaction.getId());
        this.pageNum = pageNum;
        this.splitOffset = splitOffset;
        this.oldData = oldData;
        this.oldLen = oldLen;
    }

    public SplitPageLoggable(DBBroker broker, long transactId) {
        super((byte)25, transactId);
        this.domDb = ((NativeBroker)broker).getDOMFile();
    }

    public void write(ByteBuffer out) {
        out.putInt((int)this.pageNum);
        out.putInt(this.splitOffset);
        out.putShort((short)this.oldLen);
        out.put(this.oldData, 0, this.oldLen);
    }

    public void read(ByteBuffer in) {
        this.pageNum = in.getInt();
        this.splitOffset = in.getInt();
        this.oldLen = in.getShort();
        this.oldData = new byte[this.domDb.getFileHeader().getWorkSize()];
        in.get(this.oldData, 0, this.oldLen);
    }

    public int getLogSize() {
        return 10 + this.oldLen;
    }

    public void redo() throws LogException {
        this.domDb.redoSplitPage(this);
    }

    public void undo() throws LogException {
        this.domDb.undoSplitPage(this);
    }

    public String dump() {
        return super.dump() + " - page split: " + this.pageNum + " at offset: " + this.splitOffset;
    }
}

