/*
 * Decompiled with CFR 0.152.
 */
package org.exist.storage.index;

import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import org.exist.storage.BrokerPool;
import org.exist.storage.BufferStats;
import org.exist.storage.DefaultCacheManager;
import org.exist.storage.StorageAddress;
import org.exist.storage.btree.BTree;
import org.exist.storage.btree.BTreeCallback;
import org.exist.storage.btree.BTreeException;
import org.exist.storage.btree.DBException;
import org.exist.storage.btree.IndexQuery;
import org.exist.storage.btree.Paged;
import org.exist.storage.btree.Value;
import org.exist.storage.cache.Cache;
import org.exist.storage.cache.Cacheable;
import org.exist.storage.cache.LRUCache;
import org.exist.storage.index.AbstractBFileLoggable;
import org.exist.storage.index.BFileCallback;
import org.exist.storage.index.CreatePageLoggable;
import org.exist.storage.index.FreeList;
import org.exist.storage.index.FreeSpace;
import org.exist.storage.index.OverflowAppendLoggable;
import org.exist.storage.index.OverflowCreateLoggable;
import org.exist.storage.index.OverflowCreatePageLoggable;
import org.exist.storage.index.OverflowModifiedLoggable;
import org.exist.storage.index.OverflowRemoveLoggable;
import org.exist.storage.index.OverflowStoreLoggable;
import org.exist.storage.index.RemoveEmptyPageLoggable;
import org.exist.storage.index.RemoveValueLoggable;
import org.exist.storage.index.StoreValueLoggable;
import org.exist.storage.io.VariableByteArrayInput;
import org.exist.storage.io.VariableByteInput;
import org.exist.storage.io.VariableByteOutputStream;
import org.exist.storage.journal.LogEntryTypes;
import org.exist.storage.journal.Loggable;
import org.exist.storage.lock.Lock;
import org.exist.storage.lock.ReentrantReadWriteLock;
import org.exist.storage.txn.TransactionException;
import org.exist.storage.txn.Txn;
import org.exist.util.ByteArray;
import org.exist.util.ByteConversion;
import org.exist.util.FixedByteArray;
import org.exist.util.IndexCallback;
import org.exist.util.LockException;
import org.exist.util.ReadOnlyException;
import org.exist.util.sanity.SanityCheck;
import org.exist.xquery.TerminatedException;

public class BFile
extends BTree {
    public static final short FILE_FORMAT_VERSION_ID = 10;
    public static final long UNKNOWN_ADDRESS = -1L;
    public static final long DATA_SYNC_PERIOD = 15000L;
    public static final int PAGE_MIN_FREE = 64;
    public static final byte RECORD = 20;
    public static final byte LOB = 21;
    public static final byte FREE_LIST = 22;
    public static final byte MULTI_PAGE = 23;
    public static final int LENGTH_RECORDS_COUNT = 2;
    public static final int LENGTH_NEXT_TID = 2;
    public static final byte LOG_CREATE_PAGE = 48;
    public static final byte LOG_STORE_VALUE = 49;
    public static final byte LOG_REMOVE_VALUE = 50;
    public static final byte LOG_REMOVE_PAGE = 51;
    public static final byte LOG_OVERFLOW_APPEND = 52;
    public static final byte LOG_OVERFLOW_STORE = 53;
    public static final byte LOG_OVERFLOW_CREATE = 54;
    public static final byte LOG_OVERFLOW_MODIFIED = 55;
    public static final byte LOG_OVERFLOW_CREATE_PAGE = 56;
    public static final byte LOG_OVERFLOW_REMOVE = 57;
    protected BFileHeader fileHeader = (BFileHeader)this.getFileHeader();
    protected int minFree;
    protected Cache dataCache = null;
    protected Lock lock = null;
    public int fixedKeyLen = -1;
    protected int maxValueSize;

    public BFile(BrokerPool pool, byte fileId, boolean transactional, File file, DefaultCacheManager cacheManager, double cacheGrowth, double thresholdBTree, double thresholdData) throws DBException {
        super(pool, fileId, transactional, cacheManager, file, thresholdBTree);
        this.dataCache = new LRUCache(64, cacheGrowth, thresholdData, "DATA");
        this.dataCache.setFileName(file.getName());
        cacheManager.registerCache(this.dataCache);
        this.minFree = 64;
        this.lock = new ReentrantReadWriteLock(file.getName());
        this.maxValueSize = this.fileHeader.getWorkSize() / 2;
        if (this.exists()) {
            this.open();
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Creating data file: " + this.getFile().getName()));
            }
            this.create();
        }
    }

    public short getFileVersion() {
        return 10;
    }

    public Lock getLock() {
        return this.lock;
    }

    protected long getDataSyncPeriod() {
        return 15000L;
    }

    public long append(Value key, ByteArray value) throws ReadOnlyException, IOException {
        return this.append(null, key, value);
    }

    public long append(Txn transaction, Value key, ByteArray value) throws ReadOnlyException, IOException {
        if (key == null) {
            LOG.debug((Object)"key is null");
            return -1L;
        }
        if (key.getLength() > this.fileHeader.getMaxKeySize()) {
            LOG.warn((Object)"Key length exceeds page size! Skipping key ...");
            return -1L;
        }
        try {
            long p = this.findValue(key);
            if (p == -1L) {
                p = this.storeValue(transaction, value);
                this.addValue(transaction, key, p);
                return p;
            }
            long pnum = StorageAddress.pageFromPointer(p);
            short tid = StorageAddress.tidFromPointer(p);
            DataPage page = this.getDataPage(pnum);
            if (page instanceof OverflowPage) {
                ((OverflowPage)page).append(transaction, value);
            } else {
                int valueLen = value.size();
                byte[] data = page.getData();
                int offset = page.findValuePosition(tid);
                if (offset < 0) {
                    throw new IOException("tid " + tid + " not found on page " + pnum);
                }
                if (offset + 4 > data.length) {
                    LOG.error((Object)("found invalid pointer in file " + this.getFile().getName() + " for page" + page.getPageInfo() + " : " + "tid = " + tid + "; offset = " + offset));
                    return -1L;
                }
                int l = ByteConversion.byteToInt(data, offset);
                if (offset + 4 + l > data.length) {
                    LOG.error((Object)("found invalid data record in file " + this.getFile().getName() + " for page" + page.getPageInfo() + " : " + "length = " + data.length + "; required = " + (offset + 4 + l)));
                    return -1L;
                }
                byte[] newData = new byte[l + valueLen];
                System.arraycopy(data, offset + 4, newData, 0, l);
                value.copyTo(newData, l);
                p = this.update(transaction, p, page, key, new FixedByteArray(newData, 0, newData.length));
            }
            return p;
        }
        catch (BTreeException bte) {
            LOG.warn((Object)"btree exception while appending value", (Throwable)bte);
            return -1L;
        }
    }

    public boolean close() throws DBException {
        super.close();
        return true;
    }

    public boolean containsKey(Value key) {
        try {
            return this.findValue(key) != -1L;
        }
        catch (BTreeException e) {
            LOG.warn((Object)e.getMessage());
        }
        catch (IOException e) {
            LOG.warn((Object)e.getMessage());
        }
        return false;
    }

    public boolean create() throws DBException {
        return super.create((short)this.fixedKeyLen);
    }

    public void closeAndRemove() {
        super.closeAndRemove();
        this.cacheManager.deregisterCache(this.dataCache);
    }

    private SinglePage createDataPage() {
        try {
            SinglePage page = new SinglePage();
            this.dataCache.add(page, 2);
            return page;
        }
        catch (IOException ioe) {
            LOG.warn((Object)ioe);
            return null;
        }
    }

    public Paged.FileHeader createFileHeader(int pageSize) {
        return new BFileHeader(pageSize);
    }

    public Paged.PageHeader createPageHeader() {
        return new BFilePageHeader();
    }

    public void removeAll(Txn transaction, IndexQuery query) throws IOException, BTreeException {
        try {
            RemoveCallback cb = new RemoveCallback();
            this.remove(transaction, query, cb);
            LOG.debug((Object)("Found " + cb.count + " items to remove."));
            if (cb.count == 0) {
                return;
            }
            Arrays.sort(cb.pointers, 0, cb.count - 1);
            for (int i = 0; i < cb.count; ++i) {
                try {
                    this.remove(transaction, cb.pointers[i]);
                    continue;
                }
                catch (ReadOnlyException e) {
                    LOG.warn((Object)"Database is read-only. Cannot remove items.");
                    throw new IOException("Database is read-only");
                }
            }
        }
        catch (TerminatedException e) {
            LOG.warn((Object)"removeAll() - method has been terminated.");
        }
    }

    public ArrayList findEntries(IndexQuery query) throws IOException, BTreeException, TerminatedException {
        FindCallback cb = new FindCallback(2);
        this.query(query, cb);
        return cb.getValues();
    }

    public ArrayList findKeys(IndexQuery query) throws IOException, BTreeException, TerminatedException {
        FindCallback cb = new FindCallback(1);
        this.query(query, cb);
        return cb.getValues();
    }

    public void find(IndexQuery query, IndexCallback callback) throws IOException, BTreeException, TerminatedException {
        FindCallback cb = new FindCallback(callback);
        this.query(query, cb);
    }

    public boolean flush() throws DBException {
        boolean flushed = false;
        if (this.isTransactional) {
            this.logManager.flushToLog(true);
        }
        flushed |= this.dataCache.flush();
        return flushed |= super.flush();
    }

    public BufferStats getDataBufferStats() {
        if (this.dataCache == null) {
            return null;
        }
        return new BufferStats(this.dataCache.getBuffers(), this.dataCache.getUsedBuffers(), this.dataCache.getHits(), this.dataCache.getFails());
    }

    public void printStatistics() {
        super.printStatistics();
        NumberFormat nf = NumberFormat.getPercentInstance();
        StringBuffer buf = new StringBuffer();
        buf.append(this.getFile().getName()).append(" DATA ");
        buf.append("Buffers occupation : ");
        if (this.dataCache.getBuffers() == 0 && this.dataCache.getUsedBuffers() == 0) {
            buf.append("N/A");
        } else {
            buf.append(nf.format((float)this.dataCache.getUsedBuffers() / (float)this.dataCache.getBuffers()));
        }
        buf.append(" (" + this.dataCache.getUsedBuffers() + " out of " + this.dataCache.getBuffers() + ")");
        buf.append(" Cache efficiency : ");
        if (this.dataCache.getHits() == 0 && this.dataCache.getFails() == 0) {
            buf.append("N/A");
        } else {
            buf.append(nf.format((float)this.dataCache.getHits() / (float)(this.dataCache.getHits() + this.dataCache.getFails())));
        }
        LOG.info((Object)buf.toString());
    }

    public Value get(Value key) {
        try {
            long p = this.findValue(key);
            if (p == -1L) {
                return null;
            }
            long pnum = StorageAddress.pageFromPointer(p);
            DataPage page = this.getDataPage(pnum);
            return this.get(page, p);
        }
        catch (BTreeException e) {
            LOG.warn((Object)("An exception occurred while trying to retrieve key " + key + ": " + e.getMessage()), (Throwable)e);
        }
        catch (IOException e) {
            LOG.warn((Object)e.getMessage(), (Throwable)e);
        }
        return null;
    }

    public VariableByteInput getAsStream(Value key) throws IOException {
        try {
            long p = this.findValue(key);
            if (p == -1L) {
                return null;
            }
            long pnum = StorageAddress.pageFromPointer(p);
            DataPage page = this.getDataPage(pnum);
            switch (page.getPageHeader().getStatus()) {
                case 23: {
                    return ((OverflowPage)page).getDataStream(p);
                }
            }
            return this.getAsStream(page, p);
        }
        catch (BTreeException e) {
            LOG.warn((Object)("An exception occurred while trying to retrieve key " + key + ": " + e.getMessage()), (Throwable)e);
            return null;
        }
    }

    public VariableByteInput getAsStream(long pointer) throws IOException {
        DataPage page = this.getDataPage(StorageAddress.pageFromPointer(pointer));
        switch (page.getPageHeader().getStatus()) {
            case 23: {
                return ((OverflowPage)page).getDataStream(pointer);
            }
        }
        return this.getAsStream(page, pointer);
    }

    private VariableByteInput getAsStream(DataPage page, long pointer) throws IOException {
        this.dataCache.add(page.getFirstPage(), 2);
        short tid = StorageAddress.tidFromPointer(pointer);
        int offset = page.findValuePosition(tid);
        if (offset < 0) {
            throw new IOException("no data found at tid " + tid + "; page " + page.getPageNum());
        }
        byte[] data = page.getData();
        int l = ByteConversion.byteToInt(data, offset);
        SimplePageInput input = new SimplePageInput(data, offset + 4, l, pointer);
        return input;
    }

    public Value get(long p) {
        try {
            long pnum = StorageAddress.pageFromPointer(p);
            DataPage page = this.getDataPage(pnum);
            return this.get(page, p);
        }
        catch (BTreeException e) {
            LOG.debug((Object)e);
        }
        catch (IOException e) {
            LOG.debug((Object)e);
        }
        return null;
    }

    protected Value get(DataPage page, long p) throws BTreeException, IOException {
        short tid = StorageAddress.tidFromPointer(p);
        int offset = page.findValuePosition(tid);
        byte[] data = page.getData();
        if (offset < 0 || offset > data.length) {
            LOG.error((Object)("wrong pointer (tid: " + tid + page.getPageInfo() + ") in file " + this.getFile().getName() + "; offset = " + offset));
            return null;
        }
        int l = ByteConversion.byteToInt(data, offset);
        if (l + 6 > data.length) {
            LOG.error((Object)(this.getFile().getName() + " wrong data length in page " + page.getPageNum() + ": expected=" + (l + 6) + "; found=" + data.length));
            return null;
        }
        this.dataCache.add(page.getFirstPage());
        Value v = new Value(data, offset + 4, l);
        v.setAddress(p);
        return v;
    }

    private DataPage getDataPage(long pos) throws IOException {
        return this.getDataPage(pos, true);
    }

    private DataPage getDataPage(long pos, boolean initialize) throws IOException {
        DataPage wp = (DataPage)this.dataCache.get(pos);
        if (wp == null) {
            Paged.Page page = this.getPage(pos);
            if (page == null) {
                LOG.debug((Object)("page " + pos + " not found!"));
                return null;
            }
            byte[] data = page.read();
            if (page.getPageHeader().getStatus() == 23) {
                return new OverflowPage(page, data);
            }
            return new SinglePage(page, data, initialize);
        }
        if (wp.getPageHeader().getStatus() == 23) {
            return new OverflowPage(wp);
        }
        return wp;
    }

    private SinglePage getSinglePage(long pos) throws IOException {
        SinglePage wp = (SinglePage)this.dataCache.get(pos);
        if (wp == null) {
            Paged.Page page = this.getPage(pos);
            if (page == null) {
                LOG.debug((Object)("page " + pos + " not found!"));
                return null;
            }
            byte[] data = page.read();
            return new SinglePage(page, data, false);
        }
        return wp;
    }

    public ArrayList getEntries() throws IOException, BTreeException, TerminatedException {
        IndexQuery query = new IndexQuery(0, "");
        FindCallback cb = new FindCallback(2);
        this.query(query, cb);
        return cb.getValues();
    }

    public ArrayList getKeys() throws IOException, BTreeException, TerminatedException {
        IndexQuery query = new IndexQuery(0, "");
        FindCallback cb = new FindCallback(1);
        this.query(query, cb);
        return cb.getValues();
    }

    public ArrayList getValues() throws IOException, BTreeException, TerminatedException {
        IndexQuery query = new IndexQuery(0, "");
        FindCallback cb = new FindCallback(0);
        this.query(query, cb);
        return cb.getValues();
    }

    public boolean open() throws DBException {
        return super.open((short)10);
    }

    public long put(Value key, byte[] data, boolean overwrite) throws ReadOnlyException {
        return this.put(null, key, data, overwrite);
    }

    public long put(Txn transaction, Value key, byte[] data, boolean overwrite) throws ReadOnlyException {
        SanityCheck.THROW_ASSERT(key.getLength() <= this.fileHeader.getWorkSize(), "Key length exceeds page size!");
        FixedByteArray buf = new FixedByteArray(data, 0, data.length);
        return this.put(transaction, key, buf, overwrite);
    }

    public long put(Value key, ByteArray value) throws ReadOnlyException {
        return this.put(key, value, true);
    }

    public long put(Value key, ByteArray value, boolean overwrite) throws ReadOnlyException {
        return this.put(null, key, value, overwrite);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long put(Txn transaction, Value key, ByteArray value, boolean overwrite) throws ReadOnlyException {
        if (key == null) {
            LOG.debug((Object)"key is null");
            return -1L;
        }
        if (key.getLength() > this.fileHeader.getWorkSize()) {
            LOG.warn((Object)"Key length exceeds page size! Skipping key ...");
            return -1L;
        }
        try {
            try {
                long p = this.findValue(key);
                if (p == -1L) {
                    p = this.storeValue(transaction, value);
                    this.addValue(transaction, key, p);
                    return p;
                }
                if (overwrite) {
                    return this.update(transaction, p, key, value);
                }
                return -1L;
            }
            catch (BTreeException bte) {
                long p = this.storeValue(transaction, value);
                this.addValue(transaction, key, p);
                return p;
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                LOG.warn((Object)ioe);
                return -1L;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            LOG.warn((Object)e);
            return -1L;
        }
        catch (BTreeException bte) {
            bte.printStackTrace();
            LOG.warn((Object)bte);
            return -1L;
        }
    }

    public void remove(Value key) throws ReadOnlyException {
        this.remove(null, key);
    }

    public void remove(Txn transaction, Value key) throws ReadOnlyException {
        try {
            long p = this.findValue(key);
            if (p == -1L) {
                return;
            }
            long pos = StorageAddress.pageFromPointer(p);
            DataPage page = this.getDataPage(pos);
            this.remove(transaction, page, p);
            this.removeValue(transaction, key);
        }
        catch (BTreeException bte) {
            LOG.debug((Object)bte);
        }
        catch (IOException ioe) {
            LOG.debug((Object)ioe);
        }
    }

    public void remove(Txn transaction, long p) throws ReadOnlyException {
        try {
            long pos = StorageAddress.pageFromPointer(p);
            DataPage page = this.getDataPage(pos);
            this.remove(transaction, page, p);
        }
        catch (BTreeException e) {
            LOG.debug((Object)"btree problem", (Throwable)e);
        }
        catch (IOException e) {
            LOG.debug((Object)"io problem", (Throwable)e);
        }
    }

    private void remove(Txn transaction, DataPage page, long p) throws BTreeException, IOException, ReadOnlyException {
        byte[] data;
        if (page.getPageHeader().getStatus() == 23) {
            ((OverflowPage)page).delete(transaction);
            return;
        }
        short tid = StorageAddress.tidFromPointer(p);
        int offset = page.findValuePosition(tid);
        if (offset > (data = page.getData()).length || offset < 0) {
            LOG.error((Object)("wrong pointer (tid: " + tid + ", " + page.getPageInfo() + ")"));
            return;
        }
        int l = ByteConversion.byteToInt(data, offset);
        if (this.isTransactional && transaction != null) {
            RemoveValueLoggable loggable = new RemoveValueLoggable(transaction, this.fileId, page.getPageNum(), tid, data, offset + 4, l);
            this.writeToLog(loggable, page);
        }
        BFilePageHeader ph = page.getPageHeader();
        int end = offset + 4 + l;
        int len = ph.getDataLength();
        System.arraycopy(data, end, data, offset - 2, len - end);
        ph.setDirty(true);
        ph.decRecordCount();
        len = len - l - 6;
        ph.setDataLength(len);
        page.setDirty(true);
        if (len == 0) {
            if (this.isTransactional && transaction != null) {
                RemoveEmptyPageLoggable loggable = new RemoveEmptyPageLoggable(transaction, this.fileId, page.getPageNum());
                this.writeToLog(loggable, page);
            }
            this.fileHeader.removeFreeSpace(this.fileHeader.getFreeSpace(page.getPageNum()));
            this.dataCache.remove(page);
            page.delete();
        } else {
            page.removeTID(tid, l + 6);
            int newFree = this.fileHeader.getWorkSize() - len;
            if (newFree > this.minFree) {
                FreeSpace free = this.fileHeader.getFreeSpace(page.getPageNum());
                if (free == null) {
                    free = new FreeSpace(page.getPageNum(), newFree);
                    this.fileHeader.addFreeSpace(free);
                } else {
                    free.setFree(newFree);
                }
            }
            this.dataCache.add(page, 2);
        }
    }

    private final void saveFreeSpace(FreeSpace space, DataPage page) {
        int free = this.fileHeader.getWorkSize() - page.getPageHeader().getDataLength();
        space.setFree(free);
        if (free < this.minFree) {
            this.fileHeader.removeFreeSpace(space);
        }
    }

    public void setLocation(String location) throws DBException {
        this.setFile(new File(location + ".dbx"));
    }

    public long storeValue(Txn transaction, ByteArray value) throws IOException, ReadOnlyException {
        AbstractBFileLoggable loggable;
        int vlen = value.size();
        if (6 + vlen > this.maxValueSize) {
            OverflowPage page = new OverflowPage(transaction);
            byte[] data = new byte[vlen + 6];
            page.getPageHeader().setDataLength(vlen + 6);
            ByteConversion.shortToByte((short)1, data, 0);
            ByteConversion.intToByte(vlen, data, 2);
            value.copyTo(data, 6);
            page.setData(transaction, data);
            page.setDirty(true);
            return StorageAddress.createPointer((int)page.getPageNum(), (short)1);
        }
        DataPage page = null;
        short tid = -1;
        FreeSpace free = null;
        int realSpace = 0;
        while (tid < 0) {
            free = this.fileHeader.findFreeSpace(vlen + 6);
            if (free == null) {
                page = this.createDataPage();
                if (this.isTransactional && transaction != null) {
                    loggable = new CreatePageLoggable(transaction, this.fileId, page.getPageNum());
                    this.writeToLog(loggable, page);
                }
                page.setData(new byte[this.fileHeader.getWorkSize()]);
                free = new FreeSpace(page.getPageNum(), this.fileHeader.getWorkSize() - page.getPageHeader().getDataLength());
                this.fileHeader.addFreeSpace(free);
            } else {
                page = this.getDataPage(free.getPage());
                if (page.getPageHeader().getStatus() != 20) {
                    LOG.warn((Object)("page " + page.getPageNum() + " is not a data page; removing it"));
                    this.fileHeader.removeFreeSpace(free);
                    continue;
                }
                realSpace = this.fileHeader.getWorkSize() - page.getPageHeader().getDataLength();
                if (realSpace < 6 + vlen) {
                    LOG.warn((Object)("Wrong data length in list of free pages: adjusting to " + realSpace));
                    free.setFree(realSpace);
                    continue;
                }
            }
            if ((tid = page.getNextTID()) >= 0) continue;
            LOG.info((Object)("removing page " + page.getPageNum() + " from free pages"));
            this.fileHeader.removeFreeSpace(free);
        }
        if (this.isTransactional && transaction != null) {
            loggable = new StoreValueLoggable(transaction, this.fileId, page.getPageNum(), tid, value);
            this.writeToLog(loggable, page);
        }
        int len = page.getPageHeader().getDataLength();
        byte[] data = page.getData();
        ByteConversion.shortToByte(tid, data, len);
        page.setOffset(tid, len += 2);
        ByteConversion.intToByte(vlen, data, len);
        value.copyTo(data, len += 4);
        page.getPageHeader().setDataLength(len += vlen);
        page.getPageHeader().incRecordCount();
        this.saveFreeSpace(free, page);
        page.setDirty(true);
        this.dataCache.add(page);
        return StorageAddress.createPointer((int)page.getPageNum(), tid);
    }

    public long update(Value key, ByteArray value) throws ReadOnlyException {
        try {
            long p = this.findValue(key);
            if (p == -1L) {
                return -1L;
            }
            return this.update(p, key, value);
        }
        catch (BTreeException bte) {
            LOG.debug((Object)bte);
        }
        catch (IOException ioe) {
            LOG.debug((Object)ioe);
        }
        return -1L;
    }

    public long update(long p, Value key, ByteArray value) throws ReadOnlyException {
        return this.update(null, p, key, value);
    }

    public long update(Txn transaction, long p, Value key, ByteArray value) throws ReadOnlyException {
        try {
            return this.update(transaction, p, this.getDataPage(StorageAddress.pageFromPointer(p)), key, value);
        }
        catch (BTreeException bte) {
            LOG.debug((Object)bte);
            return -1L;
        }
        catch (IOException ioe) {
            LOG.warn((Object)ioe.getMessage(), (Throwable)ioe);
            return -1L;
        }
    }

    protected long update(Txn transaction, long p, DataPage page, Value key, ByteArray value) throws BTreeException, IOException, ReadOnlyException {
        if (page.getPageHeader().getStatus() == 23) {
            int valueLen = value.size();
            if (valueLen + 6 < this.maxValueSize) {
                this.remove(transaction, page, p);
                long np = this.storeValue(transaction, value);
                this.addValue(transaction, key, np);
                return np;
            }
            byte[] data = new byte[valueLen + 6];
            ByteConversion.shortToByte((short)1, data, 0);
            ByteConversion.intToByte(valueLen, data, 2);
            value.copyTo(data, 6);
            ((OverflowPage)page).setData(transaction, data);
            return p;
        }
        this.remove(transaction, page, p);
        long np = this.storeValue(transaction, value);
        this.addValue(transaction, key, np);
        return np;
    }

    public void debugFreeList() {
        this.fileHeader.debugFreeList();
    }

    private void writeToLog(Loggable loggable, DataPage page) {
        try {
            this.logManager.writeToLog(loggable);
            page.getPageHeader().setLsn(loggable.getLsn());
        }
        catch (TransactionException e) {
            LOG.warn((Object)e.getMessage(), (Throwable)e);
        }
    }

    private SinglePage getSinglePageForRedo(Loggable loggable, long pos) throws IOException {
        SinglePage wp = (SinglePage)this.dataCache.get(pos);
        if (wp == null) {
            Paged.Page page = this.getPage(pos);
            byte[] data = page.read();
            if (page.getPageHeader().getStatus() < 20) {
                return null;
            }
            if (loggable != null && this.isUptodate(page, loggable)) {
                return null;
            }
            return new SinglePage(page, data, true);
        }
        return wp;
    }

    private boolean isUptodate(Paged.Page page, Loggable loggable) {
        return page.getPageHeader().getLsn() >= loggable.getLsn();
    }

    private boolean requiresRedo(Loggable loggable, DataPage page) {
        return loggable.getLsn() > page.getPageHeader().getLsn();
    }

    protected void redoStoreValue(StoreValueLoggable loggable) {
        try {
            SinglePage page = this.getSinglePageForRedo(loggable, loggable.page);
            if (page != null && this.requiresRedo((Loggable)loggable, page)) {
                this.storeValueHelper(loggable, loggable.tid, loggable.value, page);
            }
        }
        catch (IOException e) {
            LOG.warn((Object)("An IOException occurred during redo: " + e.getMessage()));
        }
    }

    protected void undoStoreValue(StoreValueLoggable loggable) {
        try {
            SinglePage page = (SinglePage)this.getDataPage(loggable.page);
            this.removeValueHelper(null, loggable.tid, page);
        }
        catch (IOException e) {
            LOG.warn((Object)("An IOException occurred during redo: " + e.getMessage()), (Throwable)e);
        }
    }

    protected void redoCreatePage(CreatePageLoggable loggable) {
        this.createPageHelper(loggable, loggable.newPage);
    }

    protected void undoCreatePage(CreatePageLoggable loggable) {
        try {
            SinglePage page = (SinglePage)this.getDataPage(loggable.newPage);
            this.fileHeader.removeFreeSpace(this.fileHeader.getFreeSpace(page.getPageNum()));
            this.dataCache.remove(page);
            page.delete();
        }
        catch (IOException e) {
            LOG.warn((Object)("An IOException occurred during redo: " + e.getMessage()), (Throwable)e);
        }
    }

    protected void redoRemoveValue(RemoveValueLoggable loggable) {
        try {
            SinglePage wp = (SinglePage)this.dataCache.get(loggable.page);
            if (wp == null) {
                Paged.Page page = this.getPage(loggable.page);
                if (page == null) {
                    LOG.warn((Object)("page " + loggable.page + " not found!"));
                    return;
                }
                byte[] data = page.read();
                if (page.getPageHeader().getStatus() < 20 || this.isUptodate(page, loggable)) {
                    return;
                }
                wp = new SinglePage(page, data, true);
            }
            if (wp.ph.getLsn() != -1L && this.requiresRedo((Loggable)loggable, wp)) {
                this.removeValueHelper(loggable, loggable.tid, wp);
            }
        }
        catch (IOException e) {
            LOG.warn((Object)("An IOException occurred during redo: " + e.getMessage()), (Throwable)e);
        }
    }

    protected void undoRemoveValue(RemoveValueLoggable loggable) {
        try {
            SinglePage page = this.getSinglePage(loggable.page);
            FixedByteArray data = new FixedByteArray(loggable.oldData);
            this.storeValueHelper(null, loggable.tid, data, page);
        }
        catch (IOException e) {
            LOG.warn((Object)("An IOException occurred during redo: " + e.getMessage()), (Throwable)e);
        }
    }

    protected void redoRemovePage(RemoveEmptyPageLoggable loggable) {
        try {
            SinglePage wp = (SinglePage)this.dataCache.get(loggable.page);
            if (wp == null) {
                Paged.Page page = this.getPage(loggable.page);
                if (page == null) {
                    LOG.warn((Object)("page " + loggable.page + " not found!"));
                    return;
                }
                byte[] data = page.read();
                if (page.getPageHeader().getStatus() < 20 || this.isUptodate(page, loggable)) {
                    return;
                }
                wp = new SinglePage(page, data, false);
            }
            if (wp.getPageHeader().getLsn() == -1L || this.requiresRedo((Loggable)loggable, wp)) {
                this.fileHeader.removeFreeSpace(this.fileHeader.getFreeSpace(wp.getPageNum()));
                this.dataCache.remove(wp);
                wp.delete();
            }
        }
        catch (IOException e) {
            LOG.warn((Object)("An IOException occurred during redo: " + e.getMessage()), (Throwable)e);
        }
    }

    protected void undoRemovePage(RemoveEmptyPageLoggable loggable) {
        this.createPageHelper(null, loggable.page);
    }

    protected void redoCreateOverflow(OverflowCreateLoggable loggable) {
        try {
            DataPage firstPage = (DataPage)this.dataCache.get(loggable.pageNum);
            if (firstPage == null) {
                Paged.Page page = this.getPage(loggable.pageNum);
                byte[] data = page.read();
                if (page.getPageHeader().getLsn() == -1L || this.requiresRedo((Loggable)loggable, page)) {
                    this.reuseDeleted(page);
                    BFilePageHeader ph = (BFilePageHeader)page.getPageHeader();
                    ph.setStatus((byte)23);
                    ph.setNextInChain(0L);
                    ph.setLastInChain(0L);
                    ph.setDataLength(0);
                    ph.nextTID = (short)32;
                    data = new byte[this.fileHeader.getWorkSize()];
                    firstPage = new SinglePage(page, data, true);
                    firstPage.setDirty(true);
                } else {
                    firstPage = new SinglePage(page, data, false);
                }
            }
            if (firstPage.getPageHeader().getLsn() != -1L && this.requiresRedo((Loggable)loggable, firstPage)) {
                firstPage.getPageHeader().setLsn(loggable.getLsn());
                firstPage.setDirty(true);
            }
            this.dataCache.add(firstPage);
        }
        catch (IOException e) {
            LOG.warn((Object)("An IOException occurred during redo: " + e.getMessage()), (Throwable)e);
        }
    }

    protected void undoCreateOverflow(OverflowCreateLoggable loggable) {
        try {
            SinglePage page = this.getSinglePage(loggable.pageNum);
            this.dataCache.remove(page);
            page.delete();
        }
        catch (IOException e) {
            LOG.warn((Object)("An IOException occurred during redo: " + e.getMessage()), (Throwable)e);
        }
    }

    protected void redoCreateOverflowPage(OverflowCreatePageLoggable loggable) {
        this.createPageHelper(loggable, loggable.newPage);
        if (loggable.prevPage != -1L) {
            try {
                SinglePage page = this.getSinglePageForRedo(null, loggable.prevPage);
                SanityCheck.ASSERT(page != null, "Previous page is null");
                page.getPageHeader().setNextInChain(loggable.newPage);
                page.setDirty(true);
                this.dataCache.add(page);
            }
            catch (IOException e) {
                LOG.warn((Object)("An IOException occurred during redo: " + e.getMessage()), (Throwable)e);
            }
        }
    }

    protected void undoCreateOverflowPage(OverflowCreatePageLoggable loggable) {
        try {
            SinglePage page = this.getSinglePage(loggable.newPage);
            this.dataCache.remove(page);
            page.delete();
            if (loggable.prevPage != -1L) {
                try {
                    page = this.getSinglePage(loggable.prevPage);
                    SanityCheck.ASSERT(page != null, "Previous page is null");
                    page.getPageHeader().setNextInChain(0L);
                    page.setDirty(true);
                    this.dataCache.add(page);
                }
                catch (IOException e) {
                    LOG.warn((Object)("An IOException occurred during redo: " + e.getMessage()), (Throwable)e);
                }
            }
        }
        catch (IOException e) {
            LOG.warn((Object)("An IOException occurred during redo: " + e.getMessage()), (Throwable)e);
        }
    }

    protected void redoAppendOverflow(OverflowAppendLoggable loggable) {
        try {
            SinglePage page = this.getSinglePageForRedo(loggable, loggable.pageNum);
            if (page != null && this.requiresRedo((Loggable)loggable, page)) {
                BFilePageHeader ph = page.getPageHeader();
                loggable.data.copyTo(0, page.getData(), ph.getDataLength(), loggable.chunkSize);
                ph.setDataLength(ph.getDataLength() + loggable.chunkSize);
                ph.setLsn(loggable.getLsn());
                page.setDirty(true);
                this.dataCache.add(page);
            }
        }
        catch (IOException e) {
            LOG.warn((Object)("An IOException occurred during redo: " + e.getMessage()), (Throwable)e);
        }
    }

    protected void undoAppendOverflow(OverflowAppendLoggable loggable) {
        try {
            SinglePage page = this.getSinglePage(loggable.pageNum);
            BFilePageHeader ph = page.getPageHeader();
            ph.setDataLength(ph.getDataLength() - loggable.chunkSize);
            page.setDirty(true);
            this.dataCache.add(page);
        }
        catch (IOException e) {
            LOG.warn((Object)("An IOException occurred during redo: " + e.getMessage()), (Throwable)e);
        }
    }

    protected void redoStoreOverflow(OverflowStoreLoggable loggable) {
        block5: {
            try {
                SinglePage page = this.getSinglePageForRedo(loggable, loggable.pageNum);
                if (page == null || !this.requiresRedo((Loggable)loggable, page)) break block5;
                BFilePageHeader ph = page.getPageHeader();
                try {
                    System.arraycopy(loggable.data, 0, page.getData(), 0, loggable.size);
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    LOG.warn((Object)(loggable.data.length + "; " + page.getData().length + "; " + ph.getDataLength() + "; " + loggable.size));
                    throw e;
                }
                ph.setDataLength(loggable.size);
                ph.setNextInChain(0L);
                ph.setLsn(loggable.getLsn());
                page.setDirty(true);
                this.dataCache.add(page);
                if (loggable.prevPage != -1L) {
                    page = this.getSinglePage(loggable.prevPage);
                    SanityCheck.ASSERT(page != null, "Previous page is null");
                    page.getPageHeader().setNextInChain(loggable.pageNum);
                    page.setDirty(true);
                    this.dataCache.add(page);
                }
            }
            catch (IOException e) {
                LOG.warn((Object)("An IOException occurred during redo: " + e.getMessage()), (Throwable)e);
            }
        }
    }

    protected void redoModifiedOverflow(OverflowModifiedLoggable loggable) {
        try {
            SinglePage page = this.getSinglePageForRedo(loggable, loggable.pageNum);
            if (page != null && this.requiresRedo((Loggable)loggable, page)) {
                BFilePageHeader ph = page.getPageHeader();
                ph.setDataLength(loggable.length);
                ph.setLastInChain(loggable.lastInChain);
                ByteConversion.intToByte(ph.getDataLength() - 6, page.getData(), 2);
                page.setDirty(true);
                this.dataCache.add(page, 2);
            }
        }
        catch (IOException e) {
            LOG.warn((Object)("An IOException occurred during redo: " + e.getMessage()), (Throwable)e);
        }
    }

    protected void undoModifiedOverflow(OverflowModifiedLoggable loggable) {
        try {
            SinglePage page = this.getSinglePage(loggable.pageNum);
            BFilePageHeader ph = page.getPageHeader();
            ph.setDataLength(loggable.oldLength);
            ByteConversion.intToByte(ph.getDataLength() - 6, page.getData(), 2);
            page.setDirty(true);
            this.dataCache.add(page);
        }
        catch (IOException e) {
            LOG.warn((Object)("An IOException occurred during undo: " + e.getMessage()), (Throwable)e);
        }
    }

    protected void redoRemoveOverflow(OverflowRemoveLoggable loggable) {
        try {
            SinglePage wp = (SinglePage)this.dataCache.get(loggable.pageNum);
            if (wp == null) {
                Paged.Page page = this.getPage(loggable.pageNum);
                if (page == null) {
                    LOG.warn((Object)("page " + loggable.pageNum + " not found!"));
                    return;
                }
                byte[] data = page.read();
                if (page.getPageHeader().getStatus() < 20 || this.isUptodate(page, loggable)) {
                    return;
                }
                wp = new SinglePage(page, data, true);
            }
            if (this.requiresRedo((Loggable)loggable, wp)) {
                wp.setDirty(true);
                this.dataCache.remove(wp);
                wp.delete();
            }
        }
        catch (IOException e) {
            LOG.warn((Object)("An IOException occurred during redo: " + e.getMessage()), (Throwable)e);
        }
    }

    protected void undoRemoveOverflow(OverflowRemoveLoggable loggable) {
        DataPage page = this.createPageHelper(null, loggable.pageNum);
        BFilePageHeader ph = page.getPageHeader();
        ph.setStatus(loggable.status);
        ph.setDataLength(loggable.length);
        ph.setNextInChain(loggable.nextInChain);
        page.setData(loggable.data);
        page.setDirty(true);
        this.dataCache.add(page);
    }

    private void storeValueHelper(Loggable loggable, short tid, ByteArray value, SinglePage page) {
        FreeSpace free;
        int len = page.ph.getDataLength();
        ByteConversion.shortToByte(tid, page.data, len);
        page.adjustTID(tid);
        page.setOffset(tid, len += 2);
        ByteConversion.intToByte(value.size(), page.data, len);
        len += 4;
        try {
            value.copyTo(page.data, len);
        }
        catch (RuntimeException e) {
            LOG.warn((Object)(this.getFile().getName() + ": storage error in page: " + page.getPageNum() + "; len: " + len + " ; value: " + value.size() + "; max: " + this.fileHeader.getWorkSize() + "; status: " + page.ph.getStatus()));
            LOG.debug((Object)page.printContents());
            throw e;
        }
        page.ph.setDataLength(len += value.size());
        page.ph.incRecordCount();
        if (loggable != null) {
            page.ph.setLsn(loggable.getLsn());
        }
        if ((free = this.fileHeader.getFreeSpace(page.getPageNum())) == null) {
            free = new FreeSpace(page.getPageNum(), this.fileHeader.getWorkSize() - len);
        }
        this.saveFreeSpace(free, page);
        page.setDirty(true);
        this.dataCache.add(page);
    }

    private void removeValueHelper(Loggable loggable, short tid, SinglePage page) throws IOException {
        int offset = page.findValuePosition(tid);
        if (offset < 0) {
            LOG.warn((Object)("TID: " + tid + " not found on page: " + page.getPageNum()));
            return;
        }
        int l = ByteConversion.byteToInt(page.data, offset);
        int end = offset + 4 + l;
        int len = page.ph.getDataLength();
        System.arraycopy(page.data, end, page.data, offset - 2, len - end);
        page.ph.setDirty(true);
        page.ph.decRecordCount();
        len = len - l - 6;
        page.ph.setDataLength(len);
        if (loggable != null) {
            page.ph.setLsn(loggable.getLsn());
        }
        page.setDirty(true);
        if (len > 0) {
            page.removeTID(tid, l + 6);
            int newFree = this.fileHeader.getWorkSize() - len;
            if (newFree > this.minFree) {
                FreeSpace free = this.fileHeader.getFreeSpace(page.getPageNum());
                if (free == null) {
                    free = new FreeSpace(page.getPageNum(), newFree);
                    this.fileHeader.addFreeSpace(free);
                } else {
                    free.setFree(newFree);
                }
            }
            this.dataCache.add(page, 2);
        }
    }

    private DataPage createPageHelper(Loggable loggable, long newPage) {
        try {
            DataPage dp = (DataPage)this.dataCache.get(newPage);
            if (dp == null) {
                Paged.Page page = this.getPage(newPage);
                byte[] data = page.read();
                if (page.getPageHeader().getLsn() == -1L || this.requiresRedo(loggable, page)) {
                    this.reuseDeleted(page);
                    BFilePageHeader ph = (BFilePageHeader)page.getPageHeader();
                    ph.setStatus((byte)20);
                    ph.setDataLength(0);
                    ph.setDataLen(this.fileHeader.getWorkSize());
                    data = new byte[this.fileHeader.getWorkSize()];
                    ph.nextTID = (short)32;
                    dp = new SinglePage(page, data, true);
                } else {
                    dp = new SinglePage(page, data, true);
                }
            }
            dp.getPageHeader().setLsn(loggable.getLsn());
            dp.setDirty(true);
            this.dataCache.add(dp);
            return dp;
        }
        catch (IOException e) {
            LOG.warn((Object)("An IOException occurred during redo: " + e.getMessage()), (Throwable)e);
            return null;
        }
    }

    static {
        LogEntryTypes.addEntryType((byte)48, CreatePageLoggable.class);
        LogEntryTypes.addEntryType((byte)49, StoreValueLoggable.class);
        LogEntryTypes.addEntryType((byte)50, RemoveValueLoggable.class);
        LogEntryTypes.addEntryType((byte)51, RemoveEmptyPageLoggable.class);
        LogEntryTypes.addEntryType((byte)52, OverflowAppendLoggable.class);
        LogEntryTypes.addEntryType((byte)53, OverflowStoreLoggable.class);
        LogEntryTypes.addEntryType((byte)54, OverflowCreateLoggable.class);
        LogEntryTypes.addEntryType((byte)55, OverflowModifiedLoggable.class);
        LogEntryTypes.addEntryType((byte)56, OverflowCreatePageLoggable.class);
        LogEntryTypes.addEntryType((byte)57, OverflowRemoveLoggable.class);
    }

    private final class SinglePage
    extends DataPage {
        byte[] data;
        Paged.Page page;
        BFilePageHeader ph;
        short[] offsets;

        public SinglePage() throws IOException {
            this(true);
        }

        public SinglePage(boolean compress) throws IOException {
            this.data = null;
            this.offsets = null;
            this.page = BFile.this.getFreePage();
            this.ph = (BFilePageHeader)this.page.getPageHeader();
            this.ph.setStatus((byte)20);
            this.ph.setDirty(true);
            this.ph.setDataLength(0);
            this.data = new byte[BFile.this.fileHeader.getWorkSize()];
            this.offsets = new short[32];
            this.ph.nextTID = (short)32;
            Arrays.fill(this.offsets, (short)-1);
        }

        public SinglePage(Paged.Page p, byte[] data, boolean initialize) throws IOException {
            this.data = null;
            this.offsets = null;
            if (p == null) {
                throw new IOException("illegal page");
            }
            if (p.getPageHeader().getStatus() != 20 && p.getPageHeader().getStatus() != 23) {
                IOException e = new IOException("not a data-page: " + p.getPageHeader().getStatus());
                LOG.debug((Object)("not a data-page: " + p.getPageInfo()), (Throwable)e);
                throw e;
            }
            this.data = data;
            this.page = p;
            this.ph = (BFilePageHeader)this.page.getPageHeader();
            if (initialize) {
                this.offsets = new short[this.ph.nextTID];
                this.readOffsets();
            }
        }

        public final int findValuePosition(short tid) throws IOException {
            return this.offsets[tid];
        }

        private void readOffsets() throws IOException {
            Arrays.fill(this.offsets, (short)-1);
            int dlen = this.ph.getDataLength();
            int pos = 0;
            while (pos < dlen) {
                short tid = ByteConversion.byteToShort(this.data, pos);
                if (tid < 0) {
                    LOG.error((Object)("Invalid tid found: " + tid + "; ignoring rest of page ..."));
                    this.ph.setDataLength(pos);
                    return;
                }
                if (tid >= this.offsets.length) {
                    LOG.error((Object)("Problematic tid found: " + tid + "; trying to recover ..."));
                    short[] t = new short[tid + 1];
                    Arrays.fill(t, (short)-1);
                    System.arraycopy(this.offsets, 0, t, 0, this.offsets.length);
                    this.offsets = t;
                    this.ph.nextTID = (short)(tid + 1);
                }
                this.offsets[tid] = (short)(pos + 2);
                pos = (short)(pos + (ByteConversion.byteToInt(this.data, pos + 2) + 6));
            }
        }

        public short getNextTID() {
            for (short i = 0; i < this.offsets.length; i = (short)(i + 1)) {
                if (this.offsets[i] != -1) continue;
                return i;
            }
            short tid = (short)this.offsets.length;
            short next = (short)(this.ph.nextTID * 2);
            if (next < 0 || next < this.ph.nextTID) {
                return -1;
            }
            short[] t = new short[next];
            Arrays.fill(t, (short)-1);
            System.arraycopy(this.offsets, 0, t, 0, this.offsets.length);
            this.offsets = t;
            this.ph.nextTID = next;
            return tid;
        }

        public void adjustTID(short tid) {
            if (tid >= this.ph.nextTID) {
                short next = (short)(tid * 2);
                short[] t = new short[next];
                Arrays.fill(t, (short)-1);
                System.arraycopy(this.offsets, 0, t, 0, this.offsets.length);
                this.offsets = t;
                this.ph.nextTID = next;
            }
        }

        public void clear() {
            Arrays.fill(this.data, (byte)0);
        }

        private String printContents() {
            StringBuffer buf = new StringBuffer();
            for (int i = 0; i < this.offsets.length; i = (int)((short)(i + 1))) {
                if (this.offsets[i] <= -1) continue;
                buf.append('[').append(i).append(", ").append(this.offsets[i]);
                short len = ByteConversion.byteToShort(this.data, this.offsets[i]);
                buf.append(", ").append(len).append(']');
            }
            return buf.toString();
        }

        public void setOffset(short tid, int offset) {
            this.offsets[tid] = (short)offset;
        }

        public void removeTID(short tid, int length) throws IOException {
            int offset = this.offsets[tid] - 2;
            this.offsets[tid] = -1;
            for (int i = 0; i < this.offsets.length; i = (int)((short)(i + 1))) {
                if (this.offsets[i] <= offset) continue;
                int n = i;
                this.offsets[n] = (short)(this.offsets[n] - length);
            }
        }

        public void delete() throws IOException {
            this.ph.setDataLength(0);
            this.ph.setNextInChain(-1L);
            this.ph.setLastInChain(-1L);
            this.ph.setTID((short)-1);
            this.ph.setRecordCount((short)0);
            this.setReferenceCount(0);
            this.ph.setDirty(true);
            BFile.this.unlinkPages(this.page);
        }

        public SinglePage getFirstPage() {
            return this;
        }

        public byte[] getData() {
            return this.data;
        }

        public BFilePageHeader getPageHeader() {
            return this.ph;
        }

        public String getPageInfo() {
            return this.page.getPageInfo();
        }

        public long getPageNum() {
            return this.page.getPageNum();
        }

        public void setData(byte[] buf) {
            this.data = buf;
        }

        public void write() throws IOException {
            BFile.this.writeValue(this.page, new Value(this.data));
            this.setDirty(false);
        }
    }

    private final class MultiPageInput
    implements VariableByteInput,
    PageInputStream {
        private SinglePage nextPage;
        private int pageLen;
        private short offset = 0;
        private long address = 0L;

        public MultiPageInput() {
        }

        public MultiPageInput(SinglePage first, long address) {
            this.nextPage = first;
            this.offset = (short)6;
            this.pageLen = first.ph.getDataLength();
            if (this.pageLen > BFile.this.fileHeader.getWorkSize()) {
                this.pageLen = BFile.this.fileHeader.getWorkSize();
            }
            BFile.this.dataCache.add(first, 3);
            this.address = address;
        }

        public long getAddress() {
            return this.address;
        }

        public final int read() throws IOException {
            if (this.offset == this.pageLen) {
                this.advance();
            }
            short s = this.offset;
            this.offset = (short)(s + 1);
            return this.nextPage.data[s] & 0xFF;
        }

        public final byte readByte() throws IOException {
            if (this.offset == this.pageLen) {
                this.advance();
            }
            short s = this.offset;
            this.offset = (short)(s + 1);
            return this.nextPage.data[s];
        }

        public final short readShort() throws IOException {
            if (this.offset == this.pageLen) {
                this.advance();
            }
            short s = this.offset;
            this.offset = (short)(s + 1);
            byte b = this.nextPage.data[s];
            short i = (short)(b & 0x7F);
            int shift = 7;
            while ((b & 0x80) != 0) {
                if (this.offset == this.pageLen) {
                    this.advance();
                }
                short s2 = this.offset;
                this.offset = (short)(s2 + 1);
                b = this.nextPage.data[s2];
                i = (short)(i | (b & 0x7F) << shift);
                shift += 7;
            }
            return i;
        }

        public final int readInt() throws IOException {
            if (this.offset == this.pageLen) {
                this.advance();
            }
            short s = this.offset;
            this.offset = (short)(s + 1);
            byte b = this.nextPage.data[s];
            int i = b & 0x7F;
            int shift = 7;
            while ((b & 0x80) != 0) {
                if (this.offset == this.pageLen) {
                    this.advance();
                }
                short s2 = this.offset;
                this.offset = (short)(s2 + 1);
                b = this.nextPage.data[s2];
                i |= (b & 0x7F) << shift;
                shift += 7;
            }
            return i;
        }

        public int readFixedInt() throws IOException {
            if (this.offset == this.pageLen) {
                this.advance();
            }
            if (this.offset + 4 < this.pageLen) {
                short s = this.offset;
                short s2 = this.offset = (short)(s + 1);
                short s3 = this.offset = (short)(s2 + 1);
                short s4 = this.offset = (short)(s3 + 1);
                this.offset = (short)(s4 + 1);
                return this.nextPage.data[s] & 0xFF | (this.nextPage.data[s2] & 0xFF) << 8 | (this.nextPage.data[s3] & 0xFF) << 16 | (this.nextPage.data[s4] & 0xFF) << 24;
            }
            short s = this.offset;
            this.offset = (short)(s + 1);
            int r = this.nextPage.data[s] & 0xFF;
            int shift = 8;
            for (int i = 0; i < 3; ++i) {
                if (this.offset == this.pageLen) {
                    this.advance();
                }
                short s5 = this.offset;
                this.offset = (short)(s5 + 1);
                r |= (this.nextPage.data[s5] & 0xFF) << shift;
                shift += 8;
            }
            return r;
        }

        public final long readLong() throws IOException {
            if (this.offset == this.pageLen) {
                this.advance();
            }
            short s = this.offset;
            this.offset = (short)(s + 1);
            byte b = this.nextPage.data[s];
            long i = b & 0x7F;
            int shift = 7;
            while ((b & 0x80) != 0) {
                if (this.offset == this.pageLen) {
                    this.advance();
                }
                short s2 = this.offset;
                this.offset = (short)(s2 + 1);
                b = this.nextPage.data[s2];
                i |= ((long)b & 0x7FL) << shift;
                shift += 7;
            }
            return i;
        }

        public final void skip(int count) throws IOException {
            for (int i = 0; i < count; ++i) {
                short s;
                do {
                    if (this.offset == this.pageLen) {
                        this.advance();
                    }
                    s = this.offset;
                    this.offset = (short)(s + 1);
                } while ((this.nextPage.data[s] & 0x80) > 0);
            }
        }

        public final void skipBytes(long count) throws IOException {
            for (long i = 0L; i < count; ++i) {
                if (this.offset == this.pageLen) {
                    this.advance();
                }
                this.offset = (short)(this.offset + 1);
            }
        }

        private final void advance() throws IOException {
            long next = this.nextPage.getPageHeader().getNextInChain();
            if (next < 1L) {
                this.pageLen = -1;
                this.offset = 0;
                throw new EOFException();
            }
            try {
                BFile.this.lock.acquire(0);
                this.nextPage = (SinglePage)BFile.this.getDataPage(next, false);
                this.pageLen = this.nextPage.ph.getDataLength();
                this.offset = 0;
                BFile.this.dataCache.add(this.nextPage);
            }
            catch (LockException e) {
                throw new IOException("failed to acquire a read lock on " + BFile.this.getFile().getName());
            }
            finally {
                BFile.this.lock.release(0);
            }
        }

        public final int available() throws IOException {
            if (this.pageLen < 0) {
                return 0;
            }
            int inPage = this.pageLen - this.offset;
            if (inPage == 0) {
                inPage = this.nextPage.getPageHeader().getNextInChain() > 0L ? 1 : 0;
            }
            return inPage;
        }

        public final int read(byte[] data) throws IOException {
            return this.read(data, 0, data.length);
        }

        public final int read(byte[] b, int off, int len) throws IOException {
            if (this.pageLen < 0) {
                return -1;
            }
            for (int i = 0; i < len; ++i) {
                if (this.offset == this.pageLen) {
                    long next = this.nextPage.getPageHeader().getNextInChain();
                    if (next < 1L) {
                        this.pageLen = -1;
                        this.offset = 0;
                        return i;
                    }
                    this.nextPage = (SinglePage)BFile.this.getDataPage(next, false);
                    this.pageLen = this.nextPage.ph.getDataLength();
                    this.offset = 0;
                    BFile.this.dataCache.add(this.nextPage);
                }
                short s = this.offset;
                this.offset = (short)(s + 1);
                b[off + i] = this.nextPage.data[s];
            }
            return len;
        }

        public final String readUTF() throws IOException, EOFException {
            String s;
            int len = this.readInt();
            byte[] data = new byte[len];
            this.read(data);
            try {
                s = new String(data, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                LOG.warn((Object)e);
                s = new String(data);
            }
            return s;
        }

        public final void copyTo(VariableByteOutputStream os) throws IOException {
            byte more;
            do {
                if (this.offset == this.pageLen) {
                    this.advance();
                }
                short s = this.offset;
                this.offset = (short)(s + 1);
                more = this.nextPage.data[s];
                os.writeByte(more);
            } while ((more = (byte)(more & 0x80)) > 0);
        }

        public final void copyTo(VariableByteOutputStream os, int count) throws IOException {
            for (int i = 0; i < count; ++i) {
                byte more;
                do {
                    if (this.offset == this.pageLen) {
                        this.advance();
                    }
                    short s = this.offset;
                    this.offset = (short)(s + 1);
                    more = this.nextPage.data[s];
                    os.writeByte(more);
                } while ((more & 0x200) > 0);
            }
        }

        public void copyRaw(VariableByteOutputStream os, int count) throws IOException {
            int avail;
            for (int i = count; i != 0; i -= avail) {
                if (this.offset == this.pageLen) {
                    this.advance();
                }
                if (i >= (avail = this.pageLen - this.offset)) {
                    os.write(this.nextPage.data, this.offset, avail);
                    this.offset = (short)this.pageLen;
                    continue;
                }
                os.write(this.nextPage.data, this.offset, i);
                this.offset = (short)(this.offset + i);
                break;
            }
        }

        public long position() {
            return StorageAddress.createPointer((int)this.nextPage.getPageNum(), this.offset);
        }

        public void seek(long position) throws IOException {
            int newPage = StorageAddress.pageFromPointer(position);
            short newOffset = StorageAddress.tidFromPointer(position);
            try {
                BFile.this.lock.acquire(0);
                this.nextPage = BFile.this.getSinglePage(newPage);
                this.pageLen = this.nextPage.ph.getDataLength();
                if (this.pageLen > BFile.this.fileHeader.getWorkSize()) {
                    this.pageLen = BFile.this.fileHeader.getWorkSize();
                }
                this.offset = newOffset;
                BFile.this.dataCache.add(this.nextPage);
            }
            catch (LockException e) {
                throw new IOException("failed to acquire a read lock on " + BFile.this.getFile().getName());
            }
            finally {
                BFile.this.lock.release(0);
            }
        }
    }

    private final class SimplePageInput
    extends VariableByteArrayInput
    implements PageInputStream {
        private long address;

        public SimplePageInput() {
            this.address = 0L;
        }

        public SimplePageInput(byte[] data, int start, int len, long address) {
            super(data, start, len);
            this.address = 0L;
            this.address = address;
        }

        public long getAddress() {
            return this.address;
        }

        public long position() {
            return this.position;
        }

        public void seek(long pos) throws IOException {
            this.position = (int)pos;
        }
    }

    public static interface PageInputStream {
        public long getAddress();

        public long position();

        public void seek(long var1) throws IOException;
    }

    private final class OverflowPage
    extends DataPage {
        byte[] data;
        SinglePage firstPage;

        public OverflowPage(Txn transaction) throws IOException {
            this.data = null;
            this.firstPage = new SinglePage(false);
            if (BFile.this.isTransactional && transaction != null) {
                OverflowCreateLoggable loggable = new OverflowCreateLoggable(BFile.this.fileId, transaction, this.firstPage.getPageNum());
                BFile.this.writeToLog(loggable, this.firstPage);
            }
            BFilePageHeader ph = this.firstPage.getPageHeader();
            ph.setStatus((byte)23);
            ph.setNextInChain(0L);
            ph.setLastInChain(0L);
            ph.setDataLength(0);
            this.firstPage.setData(new byte[BFile.this.fileHeader.getWorkSize()]);
            BFile.this.dataCache.add(this.firstPage, 3);
        }

        public OverflowPage(DataPage page) {
            this.data = null;
            this.firstPage = (SinglePage)page;
        }

        public OverflowPage(Paged.Page p, byte[] data) throws IOException {
            this.data = null;
            this.firstPage = new SinglePage(p, data, false);
            this.firstPage.getPageHeader().setStatus((byte)23);
        }

        public void append(Txn transaction, ByteArray chunk) throws IOException {
            AbstractBFileLoggable loggable;
            BFilePageHeader ph = this.firstPage.getPageHeader();
            int newLen = ph.getDataLength() + chunk.size();
            long next = ph.getLastInChain();
            DataPage page = next > 0L ? BFile.this.getDataPage(next, false) : this.firstPage;
            ph = page.getPageHeader();
            int chunkSize = BFile.this.fileHeader.getWorkSize() - ph.getDataLength();
            int chunkLen = chunk.size();
            if (chunkLen < chunkSize) {
                chunkSize = chunkLen;
            }
            if (BFile.this.isTransactional && transaction != null) {
                OverflowAppendLoggable loggable2 = new OverflowAppendLoggable(BFile.this.fileId, transaction, page.getPageNum(), chunk, 0, chunkSize);
                BFile.this.writeToLog(loggable2, page);
            }
            chunk.copyTo(0, page.getData(), ph.getDataLength(), chunkSize);
            if (page != this.firstPage) {
                ph.setDataLength(ph.getDataLength() + chunkSize);
            }
            page.setDirty(true);
            int remaining = chunkLen - chunkSize;
            int current = chunkSize;
            chunkSize = BFile.this.fileHeader.getWorkSize();
            if (remaining > 0) {
                while (remaining > 0) {
                    if (remaining < chunkSize) {
                        chunkSize = remaining;
                    }
                    SinglePage nextPage = BFile.this.createDataPage();
                    if (BFile.this.isTransactional && transaction != null) {
                        loggable = new OverflowCreatePageLoggable(transaction, BFile.this.fileId, nextPage.getPageNum(), page.getPageNum());
                        BFile.this.writeToLog(loggable, nextPage);
                        loggable = new OverflowAppendLoggable(BFile.this.fileId, transaction, nextPage.getPageNum(), chunk, current, chunkSize);
                        BFile.this.writeToLog(loggable, page);
                    }
                    nextPage.setData(new byte[BFile.this.fileHeader.getWorkSize()]);
                    page.getPageHeader().setNextInChain(nextPage.getPageNum());
                    page.setDirty(true);
                    BFile.this.dataCache.add(page);
                    page = nextPage;
                    chunk.copyTo(current, page.getData(), 0, chunkSize);
                    page.setDirty(true);
                    if (page != this.firstPage) {
                        page.getPageHeader().setDataLength(chunkSize);
                    }
                    remaining -= chunkSize;
                    current += chunkSize;
                }
            }
            ph = this.firstPage.getPageHeader();
            if (BFile.this.isTransactional && transaction != null) {
                loggable = new OverflowModifiedLoggable(BFile.this.fileId, transaction, this.firstPage.getPageNum(), ph.getDataLength() + chunkLen, ph.getDataLength(), page == this.firstPage ? 0L : page.getPageNum());
                BFile.this.writeToLog(loggable, page);
            }
            if (page != this.firstPage) {
                BFile.this.dataCache.add(page);
                ph.setLastInChain(page.getPageNum());
            } else {
                ph.setLastInChain(0L);
            }
            ph.setDataLength(newLen);
            ByteConversion.intToByte(this.firstPage.getPageHeader().getDataLength() - 6, this.firstPage.getData(), 2);
            this.firstPage.setDirty(true);
            BFile.this.dataCache.add(this.firstPage, 2);
        }

        public void delete() throws IOException {
            this.delete(null);
        }

        public void delete(Txn transaction) throws IOException {
            long next = this.firstPage.getPageNum();
            SinglePage page = this.firstPage;
            do {
                next = page.ph.getNextInChain();
                if (BFile.this.isTransactional && transaction != null) {
                    int dataLen = page.ph.getDataLength();
                    if (dataLen > BFile.this.fileHeader.getWorkSize()) {
                        dataLen = BFile.this.fileHeader.getWorkSize();
                    }
                    OverflowRemoveLoggable loggable = new OverflowRemoveLoggable(BFile.this.fileId, transaction, page.ph.getStatus(), page.getPageNum(), page.getData(), dataLen, page.ph.getNextInChain());
                    BFile.this.writeToLog(loggable, page);
                }
                page.getPageHeader().setNextInChain(-1L);
                page.setDirty(true);
                BFile.this.dataCache.remove(page);
                page.delete();
                if (next <= 0L) continue;
                page = BFile.this.getSinglePage(next);
            } while (next > 0L);
        }

        public VariableByteInput getDataStream(long pointer) {
            MultiPageInput input = new MultiPageInput(this.firstPage, pointer);
            return input;
        }

        public byte[] getData() throws IOException {
            long next;
            if (this.data != null) {
                return this.data;
            }
            SinglePage page = this.firstPage;
            ByteArrayOutputStream os = new ByteArrayOutputStream(page.getPageHeader().getDataLength());
            do {
                byte[] temp = page.getData();
                next = page.getPageHeader().getNextInChain();
                int len = next > 0L ? BFile.this.fileHeader.getWorkSize() : page.getPageHeader().getDataLength();
                os.write(temp, 0, len);
                if (next <= 0L) continue;
                page = (SinglePage)BFile.this.getDataPage(next, false);
                BFile.this.dataCache.add(page);
            } while (next > 0L);
            this.data = os.toByteArray();
            if (this.data.length != this.firstPage.getPageHeader().getDataLength()) {
                LOG.warn((Object)(BFile.this.getFile().getName() + " read=" + this.data.length + "; expected=" + this.firstPage.getPageHeader().getDataLength()));
            }
            return this.data;
        }

        public SinglePage getFirstPage() {
            return this.firstPage;
        }

        public BFilePageHeader getPageHeader() {
            return this.firstPage.getPageHeader();
        }

        public String getPageInfo() {
            return "MULTI_PAGE: " + this.firstPage.getPageInfo();
        }

        public long getPageNum() {
            return this.firstPage.getPageNum();
        }

        public void setData(byte[] buf) {
            this.setData(null, buf);
        }

        public void setData(Txn transaction, byte[] data) {
            this.data = data;
            try {
                this.write(transaction);
            }
            catch (IOException e) {
                LOG.warn((Object)e);
            }
        }

        public void write() throws IOException {
            this.write(null);
        }

        public void write(Txn transaction) throws IOException {
            SinglePage nextPage;
            AbstractBFileLoggable loggable;
            if (this.data == null) {
                return;
            }
            int chunkSize = BFile.this.fileHeader.getWorkSize();
            int remaining = this.data.length;
            int current = 0;
            long next = 0L;
            SinglePage page = this.firstPage;
            page.getPageHeader().setDataLength(remaining);
            long prevPageNum = -1L;
            while (remaining > 0) {
                if (remaining < chunkSize) {
                    chunkSize = remaining;
                }
                page.clear();
                if (BFile.this.isTransactional && transaction != null) {
                    loggable = new OverflowStoreLoggable(BFile.this.fileId, transaction, page.getPageNum(), prevPageNum, this.data, current, chunkSize);
                    BFile.this.writeToLog(loggable, page);
                }
                System.arraycopy(this.data, current, page.getData(), 0, chunkSize);
                if (page != this.firstPage) {
                    page.getPageHeader().setDataLength(chunkSize);
                }
                page.setDirty(true);
                current += chunkSize;
                next = page.getPageHeader().getNextInChain();
                if ((remaining -= chunkSize) > 0) {
                    if (next > 0L) {
                        nextPage = (SinglePage)BFile.this.getDataPage(next, false);
                        BFile.this.dataCache.add(page);
                        prevPageNum = page.getPageNum();
                        page = nextPage;
                        continue;
                    }
                    nextPage = BFile.this.createDataPage();
                    if (BFile.this.isTransactional && transaction != null) {
                        loggable = new CreatePageLoggable(transaction, BFile.this.fileId, nextPage.getPageNum());
                        BFile.this.writeToLog(loggable, nextPage);
                    }
                    nextPage.setData(new byte[BFile.this.fileHeader.getWorkSize()]);
                    nextPage.getPageHeader().setNextInChain(0L);
                    page.getPageHeader().setNextInChain(nextPage.getPageNum());
                    BFile.this.dataCache.add(page);
                    prevPageNum = page.getPageNum();
                    page = nextPage;
                    continue;
                }
                page.getPageHeader().setNextInChain(0L);
                if (page != this.firstPage) {
                    page.setDirty(true);
                    BFile.this.dataCache.add(page);
                    this.firstPage.getPageHeader().setLastInChain(page.getPageNum());
                } else {
                    this.firstPage.getPageHeader().setLastInChain(0L);
                }
                this.firstPage.setDirty(true);
                BFile.this.dataCache.add(this.firstPage, 3);
            }
            if (next > 0L) {
                while (next > 0L) {
                    nextPage = (SinglePage)BFile.this.getDataPage(next, false);
                    next = nextPage.getPageHeader().getNextInChain();
                    if (BFile.this.isTransactional && transaction != null) {
                        loggable = new OverflowRemoveLoggable(BFile.this.fileId, transaction, nextPage.getPageHeader().getStatus(), nextPage.getPageNum(), nextPage.getData(), nextPage.getPageHeader().getDataLength(), nextPage.getPageHeader().getNextInChain());
                        BFile.this.writeToLog(loggable, nextPage);
                    }
                    nextPage.setDirty(true);
                    nextPage.delete();
                    BFile.this.dataCache.remove(nextPage);
                }
            }
            this.firstPage.getPageHeader().setDataLength(this.data.length);
            this.firstPage.setDirty(true);
            BFile.this.dataCache.add(this.firstPage, 3);
        }

        public int findValuePosition(short tid) throws IOException {
            return 2;
        }

        public short getNextTID() {
            return 1;
        }

        public void removeTID(short tid, int length) {
        }

        public void setOffset(short tid, int offset) {
        }
    }

    private final class FindCallback
    implements BTreeCallback {
        public static final int BOTH = 2;
        public static final int KEYS = 1;
        public static final int VALUES = 0;
        private int mode = 0;
        private IndexCallback callback = null;
        private ArrayList values = null;

        public FindCallback(int mode) {
            this.mode = mode;
            this.values = new ArrayList();
        }

        public FindCallback(IndexCallback callback) {
            this.mode = 2;
            this.callback = callback;
        }

        public ArrayList getValues() {
            return this.values;
        }

        public boolean indexInfo(Value value, long pointer) throws TerminatedException {
            try {
                switch (this.mode) {
                    case 0: {
                        long pos = StorageAddress.pageFromPointer(pointer);
                        short tid = StorageAddress.tidFromPointer(pointer);
                        DataPage page = BFile.this.getDataPage(pos);
                        BFile.this.dataCache.add(page.getFirstPage());
                        int offset = page.findValuePosition(tid);
                        byte[] data = page.getData();
                        int l = ByteConversion.byteToInt(data, offset);
                        Value v = new Value(data, offset + 4, l);
                        v.setAddress(pointer);
                        if (this.callback != null) {
                            return this.callback.indexInfo(value, v);
                        }
                        this.values.add(v);
                        return true;
                    }
                    case 1: {
                        value.setAddress(pointer);
                        if (this.callback != null) {
                            return this.callback.indexInfo(value, null);
                        }
                        this.values.add(value);
                        return true;
                    }
                    case 2: {
                        byte[] data;
                        Value[] entry = new Value[2];
                        entry[0] = value;
                        long pos = StorageAddress.pageFromPointer(pointer);
                        short tid = StorageAddress.tidFromPointer(pointer);
                        DataPage page = BFile.this.getDataPage(pos);
                        if (page.getPageHeader().getStatus() == 23) {
                            data = page.getData();
                        }
                        BFile.this.dataCache.add(page.getFirstPage());
                        int offset = page.findValuePosition(tid);
                        data = page.getData();
                        int l = ByteConversion.byteToInt(data, offset);
                        Value v = new Value(data, offset + 4, l);
                        v.setAddress(pointer);
                        entry[1] = v;
                        if (this.callback != null) {
                            return this.callback.indexInfo(value, v);
                        }
                        this.values.add(entry);
                        return true;
                    }
                }
            }
            catch (IOException e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
            return false;
        }
    }

    private final class FilterCallback
    implements BTreeCallback {
        BFileCallback callback;

        public FilterCallback(BFileCallback callback) {
            this.callback = callback;
        }

        public boolean indexInfo(Value value, long pointer) throws TerminatedException {
            try {
                long pos = StorageAddress.pageFromPointer(pointer);
                short tid = StorageAddress.tidFromPointer(pointer);
                DataPage page = BFile.this.getDataPage(pos);
                int offset = page.findValuePosition(tid);
                byte[] data = page.getData();
                int l = ByteConversion.byteToInt(data, offset);
                Value v = new Value(data, offset + 4, l);
                this.callback.info(value, v);
                return true;
            }
            catch (IOException e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
                return true;
            }
        }
    }

    private abstract class DataPage
    implements Comparable,
    Cacheable {
        int refCount = 0;
        int timestamp = 0;
        boolean saved = true;

        private DataPage() {
        }

        public abstract void delete() throws IOException;

        public abstract byte[] getData() throws IOException;

        public abstract BFilePageHeader getPageHeader();

        public abstract String getPageInfo();

        public abstract long getPageNum();

        public abstract int findValuePosition(short var1) throws IOException;

        public abstract short getNextTID();

        public abstract void removeTID(short var1, int var2) throws IOException;

        public abstract void setOffset(short var1, int var2);

        public long getKey() {
            return this.getPageNum();
        }

        public int getReferenceCount() {
            return this.refCount;
        }

        public int incReferenceCount() {
            if (this.refCount < 10000) {
                ++this.refCount;
            }
            return this.refCount;
        }

        public int decReferenceCount() {
            return this.refCount > 0 ? (this.refCount = this.refCount - 1) : 0;
        }

        public void setReferenceCount(int count) {
            this.refCount = count;
        }

        public void setTimestamp(int timestamp) {
            this.timestamp = timestamp;
        }

        public int getTimestamp() {
            return this.timestamp;
        }

        public boolean sync(boolean syncJournal) {
            if (this.isDirty()) {
                try {
                    this.write();
                    if (BFile.this.isTransactional && syncJournal && BFile.this.logManager.lastWrittenLsn() < this.getPageHeader().getLsn()) {
                        BFile.this.logManager.flushToLog(true);
                    }
                    return true;
                }
                catch (IOException e) {
                    LOG.error((Object)("IO exception occurred while saving page " + this.getPageNum()));
                }
            }
            return false;
        }

        public boolean isDirty() {
            return !this.saved;
        }

        public boolean allowUnload() {
            return true;
        }

        public abstract void setData(byte[] var1);

        public abstract SinglePage getFirstPage();

        public void setDirty(boolean dirty) {
            this.saved = !dirty;
            this.getPageHeader().setDirty(dirty);
        }

        public abstract void write() throws IOException;

        public int compareTo(Object other) {
            if (this.getPageNum() == ((DataPage)other).getPageNum()) {
                return 0;
            }
            if (this.getPageNum() > ((DataPage)other).getPageNum()) {
                return 1;
            }
            return -1;
        }
    }

    private final class BFilePageHeader
    extends BTree.BTreePageHeader {
        private int dataLen;
        private long lastInChain;
        private long nextInChain;
        private short nextTID;
        private short records;

        public BFilePageHeader() {
            this.dataLen = 0;
            this.lastInChain = -1L;
            this.nextInChain = -1L;
            this.nextTID = (short)-1;
            this.records = 0;
        }

        public BFilePageHeader(byte[] data, int offset) throws IOException {
            super(data, offset);
            this.dataLen = 0;
            this.lastInChain = -1L;
            this.nextInChain = -1L;
            this.nextTID = (short)-1;
            this.records = 0;
        }

        public void decRecordCount() {
            this.records = (short)(this.records - 1);
        }

        public int getDataLength() {
            return this.dataLen;
        }

        public long getLastInChain() {
            return this.lastInChain;
        }

        public long getNextInChain() {
            return this.nextInChain;
        }

        public short getNextTID() {
            if (this.nextTID == Short.MAX_VALUE) {
                LOG.warn((Object)"tid limit reached");
                return -1;
            }
            this.nextTID = (short)(this.nextTID + 1);
            return this.nextTID;
        }

        public short getCurrentTID() {
            if (this.nextTID == Short.MAX_VALUE) {
                return -1;
            }
            return this.nextTID;
        }

        public short getRecordCount() {
            return this.records;
        }

        public void incRecordCount() {
            this.records = (short)(this.records + 1);
        }

        public int read(byte[] data, int offset) throws IOException {
            offset = super.read(data, offset);
            this.records = ByteConversion.byteToShort(data, offset);
            this.dataLen = ByteConversion.byteToInt(data, offset += 2);
            this.nextTID = ByteConversion.byteToShort(data, offset += 4);
            this.nextInChain = ByteConversion.byteToLong(data, offset += 2);
            this.lastInChain = ByteConversion.byteToLong(data, offset += 8);
            return offset + 8;
        }

        public void setDataLength(int len) {
            this.dataLen = len;
        }

        public void setLastInChain(long p) {
            this.lastInChain = p;
        }

        public void setNextInChain(long b) {
            this.nextInChain = b;
        }

        public void setRecordCount(short recs) {
            this.records = recs;
        }

        public void setTID(short tid) {
            this.nextTID = tid;
        }

        public int write(byte[] data, int offset) throws IOException {
            offset = super.write(data, offset);
            ByteConversion.shortToByte(this.records, data, offset);
            ByteConversion.intToByte(this.dataLen, data, offset += 2);
            ByteConversion.shortToByte(this.nextTID, data, offset += 4);
            ByteConversion.longToByte(this.nextInChain, data, offset += 2);
            ByteConversion.longToByte(this.lastInChain, data, offset += 8);
            return offset + 8;
        }
    }

    private final class BFileHeader
    extends BTree.BTreeFileHeader {
        private FreeList freeList;
        public static final int MAX_FREE_LIST_LEN = 128;

        public BFileHeader(int pageSize) {
            super(pageSize);
            this.freeList = new FreeList();
        }

        public void addFreeSpace(FreeSpace freeSpace) {
            this.freeList.add(freeSpace);
            this.setDirty(true);
        }

        public FreeSpace findFreeSpace(int needed) {
            return this.freeList.find(needed);
        }

        public FreeSpace getFreeSpace(long page) {
            return this.freeList.retrieve(page);
        }

        public void removeFreeSpace(FreeSpace space) {
            if (space == null) {
                return;
            }
            this.freeList.remove(space);
            this.setDirty(true);
        }

        public void debugFreeList() {
            LOG.debug((Object)(BFile.this.getFile().getName() + ": " + this.freeList.toString()));
        }

        public int read(byte[] buf) throws IOException {
            int offset = super.read(buf);
            return this.freeList.read(buf, offset);
        }

        public int write(byte[] buf) throws IOException {
            int offset = super.write(buf);
            return this.freeList.write(buf, offset);
        }
    }

    private class RemoveCallback
    implements BTreeCallback {
        long[] pointers = new long[128];
        int count = 0;

        private RemoveCallback() {
        }

        public boolean indexInfo(Value value, long pointer) throws TerminatedException {
            if (this.count == this.pointers.length) {
                long[] np = new long[this.count * 2];
                System.arraycopy(this.pointers, 0, np, 0, this.count);
                this.pointers = np;
            }
            this.pointers[this.count++] = pointer;
            return true;
        }
    }
}

