/*
 * Decompiled with CFR 0.152.
 */
package org.exist.storage.index;

import java.nio.ByteBuffer;
import org.exist.storage.DBBroker;
import org.exist.storage.index.AbstractBFileLoggable;
import org.exist.storage.journal.LogException;
import org.exist.storage.txn.Txn;

public class RemoveValueLoggable
extends AbstractBFileLoggable {
    protected long page;
    protected short tid;
    protected byte[] oldData;
    protected int offset = 0;
    protected int len;

    public RemoveValueLoggable(Txn transaction, byte fileId, long page, short tid, byte[] oldData, int offset, int len) {
        super((byte)50, fileId, transaction);
        this.page = page;
        this.tid = tid;
        this.oldData = oldData;
        this.offset = offset;
        this.len = len;
    }

    public RemoveValueLoggable(DBBroker broker, long transactionId) {
        super(broker, transactionId);
    }

    public void write(ByteBuffer out) {
        super.write(out);
        out.putInt((int)this.page);
        out.putShort(this.tid);
        out.putShort((short)this.len);
        out.put(this.oldData, this.offset, this.len);
    }

    public void read(ByteBuffer in) {
        super.read(in);
        this.page = in.getInt();
        this.tid = in.getShort();
        this.len = in.getShort();
        this.oldData = new byte[this.len];
        in.get(this.oldData);
    }

    public int getLogSize() {
        return super.getLogSize() + this.len + 8;
    }

    public void redo() throws LogException {
        this.getIndexFile().redoRemoveValue(this);
    }

    public void undo() throws LogException {
        this.getIndexFile().undoRemoveValue(this);
    }

    public String dump() {
        return super.dump() + " - remove value with tid " + this.tid + " from page " + this.page;
    }
}

