/*
 * Decompiled with CFR 0.152.
 */
package org.exist.storage.journal;

import java.lang.reflect.Constructor;
import org.exist.storage.DBBroker;
import org.exist.storage.journal.LogException;
import org.exist.storage.journal.Loggable;
import org.exist.storage.txn.Checkpoint;
import org.exist.storage.txn.TxnAbort;
import org.exist.storage.txn.TxnCommit;
import org.exist.storage.txn.TxnStart;
import org.exist.util.hashtable.Int2ObjectHashMap;

public class LogEntryTypes {
    public static final byte TXN_START = 0;
    public static final byte TXN_COMMIT = 1;
    public static final byte CHECKPOINT = 2;
    public static final byte TXN_ABORT = 3;
    private static final Int2ObjectHashMap entryTypes = new Int2ObjectHashMap();
    static /* synthetic */ Class class$org$exist$storage$DBBroker;

    public static final void addEntryType(byte type, Class clazz) {
        LogEntry entry = new LogEntry(type, clazz);
        entryTypes.put(type, entry);
    }

    public static final Loggable create(byte type, DBBroker broker, long transactId) throws LogException {
        LogEntry entry = (LogEntry)entryTypes.get(type);
        if (entry == null) {
            return null;
        }
        try {
            return entry.newInstance(broker, transactId);
        }
        catch (Exception e) {
            throw new LogException("Failed to create log entry object", e);
        }
    }

    static {
        LogEntryTypes.addEntryType((byte)0, TxnStart.class);
        LogEntryTypes.addEntryType((byte)1, TxnCommit.class);
        LogEntryTypes.addEntryType((byte)2, Checkpoint.class);
        LogEntryTypes.addEntryType((byte)3, TxnAbort.class);
    }

    private static class LogEntry {
        private static Class[] constructorArgs = new Class[]{class$org$exist$storage$DBBroker == null ? (class$org$exist$storage$DBBroker = LogEntryTypes.class$("org.exist.storage.DBBroker")) : class$org$exist$storage$DBBroker, Long.TYPE};
        private byte type;
        private Class clazz;

        public LogEntry(byte type, Class myClass) {
            this.type = type;
            this.clazz = myClass;
        }

        public Loggable newInstance(DBBroker broker, long transactId) throws Exception {
            Constructor constructor = this.clazz.getConstructor(constructorArgs);
            return (Loggable)constructor.newInstance(broker, new Long(transactId));
        }
    }
}

