/*
 * Decompiled with CFR 0.152.
 */
package org.exist.storage.report;

import java.util.Iterator;
import org.exist.storage.BrokerPool;
import org.exist.storage.BufferStats;
import org.exist.storage.dom.DOMFile;
import org.exist.storage.index.BFile;
import org.exist.util.Configuration;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class XMLStatistics {
    public static final String NAMESPACE = "http://exist.sourceforge.net/generators/status";
    public static final String PREFIX = "status";
    public ContentHandler contentHandler;

    public XMLStatistics(ContentHandler contentHandler) {
        this.contentHandler = contentHandler;
    }

    public void genInstanceStatus() throws SAXException {
        AttributesImpl atts = new AttributesImpl();
        atts.addAttribute("", "default", "default", "CDATA", "exist");
        this.contentHandler.startElement(NAMESPACE, "database-instances", "status:database-instances", atts);
        atts.clear();
        Iterator i = BrokerPool.getInstances();
        while (i.hasNext()) {
            BrokerPool instance = (BrokerPool)i.next();
            atts.addAttribute("", "name", "name", "CDATA", instance.getId());
            this.contentHandler.startElement(NAMESPACE, "database-instance", "status:database-instance", atts);
            atts.clear();
            this.addValue("configuration", instance.getConfiguration().getConfigFilePath());
            this.addValue("data-directory", (String)instance.getConfiguration().getProperty("db-connection.data-dir"));
            this.addValue("cache-size", String.valueOf(instance.getConfiguration().getInteger("db-connection.cache-size")));
            this.addValue("page-size", String.valueOf(instance.getConfiguration().getInteger("db-connection.page-size")));
            this.addValue("collection-cache-mem", String.valueOf(instance.getConfiguration().getInteger("db-connection.collection-cache-mem")));
            this.contentHandler.startElement(NAMESPACE, "pool", "status:pool", atts);
            this.addValue("max", String.valueOf(instance.getMax()));
            this.addValue("active", String.valueOf(instance.active()));
            this.addValue("available", String.valueOf(instance.available()));
            this.contentHandler.endElement(NAMESPACE, "pool", "status:pool");
            this.genBufferStatus(instance);
            this.contentHandler.endElement(NAMESPACE, "database-instance", "status:database-instance");
        }
        this.contentHandler.endElement(NAMESPACE, "database-instances", "status:database-instances");
    }

    private void genBufferStatus(BrokerPool instance) throws SAXException {
        AttributesImpl atts = new AttributesImpl();
        this.contentHandler.startElement(NAMESPACE, "buffers", "status:buffers", atts);
        Configuration conf = instance.getConfiguration();
        BFile db = (BFile)conf.getProperty("db-connection.collections");
        this.genBufferDetails(db.getIndexBufferStats(), db.getDataBufferStats(), "Collections storage (" + db.getFile().getName() + ")");
        DOMFile dom = (DOMFile)conf.getProperty("db-connection.dom");
        this.genBufferDetails(dom.getIndexBufferStats(), dom.getDataBufferStats(), "Resource storage (" + dom.getFile().getName() + ")");
        db = (BFile)conf.getProperty("db-connection.elements");
        this.genBufferDetails(db.getIndexBufferStats(), db.getDataBufferStats(), "Structural index (" + db.getFile().getName() + ")");
        db = (BFile)conf.getProperty("db-connection.values");
        if (db != null) {
            this.genBufferDetails(db.getIndexBufferStats(), db.getDataBufferStats(), "Values index (" + db.getFile().getName() + ")");
        }
        if ((db = (BFile)conf.getProperty("db-connection.words")) != null) {
            this.genBufferDetails(db.getIndexBufferStats(), db.getDataBufferStats(), "Fulltext index (" + db.getFile().getName() + ")");
        }
        this.contentHandler.endElement(NAMESPACE, "buffers", "status:buffers");
    }

    private void genBufferDetails(BufferStats index, BufferStats data, String name) throws SAXException {
        AttributesImpl atts = new AttributesImpl();
        atts.addAttribute("", "name", "name", "CDATA", name);
        this.contentHandler.startElement(NAMESPACE, "file", "status:file", atts);
        atts.clear();
        atts.addAttribute("", "type", "type", "CDATA", "btree");
        this.contentHandler.startElement(NAMESPACE, "buffer", "status:buffer", atts);
        atts.clear();
        this.addValue("size", String.valueOf(index.getSize()));
        this.addValue("used", String.valueOf(index.getUsed()));
        this.addValue("hits", String.valueOf(index.getPageHits()));
        this.addValue("fails", String.valueOf(index.getPageFails()));
        this.contentHandler.endElement(NAMESPACE, "buffer", "status:buffer");
        atts.addAttribute("", "type", "type", "CDATA", "data");
        this.contentHandler.startElement(NAMESPACE, "buffer", "status:buffer", atts);
        atts.clear();
        this.addValue("size", String.valueOf(data.getSize()));
        this.addValue("used", String.valueOf(data.getUsed()));
        this.addValue("hits", String.valueOf(data.getPageHits()));
        this.addValue("fails", String.valueOf(data.getPageFails()));
        this.contentHandler.endElement(NAMESPACE, "buffer", "status:buffer");
        this.contentHandler.endElement(NAMESPACE, "file", "status:file");
    }

    public void addValue(String elem, String value) throws SAXException {
        AttributesImpl atts = new AttributesImpl();
        this.contentHandler.startElement(NAMESPACE, elem, "status:" + elem, atts);
        this.contentHandler.characters(value.toCharArray(), 0, value.length());
        this.contentHandler.endElement(NAMESPACE, elem, "status:" + elem);
    }

    public void setContentHandler(ContentHandler contentHandler) {
        this.contentHandler = contentHandler;
    }
}

