/*
 * Decompiled with CFR 0.152.
 */
package org.exist.storage.serializers;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;
import org.exist.dom.BinaryDocument;
import org.exist.dom.DocumentImpl;
import org.exist.dom.QName;
import org.exist.dom.StoredNode;
import org.exist.security.PermissionDeniedException;
import org.exist.security.xacml.AccessContext;
import org.exist.source.AbstractSource;
import org.exist.source.DBSource;
import org.exist.source.StringSource;
import org.exist.storage.XQueryPool;
import org.exist.storage.serializers.Serializer;
import org.exist.util.serializer.AttrList;
import org.exist.util.serializer.Receiver;
import org.exist.xmldb.XmldbURI;
import org.exist.xquery.CompiledXQuery;
import org.exist.xquery.Expression;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQuery;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.util.ExpressionDumper;
import org.exist.xquery.value.NodeValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceIterator;
import org.exist.xquery.value.Type;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class XIncludeFilter
implements Receiver {
    private static final Logger LOG = Logger.getLogger((Class)XIncludeFilter.class);
    public static final String XINCLUDE_NS = "http://www.w3.org/2001/XInclude";
    private static final QName HREF_ATTRIB = new QName("href", "");
    private static final QName XPOINTER_ATTRIB = new QName("xpointer", "");
    private static final String XI_INCLUDE = "include";
    private static final String XI_FALLBACK = "fallback";
    private Receiver receiver;
    private Serializer serializer;
    private DocumentImpl document = null;
    private HashMap namespaces = new HashMap(10);
    private boolean inFallback = false;
    private ResourceError error = null;

    public XIncludeFilter(Serializer serializer, Receiver receiver) {
        this.receiver = receiver;
        this.serializer = serializer;
    }

    public XIncludeFilter(Serializer serializer) {
        this(serializer, null);
    }

    public void setReceiver(Receiver handler) {
        this.receiver = handler;
    }

    public Receiver getReceiver() {
        return this.receiver;
    }

    public void setDocument(DocumentImpl doc) {
        this.document = doc;
        this.inFallback = false;
        this.error = null;
    }

    public void characters(CharSequence seq) throws SAXException {
        if (!this.inFallback || this.error != null) {
            this.receiver.characters(seq);
        }
    }

    public void comment(char[] ch, int start, int length) throws SAXException {
        if (!this.inFallback || this.error != null) {
            this.receiver.comment(ch, start, length);
        }
    }

    public void endDocument() throws SAXException {
        this.receiver.endDocument();
    }

    public void endElement(QName qname) throws SAXException {
        if (XINCLUDE_NS.equals(qname.getNamespaceURI())) {
            if (XI_FALLBACK.equals(qname.getLocalName())) {
                this.inFallback = false;
                this.error = null;
            } else if (XI_INCLUDE.equals(qname.getLocalName()) && this.error != null) {
                ResourceError e = this.error;
                this.error = null;
                throw new SAXException(e.getMessage(), e);
            }
        } else if (!this.inFallback || this.error != null) {
            this.receiver.endElement(qname);
        }
    }

    public void endPrefixMapping(String prefix) throws SAXException {
        this.namespaces.remove(prefix);
        this.receiver.endPrefixMapping(prefix);
    }

    public void processingInstruction(String target, String data) throws SAXException {
        if (!this.inFallback || this.error != null) {
            this.receiver.processingInstruction(target, data);
        }
    }

    public void cdataSection(char[] ch, int start, int len) throws SAXException {
        if (!this.inFallback || this.error != null) {
            this.receiver.cdataSection(ch, start, len);
        }
    }

    public void startDocument() throws SAXException {
        this.receiver.startDocument();
    }

    public void attribute(QName qname, String value) throws SAXException {
        if (!this.inFallback || this.error != null) {
            this.receiver.attribute(qname, value);
        }
    }

    public void startElement(QName qname, AttrList attribs) throws SAXException {
        if (qname.getNamespaceURI() != null && qname.getNamespaceURI().equals(XINCLUDE_NS)) {
            if (qname.getLocalName().equals(XI_INCLUDE)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"processing include ...");
                }
                try {
                    this.processXInclude(attribs.getValue(HREF_ATTRIB), attribs.getValue(XPOINTER_ATTRIB));
                }
                catch (ResourceError resourceError) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)resourceError.getMessage(), (Throwable)resourceError);
                    }
                    this.error = resourceError;
                }
            } else if (qname.getLocalName().equals(XI_FALLBACK)) {
                this.inFallback = true;
            }
        } else if (!this.inFallback || this.error != null) {
            this.receiver.startElement(qname, attribs);
        }
    }

    public void documentType(String name, String publicId, String systemId) throws SAXException {
        this.receiver.documentType(name, publicId, systemId);
    }

    public void highlightText(CharSequence seq) {
    }

    protected void processXInclude(String href, String xpointer) throws SAXException, ResourceError {
        if (href == null) {
            throw new SAXException("No href attribute found in XInclude include element");
        }
        DocumentImpl prevDoc = this.document;
        boolean createContainerElements = this.serializer.createContainerElements;
        this.serializer.createContainerElements = false;
        XmldbURI docUri = null;
        try {
            docUri = XmldbURI.xmldbUriFor(href);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Stylesheet URI could not be parsed: " + e.getMessage());
        }
        LOG.debug((Object)("found href=\"" + href + "\""));
        String fragment = docUri.getFragment();
        if (fragment != null && fragment.length() != 0) {
            throw new SAXException("Fragment identifiers must not be used in an xinclude href attribute. To specify an xpointer, use the xpointer attribute.");
        }
        HashMap params = null;
        String paramStr = docUri.getQuery();
        if (paramStr != null) {
            params = this.processParameters(paramStr);
            docUri = XmldbURI.create(docUri.getRawCollectionPath());
        }
        if (!docUri.isAbsolute()) {
            String base = this.document.getCollection().getURI() + "/";
            String child = "./" + docUri.toString();
            URI baseUri = URI.create(base);
            URI childUri = URI.create(child);
            URI uri = baseUri.resolve(childUri);
            docUri = XmldbURI.create(uri);
        }
        DocumentImpl doc = null;
        try {
            doc = (DocumentImpl)this.serializer.broker.getXMLResource(docUri);
            if (doc != null && !doc.getPermissions().validate(this.serializer.broker.getUser(), 4)) {
                throw new ResourceError("Permission denied to read xincluded resource");
            }
        }
        catch (PermissionDeniedException e) {
            LOG.warn((Object)"permission denied", (Throwable)e);
            throw new ResourceError("Permission denied to read xincluded resource", e);
        }
        if (doc == null && xpointer == null) {
            throw new ResourceError("document " + docUri + " not found");
        }
        boolean xqueryDoc = false;
        if (doc != null && doc.getResourceType() == 1) {
            xqueryDoc = "application/xquery".equals(doc.getMetadata().getMimeType());
        }
        if (xpointer == null && !xqueryDoc) {
            this.serializer.serializeToReceiver(doc, false);
        } else {
            try {
                AbstractSource source;
                if (xpointer == null) {
                    source = new DBSource(this.serializer.broker, (BinaryDocument)doc, true);
                } else {
                    xpointer = this.checkNamespaces(xpointer);
                    source = new StringSource(xpointer);
                }
                XQuery xquery = this.serializer.broker.getXQueryService();
                XQueryPool pool = xquery.getXQueryPool();
                CompiledXQuery compiled = pool.borrowCompiledXQuery(this.serializer.broker, source);
                XQueryContext context = compiled != null ? compiled.getContext() : xquery.newContext(AccessContext.XINCLUDE);
                context.declareNamespaces(this.namespaces);
                context.declareNamespace("xinclude", XINCLUDE_NS);
                if (this.document != null) {
                    context.declareVariable("xinclude:current-doc", this.document.getFileURI().toString());
                    context.declareVariable("xinclude:current-collection", this.document.getCollection().getURI().toString());
                }
                if (xpointer != null) {
                    if (doc != null) {
                        context.setStaticallyKnownDocuments(new XmldbURI[]{doc.getURI()});
                    } else {
                        context.setStaticallyKnownDocuments(new XmldbURI[]{docUri});
                    }
                }
                if (params != null) {
                    Iterator i = params.entrySet().iterator();
                    while (i.hasNext()) {
                        Map.Entry entry = i.next();
                        context.declareVariable(entry.getKey().toString(), entry.getValue());
                    }
                }
                if (compiled == null) {
                    try {
                        compiled = xquery.compile(context, source, xpointer != null);
                    }
                    catch (IOException e) {
                        throw new SAXException("I/O error while reading query for xinclude: " + e.getMessage(), e);
                    }
                }
                LOG.info((Object)("xpointer query: " + ExpressionDumper.dump((Expression)((Object)compiled))));
                Sequence seq = xquery.execute(compiled, null);
                if (Type.subTypeOf(seq.getItemType(), -1)) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("xpointer found: " + seq.getItemCount()));
                    }
                    SequenceIterator i = seq.iterate();
                    while (i.hasNext()) {
                        NodeValue node = (NodeValue)i.nextItem();
                        this.serializer.serializeToReceiver(node, false);
                    }
                } else {
                    for (int i = 0; i < seq.getItemCount(); ++i) {
                        String val = seq.itemAt(i).getStringValue();
                        this.characters(val);
                    }
                }
            }
            catch (XPathException e) {
                LOG.warn((Object)"xpointer error", (Throwable)e);
                throw new SAXException("Error while processing XInclude expression: " + e.getMessage(), e);
            }
        }
        this.document = prevDoc;
        this.serializer.createContainerElements = createContainerElements;
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        this.namespaces.put(prefix, uri);
        this.receiver.startPrefixMapping(prefix, uri);
    }

    private String checkNamespaces(String xpointer) throws XPathException {
        int p0;
        while ((p0 = xpointer.indexOf("xmlns(")) != -1) {
            if (p0 < 0) {
                return xpointer;
            }
            int p1 = xpointer.indexOf(41, p0 + 6);
            if (p1 < 0) {
                throw new XPathException("expected ) for xmlns()");
            }
            String mapping = xpointer.substring(p0 + 6, p1);
            xpointer = xpointer.substring(0, p0) + xpointer.substring(p1 + 1);
            StringTokenizer tok = new StringTokenizer(mapping, "= \t\n");
            if (tok.countTokens() < 2) {
                throw new XPathException("expected prefix=namespace mapping in " + mapping);
            }
            String prefix = tok.nextToken();
            String namespaceURI = tok.nextToken();
            this.namespaces.put(prefix, namespaceURI);
        }
        return xpointer;
    }

    protected HashMap processParameters(String args) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        int start = 0;
        int end = 0;
        int l = args.length();
        while (start < l && end < l) {
            while (end < l && args.charAt(end++) != '=') {
            }
            if (end == l) break;
            String param = args.substring(start, end - 1);
            start = end;
            while (end < l && args.charAt(end++) != '&') {
            }
            String value = end == l ? args.substring(start) : args.substring(start, end - 1);
            start = end;
            try {
                param = URLDecoder.decode(param, "UTF-8");
                value = URLDecoder.decode(value, "UTF-8");
                LOG.debug((Object)("parameter: " + param + " = " + value));
                parameters.put(param, value);
            }
            catch (UnsupportedEncodingException e) {
                LOG.warn((Object)e.getMessage(), (Throwable)e);
            }
        }
        return parameters;
    }

    public void setCurrentNode(StoredNode node) {
    }

    public Document getDocument() {
        return null;
    }

    private static class ResourceError
    extends Exception {
        private ResourceError(String message, Throwable cause) {
            super(message, cause);
        }

        private ResourceError(String message) {
            super(message);
        }
    }
}

