/*
 * Decompiled with CFR 0.152.
 */
package org.exist.util;

import org.exist.util.FastStringBuffer;

public final class Base64Encoder {
    private FastStringBuffer out = new FastStringBuffer(256);
    private int buf = 0;
    private int buf_bytes = 0;
    private char[] line = new char[74];
    private int line_length = 0;
    private static final char[] map = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};

    private void encode_token() {
        int i = this.line_length;
        this.line[i] = map[0x3F & this.buf >> 18];
        this.line[i + 1] = map[0x3F & this.buf >> 12];
        this.line[i + 2] = map[0x3F & this.buf >> 6];
        this.line[i + 3] = map[0x3F & this.buf];
        this.line_length += 4;
        this.buf = 0;
        this.buf_bytes = 0;
    }

    private void encode_partial_token() {
        int i = this.line_length;
        this.line[i] = map[0x3F & this.buf >> 18];
        this.line[i + 1] = map[0x3F & this.buf >> 12];
        this.line[i + 2] = this.buf_bytes == 1 ? 61 : map[0x3F & this.buf >> 6];
        this.line[i + 3] = this.buf_bytes <= 2 ? 61 : map[0x3F & this.buf];
        this.line_length += 4;
        this.buf = 0;
        this.buf_bytes = 0;
    }

    private void flush_line() {
        this.out.append(this.line, 0, this.line_length);
        this.line_length = 0;
    }

    public final void translate(byte[] in) {
        int i;
        int in_length = in.length;
        for (i = 0; i < in_length; ++i) {
            this.buf = this.buf_bytes == 0 ? this.buf & 0xFFFF | in[i] << 16 : (this.buf_bytes == 1 ? this.buf & 0xFF00FF | in[i] << 8 & 0xFFFF : this.buf & 0xFFFF00 | in[i] & 0xFF);
            if (++this.buf_bytes == 3) {
                this.encode_token();
                if (this.line_length >= 72) {
                    this.flush_line();
                }
            }
            if (i != in_length - 1) continue;
            if (this.buf_bytes > 0 && this.buf_bytes < 3) {
                this.encode_partial_token();
            }
            if (this.line_length <= 0) continue;
            this.flush_line();
        }
        for (i = 0; i < this.line.length; ++i) {
            this.line[i] = '\u0000';
        }
    }

    public char[] getCharArray() {
        if (this.buf_bytes != 0) {
            this.encode_partial_token();
        }
        this.flush_line();
        for (int i = 0; i < this.line.length; ++i) {
            this.line[i] = '\u0000';
        }
        char[] ch = new char[this.out.length()];
        if (this.out.length() > 0) {
            this.out.getChars(0, this.out.length(), ch, 0);
        }
        return ch;
    }

    public void reset() {
        this.out.setLength(0);
    }
}

