/*
 * Decompiled with CFR 0.152.
 */
package org.exist.util;

public class ByteConversion {
    public static final int byteToInt(byte[] data, int start) {
        return data[start] & 0xFF | (data[start + 1] & 0xFF) << 8 | (data[start + 2] & 0xFF) << 16 | (data[start + 3] & 0xFF) << 24;
    }

    public static final long byteToLong(byte[] data, int start) {
        return ((long)data[start] & 0xFFL) << 56 | ((long)data[start + 1] & 0xFFL) << 48 | ((long)data[start + 2] & 0xFFL) << 40 | ((long)data[start + 3] & 0xFFL) << 32 | ((long)data[start + 4] & 0xFFL) << 24 | ((long)data[start + 5] & 0xFFL) << 16 | ((long)data[start + 6] & 0xFFL) << 8 | (long)data[start + 7] & 0xFFL;
    }

    public static final short byteToShort(byte[] data, int start) {
        return (short)((data[start + 1] & 0xFF) << 8 | data[start] & 0xFF);
    }

    public static final byte[] intToByte(int v, byte[] data, int start) {
        data[start] = (byte)(v >>> 0 & 0xFF);
        data[start + 1] = (byte)(v >>> 8 & 0xFF);
        data[start + 2] = (byte)(v >>> 16 & 0xFF);
        data[start + 3] = (byte)(v >>> 24 & 0xFF);
        return data;
    }

    public static final byte[] longToByte(long v, byte[] data, int start) {
        data[start + 7] = (byte)(v >>> 0 & 0xFFL);
        data[start + 6] = (byte)(v >>> 8 & 0xFFL);
        data[start + 5] = (byte)(v >>> 16 & 0xFFL);
        data[start + 4] = (byte)(v >>> 24 & 0xFFL);
        data[start + 3] = (byte)(v >>> 32 & 0xFFL);
        data[start + 2] = (byte)(v >>> 40 & 0xFFL);
        data[start + 1] = (byte)(v >>> 48 & 0xFFL);
        data[start] = (byte)(v >>> 56 & 0xFFL);
        return data;
    }

    public static final byte[] longToByte(long v) {
        byte[] data = new byte[8];
        data[7] = (byte)(v >>> 0 & 0xFFL);
        data[6] = (byte)(v >>> 8 & 0xFFL);
        data[5] = (byte)(v >>> 16 & 0xFFL);
        data[4] = (byte)(v >>> 24 & 0xFFL);
        data[3] = (byte)(v >>> 32 & 0xFFL);
        data[2] = (byte)(v >>> 40 & 0xFFL);
        data[1] = (byte)(v >>> 48 & 0xFFL);
        data[0] = (byte)(v >>> 56 & 0xFFL);
        return data;
    }

    public static final byte[] shortToByte(short v, byte[] data, int start) {
        data[start] = (byte)(v >>> 0 & 0xFF);
        data[start + 1] = (byte)(v >>> 8 & 0xFF);
        return data;
    }

    public static final byte[] shortToByte(short v) {
        byte[] data = new byte[]{(byte)(v >>> 0 & 0xFF), (byte)(v >>> 8 & 0xFF)};
        return data;
    }
}

