/*
 * Decompiled with CFR 0.152.
 */
package org.exist.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class GlobToRegex {
    private static boolean __isPerl5MetaCharacter(char ch) {
        return ch == '*' || ch == '?' || ch == '+' || ch == '[' || ch == ']' || ch == '(' || ch == ')' || ch == '|' || ch == '^' || ch == '$' || ch == '.' || ch == '{' || ch == '}' || ch == '\\';
    }

    private static boolean __isGlobMetaCharacter(char ch) {
        return ch == '*' || ch == '?' || ch == '[' || ch == ']';
    }

    public static String globToRegexp(CharSequence pattern) {
        boolean starCannotMatchNull = false;
        StringBuffer buffer = new StringBuffer(2 * pattern.length());
        boolean inCharSet = false;
        block11: for (int ch = 0; ch < pattern.length(); ++ch) {
            char c = pattern.charAt(ch);
            switch (c) {
                case '*': {
                    if (inCharSet) {
                        buffer.append('*');
                        continue block11;
                    }
                    buffer.append(".*");
                    continue block11;
                }
                case '?': {
                    if (inCharSet) {
                        buffer.append('?');
                        continue block11;
                    }
                    buffer.append(".?");
                    continue block11;
                }
                case '[': {
                    inCharSet = true;
                    buffer.append(c);
                    if (ch + 1 >= pattern.length()) continue block11;
                    switch (pattern.charAt(ch + 1)) {
                        case '!': 
                        case '^': {
                            buffer.append('^');
                            ++ch;
                            continue block11;
                        }
                        case ']': {
                            buffer.append(']');
                            ++ch;
                            continue block11;
                        }
                    }
                    continue block11;
                }
                case ']': {
                    inCharSet = false;
                    buffer.append(c);
                    continue block11;
                }
                case '\\': {
                    buffer.append('\\');
                    if (ch == pattern.length() - 1) {
                        buffer.append('\\');
                        continue block11;
                    }
                    if (GlobToRegex.__isGlobMetaCharacter(pattern.charAt(ch + 1))) {
                        buffer.append(pattern.charAt(++ch));
                        continue block11;
                    }
                    buffer.append('\\');
                    continue block11;
                }
                default: {
                    if (!inCharSet && GlobToRegex.__isPerl5MetaCharacter(c)) {
                        buffer.append('\\');
                    }
                    buffer.append(c);
                }
            }
        }
        return buffer.toString();
    }

    public static void main(String[] args) {
        String glob = "[gG]enerate? ";
        String re = GlobToRegex.globToRegexp(glob);
        String str = "This is generated text";
        Pattern pattern = Pattern.compile(re);
        Matcher matcher = pattern.matcher(str);
        boolean match = matcher.find();
        System.out.println(str.substring(matcher.start(), matcher.end()));
    }
}

